/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.semver.vcs;

import com.github.zafarkhaja.semver.Version;
import java.util.Arrays;
import java.util.Objects;
import org.ajoberstar.semver.vcs.Versioner;

public final class Stage
implements Comparable<Stage> {
    private static final String FINAL_NAME = "final";
    private final String name;
    private final Versioner versioner;

    public Stage(String name, Versioner versioner) {
        Objects.requireNonNull(name);
        Objects.requireNonNull(versioner);
        this.name = name;
        this.versioner = versioner;
    }

    public String getName() {
        return this.name;
    }

    public Versioner getVersioner() {
        return this.versioner;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Stage) {
            Stage that = (Stage)obj;
            return this.getName().equals(that.getName());
        }
        return false;
    }

    public int hashCode() {
        return this.getName().hashCode();
    }

    @Override
    public int compareTo(Stage that) {
        if (this.getName().equals(that.getName())) {
            return 0;
        }
        if (this.getName().equals(FINAL_NAME)) {
            return 1;
        }
        if (that.getName().equals(FINAL_NAME)) {
            return -1;
        }
        return this.getName().compareTo(that.getName());
    }

    public static Stage finalStage() {
        return new Stage(FINAL_NAME, (base, vcs) -> Version.valueOf((String)base.getNormalVersion()));
    }

    public static Stage fixedStage(String name) {
        return new Stage(name, (base, vcs) -> {
            Version sanitized = Stage.sanitizeStage(base, name, true);
            String previousStage = sanitized.getPreReleaseVersion().split("\\.")[0];
            if (name.equals(previousStage)) {
                return sanitized.incrementPreReleaseVersion();
            }
            return base.setPreReleaseVersion(name).incrementPreReleaseVersion();
        });
    }

    public static Stage floatingStage(String name) {
        return new Stage(name, (base, vcs) -> {
            Version sanitized = Stage.sanitizeStage(base, name, false);
            Object[] prevStages = sanitized.getPreReleaseVersion().split("\\.");
            if (Arrays.binarySearch(prevStages, name) >= 0) {
                return sanitized.incrementPreReleaseVersion();
            }
            if (name.compareTo((String)prevStages[0]) > 0) {
                return sanitized.setPreReleaseVersion(name).incrementPreReleaseVersion();
            }
            return sanitized.setPreReleaseVersion(sanitized.getPreReleaseVersion() + "." + name).incrementPreReleaseVersion();
        });
    }

    public static Stage snapshotStage() {
        return new Stage("snapshot", (base, vcs) -> base.setPreReleaseVersion("SNAPSHOT"));
    }

    private static Version sanitizeStage(Version inferred, String stage, boolean fixed) {
        int limit;
        String[] rawIdents = inferred.getPreReleaseVersion().split("\\.");
        int rawEndIndex = Stage.getEndIndex(rawIdents, 0);
        if (stage.equals(rawIdents[0])) {
            limit = 2;
        } else if (!fixed) {
            limit = rawIdents.length > 2 && stage.equals(rawIdents[2]) ? 4 : 2;
        } else {
            return Version.valueOf((String)inferred.getNormalVersion());
        }
        int endIndex = Math.min(rawEndIndex, limit);
        CharSequence[] validIdents = Arrays.copyOfRange(rawIdents, 0, endIndex);
        String preRelease = String.join((CharSequence)".", validIdents);
        if (preRelease == null || preRelease.isEmpty()) {
            return inferred;
        }
        return inferred.setPreReleaseVersion(preRelease);
    }

    private static int getEndIndex(String[] array, int index) {
        if (array.length > index) {
            boolean isValid = index % 2 == 0 || array[index].chars().allMatch(Character::isDigit);
            return isValid ? Stage.getEndIndex(array, index + 1) : index;
        }
        return index;
    }
}

