/*
 * Decompiled with CFR 0.152.
 */
package org.ajoberstar.semver.vcs;

import com.github.zafarkhaja.semver.Version;
import java.util.function.UnaryOperator;
import org.ajoberstar.semver.vcs.Versioner;

public enum Scope {
    MAJOR(Version::incrementMajorVersion),
    MINOR(Version::incrementMinorVersion),
    PATCH(Version::incrementPatchVersion);

    private final Versioner versioner = (base, vcs) -> {
        Version prevVersion = vcs.getPreviousVersion().orElse(base);
        Version prevRelease = vcs.getPreviousRelease().orElse(base);
        Version incremented = (Version)incrementer.apply(prevRelease);
        if (incremented.getNormalVersion().equals(prevVersion.getNormalVersion())) {
            return prevVersion;
        }
        return incremented;
    };

    private Scope(UnaryOperator<Version> incrementer) {
    }

    public Versioner getVersioner() {
        return this.versioner;
    }
}

