/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipException;

public class JarBuilder {
    private static final int BUFF_SIZE = 32768;
    private byte[] buffer = new byte[32768];
    protected boolean verbose = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void build(List srcNames, String mainClass, String dstJar) throws IOException {
        String source2 = null;
        JarOutputStream jarOut = null;
        Manifest manifest = new Manifest();
        manifest.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        manifest.getMainAttributes().put(Attributes.Name.MAIN_CLASS, mainClass);
        jarOut = new JarOutputStream((OutputStream)new FileOutputStream(dstJar), manifest);
        boolean throwing = false;
        try {
            if (srcNames != null) {
                for (String source2 : srcNames) {
                    File fsource = new File(source2);
                    String base = this.getBasePathInJarOut(source2);
                    if (!fsource.exists()) {
                        throwing = true;
                        throw new FileNotFoundException(fsource.getAbsolutePath());
                    }
                    if (fsource.isDirectory()) {
                        this.addDirectory(jarOut, base, fsource, 0);
                        continue;
                    }
                    this.addFileStream(jarOut, base, fsource);
                }
            }
        }
        finally {
            block12: {
                try {
                    jarOut.close();
                }
                catch (ZipException z) {
                    if (throwing) break block12;
                    throw new IOException(z.toString());
                }
            }
        }
    }

    protected String fileExtension(String file) {
        int leafPos = file.lastIndexOf(47);
        if (leafPos == file.length() - 1) {
            return "";
        }
        String leafName = file.substring(leafPos + 1);
        int dotPos = leafName.lastIndexOf(46);
        if (dotPos == -1) {
            return "";
        }
        String ext = leafName.substring(dotPos + 1);
        return ext;
    }

    protected String getBasePathInJarOut(String sourceFile) {
        String ext = this.fileExtension(sourceFile);
        if (ext.equals("class")) {
            return "classes/";
        }
        if (ext.equals("jar") || ext.equals("zip")) {
            return "lib/";
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addNamedStream(JarOutputStream dst, String name, InputStream in) throws IOException {
        block9: {
            if (this.verbose) {
                System.err.println("JarBuilder.addNamedStream " + name);
            }
            try {
                dst.putNextEntry(new JarEntry(name));
                int bytesRead = 0;
                while ((bytesRead = in.read(this.buffer, 0, 32768)) != -1) {
                    dst.write(this.buffer, 0, bytesRead);
                }
            }
            catch (ZipException ze) {
                if (ze.getMessage().indexOf("duplicate entry") >= 0) {
                    if (this.verbose) {
                        System.err.println(ze + " Skip duplicate entry " + name);
                    }
                    break block9;
                }
                throw ze;
            }
            finally {
                in.close();
                dst.flush();
                dst.closeEntry();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addFileStream(JarOutputStream dst, String jarBaseName, File file) throws IOException {
        try (FileInputStream in = new FileInputStream(file);){
            String name = jarBaseName + file.getName();
            this.addNamedStream(dst, name, in);
        }
    }

    void addDirectory(JarOutputStream dst, String jarBaseName, File dir, int depth) throws IOException {
        File[] contents = dir.listFiles();
        if (contents != null) {
            for (int i = 0; i < contents.length; ++i) {
                Object fBaseName;
                File f = contents[i];
                Object object = fBaseName = depth == 0 ? "" : dir.getName();
                if (jarBaseName.length() > 0) {
                    fBaseName = jarBaseName + "/" + (String)fBaseName;
                }
                if (f.isDirectory()) {
                    this.addDirectory(dst, (String)fBaseName, f, depth + 1);
                    continue;
                }
                this.addFileStream(dst, (String)fBaseName + "/", f);
            }
        }
    }
}

