/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo.codegen;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import org.aion4j.avm.codegenerator.api.testsupport.TestSupportGenerator;
import org.aion4j.avm.codegenerator.util.FileUtil;
import org.aion4j.maven.avm.mojo.codegen.CodeGenBaseMojo;
import org.aion4j.maven.avm.tools.AvmToolsUtil;
import org.aion4j.maven.avm.util.IOUtils;
import org.aion4j.maven.avm.util.JarBuilder;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="generate-test-support", defaultPhase=LifecyclePhase.GENERATE_TEST_SOURCES)
public class AVMTestSupportCodeGenMojo
extends CodeGenBaseMojo {
    @Override
    public void execute() throws MojoExecutionException, MojoFailureException {
        String classesFolder = this.project.getBuild().getOutputDirectory();
        String generatedTestSourcesDir = this.getGeneratedTestSupportSourceDir();
        String tempArchive = this.getTempArchivePath();
        String abiPath = this.getTempAbiPath();
        this.project.addTestCompileSourceRoot(generatedTestSourcesDir);
        String contractMainClass = this.project.getProperties().getProperty("contract.main.class");
        Path tempArchivePath = Paths.get(tempArchive, new String[0]);
        if (!tempArchivePath.toFile().exists()) {
            try {
                Files.createDirectory(Paths.get(tempArchive, new String[0]), new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new MojoExecutionException("Unable to create folder : " + tempArchive);
            }
        }
        this.getLog().debug((CharSequence)("Contract class: " + contractMainClass));
        this.getLog().debug((CharSequence)("Temp Archive path: " + tempArchive));
        this.getLog().debug((CharSequence)("Temp Abi path: " + abiPath));
        this.getLog().debug((CharSequence)("Generated Test Source Dir:" + generatedTestSourcesDir));
        ArrayList<String> jarInputs = new ArrayList<String>();
        jarInputs.add(classesFolder);
        String jarPath = this.getTempJarFile();
        JarBuilder jarBuilder = new JarBuilder();
        try {
            jarBuilder.build(jarInputs, contractMainClass, jarPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Jar creation failed : " + jarPath, (Exception)e);
        }
        byte[] jarContent = new byte[]{};
        try {
            jarContent = IOUtils.readJarContent(this.getTempJarFile());
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read jar file : " + jarPath);
        }
        AvmToolsUtil.abiCompile(this.getLocalAVMClass(), jarContent, abiPath);
        File abiFile = new File(abiPath);
        if (!abiFile.exists()) {
            throw new MojoExecutionException("ABI file is not found : " + abiPath);
        }
        String abiStr = null;
        try {
            abiStr = FileUtil.readFile((String)abiPath);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to read ABI file : " + abiPath, (Exception)e);
        }
        File generatedTestSourceFile = new File(generatedTestSourcesDir);
        if (!generatedTestSourceFile.exists()) {
            generatedTestSourceFile.mkdirs();
        }
        boolean isVerbose = this.getLog().isDebugEnabled();
        TestSupportGenerator testSupportGenerator = new TestSupportGenerator(isVerbose);
        try {
            testSupportGenerator.generate(abiStr, generatedTestSourcesDir);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Could not generate Avm Test Support code", (Exception)e);
        }
    }

    @Override
    protected void preexecuteLocalAvm() throws MojoExecutionException {
    }

    @Override
    protected void executeLocalAvm(ClassLoader avmClassloader, Object localAvmInstance) throws MojoExecutionException {
    }

    @Override
    protected void postExecuteLocalAvm(Object localAvmInstance) throws MojoExecutionException {
    }

    @Override
    protected Object getLocalAvmImplInstance(ClassLoader avmClassloader) {
        return null;
    }
}

