/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.aion4j.avm.helper.util.ConfigUtil;
import org.aion4j.maven.avm.mojo.AVMBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="init", defaultPhase=LifecyclePhase.VALIDATE)
public class AVMInitializeMojo
extends AVMBaseMojo {
    private static final String AVM_RESOURCE_FOLDER = "/lib/avm";
    private static final String AVM_JAR = "avm.jar";
    private static final String AVM_API_JAR = "org-aion-avm-api.jar";
    private static final String AVM_USERLIB_JAR = "org-aion-avm-userlib.jar";
    private static final String AVM_TOOLING_JAR = "org-aion-avm-tooling.jar";
    private static final String VERSION_FILE = "version";

    public void execute() throws MojoExecutionException, MojoFailureException {
        String libFolderPath = this.getAvmLibDir();
        File libFolder = new File(libFolderPath);
        boolean forceCopy = ConfigUtil.getAvmConfigurationBooleanProps((String)"forceCopy", (boolean)false);
        if (!libFolder.exists()) {
            libFolder.mkdirs();
            if (!libFolder.exists()) {
                throw new MojoExecutionException((Object)"Unable to create library folder %s. Please check the directory permission and try again.", libFolderPath, null);
            }
        }
        boolean bundledVersion = false;
        if (!this.checkIfLibExists(AVM_JAR) || forceCopy) {
            this.getLog().info((CharSequence)String.format("Copying default %s to %s folder.", AVM_JAR, this.getAvmLibDir()));
            this.copyLibJar(AVM_JAR, "/lib/avm/avm.jar", this.getAvmLibDir());
            bundledVersion = true;
        }
        if (!this.checkIfLibExists(AVM_API_JAR) || forceCopy) {
            this.getLog().info((CharSequence)String.format("Copying default %s to %s folder.", AVM_API_JAR, this.getAvmLibDir()));
            this.copyLibJar(AVM_API_JAR, "/lib/avm/org-aion-avm-api.jar", this.getAvmLibDir());
        }
        if (!this.checkIfLibExists(AVM_USERLIB_JAR) || forceCopy) {
            this.getLog().info((CharSequence)String.format("Copying default %s to %s folder.", AVM_USERLIB_JAR, this.getAvmLibDir()));
            this.copyLibJar(AVM_USERLIB_JAR, "/lib/avm/org-aion-avm-userlib.jar", this.getAvmLibDir());
        }
        if (!this.checkIfLibExists(AVM_TOOLING_JAR) || forceCopy) {
            this.getLog().info((CharSequence)String.format("Copying default %s to %s folder.", AVM_TOOLING_JAR, this.getAvmLibDir()));
            this.copyLibJar(AVM_TOOLING_JAR, "/lib/avm/org-aion-avm-tooling.jar", this.getAvmLibDir());
        }
        if ((!this.checkIfLibExists(VERSION_FILE) || forceCopy) && bundledVersion) {
            this.getLog().info((CharSequence)String.format("Copying default %s to %s folder.", VERSION_FILE, this.getAvmLibDir()));
            this.copyLibJar(VERSION_FILE, "/lib/avm/version", this.getAvmLibDir());
        }
    }

    private boolean checkIfLibExists(String libFileName) {
        File libFile = new File(this.avmLibDir, libFileName);
        return libFile.exists();
    }

    private String copyLibJar(String jarName, String jarFilePath, String destFolder) throws MojoExecutionException {
        if (jarFilePath == null) {
            return null;
        }
        String[] chopped = jarFilePath.split("\\/");
        String fileName = chopped[chopped.length - 1];
        InputStream fileStream = null;
        OutputStream out = null;
        try {
            fileStream = AVMInitializeMojo.class.getResourceAsStream(jarFilePath);
            if (fileStream == null) {
                throw new RuntimeException(String.format("%s is not found in the plugin jar. ", jarFilePath));
            }
            File targetFile = new File(destFolder, fileName);
            out = new FileOutputStream(targetFile);
            byte[] buffer = new byte[1024];
            int len = fileStream.read(buffer);
            while (len != -1) {
                out.write(buffer, 0, len);
                len = fileStream.read(buffer);
            }
            String string = targetFile.getAbsolutePath();
            return string;
        }
        catch (IOException e) {
            throw new MojoExecutionException("Error copying " + jarName + "to " + destFolder, (Exception)e);
        }
        finally {
            if (fileStream != null) {
                try {
                    fileStream.close();
                }
                catch (IOException iOException) {}
            }
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

