/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import org.aion4j.avm.helper.api.Log;
import org.aion4j.avm.helper.remote.RemoteAVMNode;
import org.aion4j.avm.helper.util.ConfigUtil;
import org.aion4j.avm.helper.util.ResultCache;
import org.aion4j.maven.avm.impl.DummyLog;
import org.aion4j.maven.avm.impl.MavenLog;
import org.aion4j.maven.avm.mojo.AVMBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;
import org.json.JSONObject;

@Mojo(name="get-receipt", aggregator=true)
public class AVMGetReceiptMojo
extends AVMBaseMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isLocal()) {
            throw new MojoExecutionException("aion4j:get-receipt is only supported for remote Aion kernel");
        }
        String web3RpcUrl = this.resolveWeb3rpcUrl();
        String txHash = ConfigUtil.getProperty((String)"txHash");
        String tail = ConfigUtil.getProperty((String)"tail");
        String silent = ConfigUtil.getProperty((String)"silent");
        String cachedTxHash = null;
        if (txHash == null || txHash.isEmpty()) {
            cachedTxHash = this.getCache().getLastTxnReceipt();
            if (cachedTxHash == null || cachedTxHash.isEmpty()) {
                this.printHelp();
                throw new MojoExecutionException("Invalid args. \"txHash\" property is missing");
            }
            txHash = cachedTxHash;
        }
        AVMGetReceiptMojo.startGetReceipt(web3RpcUrl, txHash, tail, silent, this.getCache(), this.getLog());
    }

    public static void startGetReceipt(String web3RpcUrl, String txHash, String tail, String silent, ResultCache cache, org.apache.maven.plugin.logging.Log log) throws MojoExecutionException, MojoFailureException {
        boolean enableTail = false;
        if (tail != null && !tail.isEmpty()) {
            enableTail = true;
        }
        int counter = 0;
        int maxCountrer = 1;
        boolean gotReceipt = false;
        if (enableTail) {
            maxCountrer = 15;
        }
        while (counter < maxCountrer) {
            try {
                Object _log = null;
                _log = enableTail && silent != null && !silent.isEmpty() ? new DummyLog() : MavenLog.getLog(log);
                RemoteAVMNode remoteAVMNode = new RemoteAVMNode(web3RpcUrl, (Log)_log);
                JSONObject response = remoteAVMNode.getReceipt(txHash);
                JSONObject resultObj = response.optJSONObject("result");
                ++counter;
                if (resultObj == null) {
                    if (enableTail) {
                        log.info((CharSequence)("Waiting for transaction to mine ...Trying (" + counter + " of " + maxCountrer + " times)"));
                        Thread.currentThread();
                        Thread.sleep(9000L);
                        continue;
                    }
                } else {
                    String status;
                    String contractAddress = resultObj.optString("contractAddress");
                    if (contractAddress != null && !contractAddress.isEmpty()) {
                        cache.updateDeployAddress(contractAddress);
                    }
                    if ("0x0".equals(status = resultObj.optString("status"))) {
                        throw new MojoFailureException("Transaction could not be processed.");
                    }
                }
                log.info((CharSequence)"Txn Receipt: \n");
                if (resultObj != null) {
                    log.info((CharSequence)resultObj.toString(2));
                } else {
                    log.info((CharSequence)response.toString());
                }
                gotReceipt = true;
                break;
            }
            catch (Exception e) {
                log.debug((Throwable)e);
                throw new MojoExecutionException(e.getMessage(), e);
            }
        }
        if (counter == maxCountrer && !gotReceipt) {
            log.info((CharSequence)"Waited too long for the receipt, something is wrong.");
        }
    }

    private void printHelp() {
        this.getLog().error((CharSequence)"Usage:");
        this.getLog().error((CharSequence)"mvn aion4j:getReceipt -Dweb3rpc.url=http://host:port -DtxHash=<tx-hash>");
    }
}

