/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.aion4j.avm.helper.util.ConfigUtil;
import org.aion4j.avm.helper.util.ResultCache;
import org.aion4j.maven.avm.mojo.AVMBaseMojo;
import org.aion4j.maven.avm.util.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="get-cache", aggregator=true)
public class AVMGetCache
extends AVMBaseMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        String outputPath = ConfigUtil.getProperty((String)"output");
        String lastDeployedAddress = this.getCache().getLastDeployedAddress();
        boolean debugEnabled = this.getCache().getDebugEnabledInLastDeploy();
        String lastDeployTxnReceipt = this.getCache().getLastDeployTxnReceipt();
        String lastTxnReceipt = this.getCache().getLastTxnReceipt();
        this.getLog().info((CharSequence)("Last deploy Address       : " + lastDeployedAddress));
        this.getLog().info((CharSequence)("Last deploy debug enabled : " + debugEnabled));
        this.getLog().info((CharSequence)("Last deploy txn receipt   : " + lastDeployTxnReceipt));
        this.getLog().info((CharSequence)("Last txn receipt          : " + lastTxnReceipt));
        if (!StringUtils.isEmpty(outputPath)) {
            Properties props = new Properties();
            if (lastDeployedAddress != null) {
                props.put(ResultCache.DEPLOY_ADDRESS, lastDeployedAddress);
            }
            props.put(ResultCache.LAST_DEPLOY_DEBUG_ENABLE, String.valueOf(debugEnabled));
            if (lastDeployTxnReceipt != null) {
                props.put(ResultCache.DEPLOY_TX_RECEIPT, lastDeployTxnReceipt);
            }
            if (lastTxnReceipt != null) {
                props.put(ResultCache.TX_RECEIPT, lastTxnReceipt);
            }
            try {
                try (FileOutputStream output = new FileOutputStream(outputPath);){
                    props.store(output, null);
                    this.getLog().info((CharSequence)("Output written to : " + outputPath));
                }
                catch (IOException io) {
                    this.getLog().debug((CharSequence)"Error writing output to file", (Throwable)io);
                    this.getLog().warn((CharSequence)("Unable to write output to file : " + outputPath));
                }
            }
            catch (Exception e) {
                this.getLog().debug((Throwable)e);
            }
        }
    }
}

