/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.aion4j.avm.helper.api.Log;
import org.aion4j.avm.helper.remote.RemoteAVMNode;
import org.aion4j.avm.helper.util.CryptoUtil;
import org.aion4j.maven.avm.adapter.LocalAvmAdapter;
import org.aion4j.maven.avm.impl.MavenLog;
import org.aion4j.maven.avm.mojo.AVMLocalRuntimeBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="get-balance", aggregator=true)
public class AVMGetBalanceMojo
extends AVMLocalRuntimeBaseMojo {
    @Override
    protected void preexecuteLocalAvm() throws MojoExecutionException {
    }

    @Override
    protected void executeLocalAvm(ClassLoader avmClassloader, Object localAvmInstance) throws MojoExecutionException {
        try {
            LocalAvmAdapter localAvmAdapter = new LocalAvmAdapter(localAvmInstance);
            String address = this.getAddress();
            if (address == null || address.isEmpty()) {
                address = this.getLocalDefaultAddress();
            }
            if (address == null || address.isEmpty()) {
                this.getLog().error((CharSequence)"Usage: \n ./mvnw aion4j:get-balance -Daddress=a0xxxxxxxxxx");
                throw new MojoExecutionException("Please provide -Daddress property");
            }
            BigInteger balance = localAvmAdapter.getBalance(address);
            if (balance != null) {
                BigDecimal aionValue = CryptoUtil.ampToAion((BigInteger)balance);
                this.getLog().info((CharSequence)("Address        : " + address));
                this.getLog().info((CharSequence)String.format("Balance        : %s nAmp (%s Aion)", balance, String.format("%.12f", Float.valueOf(aionValue.floatValue()))));
            } else {
                this.getLog().info((CharSequence)"Balance not found");
            }
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)"getBalance failed", (Throwable)ex);
            throw new MojoExecutionException("getBalance failed", ex);
        }
    }

    @Override
    protected void executeRemote() throws MojoExecutionException {
        String web3RpcUrl = this.resolveWeb3rpcUrl();
        String address = this.getAddress();
        if (address == null || address.isEmpty()) {
            this.printRemoteHelp();
            throw new MojoExecutionException("Invalid args");
        }
        RemoteAVMNode remoteAVMNode = new RemoteAVMNode(web3RpcUrl, (Log)MavenLog.getLog(this.getLog()));
        String balanceInHex = remoteAVMNode.getBalance(address);
        if (balanceInHex != null && !balanceInHex.trim().isEmpty()) {
            if (balanceInHex.startsWith("0x")) {
                balanceInHex = balanceInHex.substring(2);
            }
            BigInteger balance = new BigInteger(balanceInHex, 16);
            BigDecimal aionValue = CryptoUtil.ampToAion((BigInteger)balance);
            this.getLog().info((CharSequence)String.format("Address   :  %s", address));
            this.getLog().info((CharSequence)String.format("Balance   :  %s nAmp (%s Aion)", balance, String.format("%.12f", Float.valueOf(aionValue.floatValue()))));
        } else {
            this.getLog().info((CharSequence)"Balance not found for the account");
        }
    }

    private void printRemoteHelp() {
        this.getLog().error((CharSequence)"Usage:");
        this.getLog().error((CharSequence)"mvn aion4j:get-balance -Dweb3rpc.url=http://host:port -Daddress=<address>");
    }
}

