/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import java.lang.reflect.Method;
import java.math.BigInteger;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.aion4j.avm.helper.api.Log;
import org.aion4j.avm.helper.remote.RemoteAVMNode;
import org.aion4j.avm.helper.util.ConfigUtil;
import org.aion4j.maven.avm.impl.MavenLog;
import org.aion4j.maven.avm.mojo.AVMGetReceiptMojo;
import org.aion4j.maven.avm.mojo.AVMLocalRuntimeBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;

@Mojo(name="deploy", requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME)
public class AVMDeployMojo
extends AVMLocalRuntimeBaseMojo {
    private long defaultGas = 5000000L;
    private long defaultGasPrice = 100000000000L;
    private String deployArgs;
    private String value;
    private BigInteger valueB;

    @Override
    protected void preexecuteLocalAvm() throws MojoExecutionException {
    }

    private boolean validateDappJar() throws MojoExecutionException {
        Path path = Paths.get(this.getDappJar(), new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            MavenProject project = (MavenProject)this.getPluginContext().get("project");
            if (project.getModules().size() > 0) {
                return false;
            }
            throw new MojoExecutionException(String.format("Contract jar file doesn't exist : %s \nPlease make sure you have built the project.", this.dappJar));
        }
        return true;
    }

    @Override
    protected void executeLocalAvm(ClassLoader avmClassloader, Object localAvmInstance) throws MojoExecutionException {
        try {
            if (!this.validateDappJar()) {
                return;
            }
            String deployer = this.getAddress();
            this.parseArgs();
            Method deployMethod = localAvmInstance.getClass().getMethod("deploy", String.class, String.class, String.class, BigInteger.class);
            Object[] args = new Object[]{new String[]{this.dappJar}, deployer};
            this.getLog().info((CharSequence)String.format("Deploying %s to the embedded Avm ...", this.getDappJar()));
            if (deployer != null && !deployer.trim().isEmpty()) {
                this.getLog().info((CharSequence)("Deployer address : " + deployer));
            } else {
                deployer = this.getLocalDefaultAddress();
            }
            this.getLog().info((CharSequence)("Avm storage path : " + this.getStoragePath()));
            Object response = deployMethod.invoke(localAvmInstance, this.dappJar, this.deployArgs, deployer, this.valueB);
            Method getAddressMethod = response.getClass().getMethod("getAddress", new Class[0]);
            Method getEnergyUsed = response.getClass().getMethod("getEnergyUsed", new Class[0]);
            String dappAddress = (String)getAddressMethod.invoke(response, new Object[0]);
            this.getLog().info((CharSequence)"****************  Dapp deployment status ****************");
            this.getLog().info((CharSequence)("Contract Address: " + dappAddress));
            this.getLog().info((CharSequence)("Energy used: " + getEnergyUsed.invoke(response, new Object[0])));
            this.getLog().info((CharSequence)("Deployer Address: " + deployer));
            this.getLog().info((CharSequence)"*********************************************************");
            this.getLog().info((CharSequence)String.format("%s was deployed successfully to the embedded AVM.", this.getDappJar()));
            this.getCache().updateDeployAddress(dappAddress);
        }
        catch (Exception ex) {
            this.getLog().error((CharSequence)String.format("%s could not be deployed to the embedded AVM.", this.getDappJar()), (Throwable)ex);
            throw new MojoExecutionException("Contract jar deployment failed", ex);
        }
    }

    @Override
    protected void executeRemote() throws MojoExecutionException {
        long gasPrice;
        if (!this.validateDappJar()) {
            return;
        }
        String web3RpcUrl = this.resolveWeb3rpcUrl();
        String address = this.getAddress();
        String password = ConfigUtil.getProperty((String)"password");
        String pk = this.getPrivateKey();
        if ((pk == null || pk.isEmpty()) && (address == null || address.isEmpty())) {
            this.printRemoteHelp();
            this.getLog().error((CharSequence)"Deployer address cannot be null. Please set it through -D option in maven commandline.");
            throw new MojoExecutionException("Invalid args. Please set deployer address through -D option or environment variable.");
        }
        this.parseArgs();
        long gas = this.getGas();
        if (gas == 0L) {
            gas = this.defaultGas;
        }
        if ((gasPrice = this.getGasPrice()) == 0L) {
            gasPrice = this.defaultGasPrice;
        }
        try {
            Class localAvmClazz = this.getLocalAVMClass();
            Method getBytesMethod = localAvmClazz.getMethod("getBytesForDeploy", String.class, String.class);
            String hexCode = (String)getBytesMethod.invoke(null, this.dappJar, this.deployArgs);
            if (hexCode == null) {
                throw new MojoExecutionException("Error getting contract jar content");
            }
            RemoteAVMNode remoteAVMNode = new RemoteAVMNode(web3RpcUrl, (Log)MavenLog.getLog(this.getLog()));
            String txHash = null;
            if (pk != null && !pk.isEmpty()) {
                txHash = remoteAVMNode.sendDeployRawTransaction(null, pk, hexCode, this.valueB, gas, gasPrice);
            } else {
                boolean status;
                if (password != null && !password.isEmpty() && (status = remoteAVMNode.unlock(address, password))) {
                    this.getLog().info((CharSequence)"Account unlocked successfully");
                }
                txHash = remoteAVMNode.deploy(address, hexCode, gas, gasPrice);
            }
            this.getLog().info((CharSequence)String.format("%s was deployed successfully.", this.dappJar));
            this.getLog().info((CharSequence)String.format("Transaction # : %s", txHash));
            this.getCache().updateDeployTxnReceipt(txHash);
            String wait = ConfigUtil.getProperty((String)"wait");
            boolean enableWait = false;
            if (wait != null && !wait.isEmpty()) {
                enableWait = true;
            }
            if (enableWait) {
                AVMGetReceiptMojo.startGetReceipt(web3RpcUrl, txHash, "tail", "silent", this.getCache(), this.getLog());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new MojoExecutionException("Failed deployment for contract : " + this.dappJar, e);
        }
    }

    private void parseArgs() throws MojoExecutionException {
        String artifactId;
        MavenProject project;
        Object[] args = new Object[5];
        this.deployArgs = ConfigUtil.getProperty((String)"args");
        if ((this.deployArgs == null || this.deployArgs.trim().length() == 0) && (project = (MavenProject)this.getPluginContext().get("project")) != null && (artifactId = project.getArtifactId()) != null && artifactId.trim().length() != 0) {
            this.deployArgs = ConfigUtil.getProperty((String)(artifactId + ".args"));
        }
        this.value = ConfigUtil.getProperty((String)"value");
        this.valueB = this.value == null || this.value.isEmpty() ? BigInteger.ZERO : new BigInteger(this.value.trim());
    }

    private void printRemoteHelp() {
        this.getLog().error((CharSequence)"Usage:");
        this.getLog().error((CharSequence)"mvn aion4j:deploy -Dweb3rpc.url=<web3rpcUrl> [-Daddress=<address>] [-Dpassword=<password>]\n");
    }
}

