/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.mashape.unirest.http.HttpResponse;
import com.mashape.unirest.http.Unirest;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import org.aion4j.avm.helper.api.Log;
import org.aion4j.avm.helper.cache.global.AccountCache;
import org.aion4j.avm.helper.cache.global.GlobalCache;
import org.aion4j.avm.helper.crypto.Account;
import org.aion4j.avm.helper.crypto.AccountGenerator;
import org.aion4j.avm.helper.exception.RemoteAvmCallException;
import org.aion4j.avm.helper.faucet.FaucetService;
import org.aion4j.avm.helper.remote.RemoteAvmAdapter;
import org.aion4j.avm.helper.util.ConfigUtil;
import org.aion4j.avm.helper.util.CryptoUtil;
import org.aion4j.avm.helper.util.StringUtils;
import org.aion4j.maven.avm.adapter.LocalAvmAdapter;
import org.aion4j.maven.avm.impl.DummyLog;
import org.aion4j.maven.avm.impl.MavenLog;
import org.aion4j.maven.avm.mojo.AVMLocalRuntimeBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;

@Mojo(name="account", aggregator=true)
public class AVMAccountFaucetMojo
extends AVMLocalRuntimeBaseMojo {
    private static final String FAUCET_WEB_URL = "http://faucet-web.aion4j.org/";
    private static final String FAUCET_CONTRACT_ADDRESS_URL = "https://bloxbean.github.io/aion4j-release/faucet-contract";
    private static final String DEFAULT_FAUCET_CONTRACT_ADDRESS = "0xa055dc67cd05d013a0b7c064708a0eb86e31c5edbaf00bca645665217779d9f2";
    private long defaultGas = 2000000L;
    private long defaultGasPrice = 100000000000L;

    public AVMAccountFaucetMojo() {
        Unirest.setObjectMapper((com.mashape.unirest.http.ObjectMapper)new com.mashape.unirest.http.ObjectMapper(){
            ObjectMapper mapper = new ObjectMapper();

            public String writeValue(Object value) {
                try {
                    return this.mapper.writeValueAsString(value);
                }
                catch (JsonProcessingException e) {
                    e.printStackTrace();
                    return null;
                }
            }

            public <T> T readValue(String value, Class<T> valueType) {
                try {
                    return (T)this.mapper.readValue(value, valueType);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return null;
                }
            }
        });
    }

    @Override
    public void executeRemote() throws MojoExecutionException {
        boolean isTopUp = ConfigUtil.getAvmConfigurationBooleanProps((String)"topup", (boolean)false);
        boolean isCreate = ConfigUtil.getAvmConfigurationBooleanProps((String)"create", (boolean)false);
        boolean isList = ConfigUtil.getAvmConfigurationBooleanProps((String)"list", (boolean)false);
        boolean isListClear = ConfigUtil.getAvmConfigurationBooleanProps((String)"list-clear", (boolean)false);
        boolean isListWithBalance = ConfigUtil.getAvmConfigurationBooleanProps((String)"list-with-balance", (boolean)false);
        this.getLog().info((CharSequence)"Mode : remote (Aion Kernel)");
        if (isListClear) {
            this.clearAccountCache();
            return;
        }
        if (isList) {
            if (isTopUp || isCreate) {
                this.getLog().warn((CharSequence)"You can not use other commands with 'list'.");
            }
            this.showAccountListFromCache(false);
            return;
        }
        if (isListWithBalance) {
            if (isTopUp || isCreate) {
                this.getLog().warn((CharSequence)"You can not use other commands with 'list-with-balance'.");
            }
            this.showAccountListFromCache(true);
            return;
        }
        String address = null;
        String pk = null;
        if (isCreate) {
            Account accountObj = this.generateClientSideAccount();
            address = accountObj.getAddress();
            pk = accountObj.getPrivateKey();
            this.writeAccountToCache(address, pk);
        }
        if (isTopUp) {
            this.web3rpcUrl = this.resolveWeb3rpcUrl();
            if (!isCreate) {
                address = this.getAddress();
                if (address == null || address.trim().length() == 0) {
                    throw new MojoExecutionException("Address can not be null. Please provide -Daddress=<address> or set the 'address' environment variable.");
                }
                pk = ConfigUtil.getProperty((String)"pk");
                if (pk == null || pk.trim().length() == 0) {
                    throw new MojoExecutionException("Private key can not be null. Please provide private key through -Dpk=<private key> option");
                }
            }
            this.executeTopup(address, pk);
        }
    }

    private void clearAccountCache() {
        GlobalCache globalCache = this.getGlobalAccountCache();
        globalCache.clearAccountCache();
        this.getLog().info((CharSequence)"Account list was cleared successfully");
    }

    private void writeAccountToCache(String address, String pk) {
        boolean ignoreCache = ConfigUtil.getAvmConfigurationBooleanProps((String)"ignore-cache", (boolean)false);
        if (!ignoreCache) {
            GlobalCache globalCache = this.getGlobalAccountCache();
            AccountCache accountCache = globalCache.getAccountCache();
            accountCache.addAccount(new Account(address, pk));
            globalCache.setAccountCache(accountCache);
        }
    }

    private void showAccountListFromCache(boolean showBalance) throws MojoExecutionException {
        GlobalCache globalCache;
        AccountCache accountCache;
        List accountList;
        RemoteAvmAdapter remoteAvmAdapter = null;
        if (showBalance) {
            this.web3rpcUrl = this.resolveWeb3rpcUrl();
            remoteAvmAdapter = new RemoteAvmAdapter(this.web3rpcUrl, (Log)new DummyLog());
        }
        if ((accountList = (accountCache = (globalCache = this.getGlobalAccountCache()).getAccountCache()).getAccounts()).size() > 0) {
            this.getLog().info((CharSequence)"Accounts :");
            int index = 0;
            for (Account account : accountList) {
                this.getLog().info((CharSequence)("Account #" + ++index));
                this.getLog().info((CharSequence)("    Address    : " + account.getAddress()));
                this.getLog().info((CharSequence)("    Private key: " + account.getPrivateKey()));
                if (!showBalance) continue;
                BigInteger balance = null;
                try {
                    balance = remoteAvmAdapter.getBalance(account.getAddress());
                    BigDecimal aionValue = CryptoUtil.ampToAion((BigInteger)balance);
                    this.getLog().info((CharSequence)String.format("    Balance    : %s nAmp (%s Aion)", balance, String.format("%.12f", Float.valueOf(aionValue.floatValue()))));
                }
                catch (Exception e) {
                    this.getLog().debug((CharSequence)("Unable to fetch balance for account: " + account.getAddress()), (Throwable)e);
                    balance = BigInteger.ZERO;
                }
            }
        } else {
            this.getLog().info((CharSequence)"No account to show");
        }
    }

    private GlobalCache getGlobalAccountCache() {
        return new GlobalCache(this.getAccountCacheFolder(), (Log)MavenLog.getLog(this.getLog()));
    }

    private void executeTopup(String account, String pk) throws MojoExecutionException {
        this.getLog().info((CharSequence)"\n");
        this.getLog().info((CharSequence)("Start AION topup for address : " + account));
        this.getLog().info((CharSequence)"##############################################################################################################################");
        this.getLog().info((CharSequence)"You can only send topup request maximum 3 times per account in 24hrs.");
        this.getLog().info((CharSequence)"Your transaction will fail if you exceed that limit.");
        this.getLog().info((CharSequence)"##############################################################################################################################");
        FaucetService faucetService = new FaucetService(this.getLocalAVMClass().getClassLoader(), this.web3rpcUrl, this.getFaucetWebUrl(), this.getFaucetContractAddress(), (Log)MavenLog.getLog(this.getLog()));
        faucetService.setDefaultGas(this.defaultGas);
        faucetService.setDefaultGasPrice(this.defaultGasPrice);
        try {
            faucetService.topup(account, pk);
        }
        catch (RemoteAvmCallException e) {
            throw new MojoExecutionException("Account topup failed", (Exception)((Object)e));
        }
    }

    private Account generateClientSideAccount() {
        Account account = AccountGenerator.newAddress();
        Object address = account.getAddress();
        if (!((String)address).startsWith("0x")) {
            address = "0x" + (String)address;
        }
        this.getLog().info((CharSequence)String.format("Account creation successful", new Object[0]));
        this.getLog().info((CharSequence)("Address : " + (String)address));
        this.getLog().info((CharSequence)("Private Key: " + account.getPrivateKey()));
        return account;
    }

    private String getAccountCacheFolder() {
        File aion4jFolder;
        String home = System.getProperty("user.home");
        File cacheFolder = new File(home);
        if (!cacheFolder.canWrite()) {
            String temp = System.getProperty("java.io.tmpdir");
            File tempFolder = new File(temp);
            if (!tempFolder.canWrite()) {
                this.getLog().warn((CharSequence)"Unable to find a writable folder to keep account list cache");
                return null;
            }
            cacheFolder = tempFolder;
        }
        if (!(aion4jFolder = new File(cacheFolder, ".aion4j")).exists()) {
            aion4jFolder.mkdirs();
        }
        return aion4jFolder.getAbsolutePath();
    }

    private String getFaucetContractAddress() {
        String faucetContract = ConfigUtil.getProperty((String)"faucet.contract");
        if (!StringUtils.isEmpty((String)faucetContract)) {
            return faucetContract;
        }
        String contractAddress = null;
        try {
            HttpResponse response = Unirest.get((String)FAUCET_CONTRACT_ADDRESS_URL).asString();
            if (response.getStatus() == 200) {
                contractAddress = (String)response.getBody();
            }
        }
        catch (Exception e) {
            this.getLog().debug((Throwable)e);
        }
        if (StringUtils.isEmpty(contractAddress) || !contractAddress.startsWith("0x")) {
            this.getLog().debug((CharSequence)("Fetched faucet contract address: " + contractAddress));
            this.getLog().warn((CharSequence)("Unable to fetch faucet contract address. Let's use default faucet contract address : " + DEFAULT_FAUCET_CONTRACT_ADDRESS.substring(0, 10) + "..."));
            return DEFAULT_FAUCET_CONTRACT_ADDRESS;
        }
        this.getLog().info((CharSequence)("Fetched faucet contract address : " + contractAddress));
        this.getLog().debug((CharSequence)("Faucet contract address : " + contractAddress));
        return contractAddress.trim();
    }

    private String getFaucetWebUrl() {
        String faucetWebUrl = ConfigUtil.getProperty((String)"faucet.web.url");
        if (!StringUtils.isEmpty((String)faucetWebUrl)) {
            return faucetWebUrl;
        }
        return FAUCET_WEB_URL;
    }

    @Override
    protected void preexecuteLocalAvm() throws MojoExecutionException {
    }

    @Override
    protected void executeLocalAvm(ClassLoader avmClassloader, Object localAvmInstance) throws MojoExecutionException {
        boolean isTopUp = ConfigUtil.getAvmConfigurationBooleanProps((String)"topup", (boolean)false);
        boolean isCreate = ConfigUtil.getAvmConfigurationBooleanProps((String)"create", (boolean)false);
        boolean isList = ConfigUtil.getAvmConfigurationBooleanProps((String)"list", (boolean)false);
        boolean isListClear = ConfigUtil.getAvmConfigurationBooleanProps((String)"list-clear", (boolean)false);
        boolean isListWithBalance = ConfigUtil.getAvmConfigurationBooleanProps((String)"list-with-balance", (boolean)false);
        String balance = ConfigUtil.getProperty((String)"balance");
        String addressToCreate = ConfigUtil.getProperty((String)"address");
        LocalAvmAdapter localAvmAdapter = new LocalAvmAdapter(localAvmInstance);
        this.getLog().info((CharSequence)"Mode : local (Embedded Avm)");
        if (isListClear) {
            this.clearAccountCache();
            return;
        }
        if (isList) {
            if (isTopUp || isCreate) {
                this.getLog().warn((CharSequence)"You can not use other commands with 'list'.");
            }
            this.showAccountListFromCacheLocal(localAvmAdapter, false);
            return;
        }
        if (isListWithBalance) {
            this.showAccountListFromCacheLocal(localAvmAdapter, true);
            return;
        }
        if (isTopUp) {
            if (StringUtils.isEmpty((String)addressToCreate)) {
                throw new MojoExecutionException("Address cannot be null for topup. \nUsage: mvn aion4j:account -Dtopup -Daddress=<address> -Dbalance=<amount>");
            }
            if (StringUtils.isEmpty((String)balance)) {
                throw new MojoExecutionException("Balance cannot be null for topup. \nUsage: mvn aion4j:account -Dtopup -Daddress=<address> -Dbalance=<amount>");
            }
            this.getLog().info((CharSequence)String.format("Trying to transfer %s to the address ...", balance));
            boolean response = localAvmAdapter.transfer(addressToCreate, new BigInteger(balance));
            if (response) {
                BigInteger newBal = localAvmAdapter.getBalance(addressToCreate);
                this.getLog().info((CharSequence)"Topup was successful.");
                this.getLog().info((CharSequence)("Address   : " + addressToCreate));
                this.getLog().info((CharSequence)("Balance   : " + newBal));
            }
            return;
        }
        try {
            if (isCreate) {
                this.getLog().info((CharSequence)"Generate a new account");
                Account account = AccountGenerator.newAddress();
                addressToCreate = account.getAddress();
                this.writeAccountToCache(account.getAddress(), account.getPrivateKey());
                this.getLog().info((CharSequence)String.format("Account creation successful", new Object[0]));
                this.getLog().info((CharSequence)("Address       : " + addressToCreate));
                if (account != null) {
                    this.getLog().info((CharSequence)("Private Key   : " + account.getPrivateKey()));
                }
                if (!StringUtils.isEmpty((String)balance)) {
                    boolean response = localAvmAdapter.createAccountWithBalance(addressToCreate, new BigInteger(balance));
                    if (response) {
                        this.getLog().info((CharSequence)("Balance(nAmp) : " + balance.trim()));
                    } else {
                        this.getLog().info((CharSequence)"Balance allocation failed. Please check if account exists");
                    }
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error creating account with balance", e);
        }
    }

    private void showAccountListFromCacheLocal(LocalAvmAdapter localAvmAdapter, boolean showBalance) throws MojoExecutionException {
        GlobalCache globalCache = this.getGlobalAccountCache();
        AccountCache accountCache = globalCache.getAccountCache();
        List accountList = accountCache.getAccounts();
        if (accountList.size() > 0) {
            this.getLog().info((CharSequence)"Accounts :");
            int index = 0;
            for (Account account : accountList) {
                this.getLog().info((CharSequence)("Account #" + ++index));
                this.getLog().info((CharSequence)("    Address    : " + account.getAddress()));
                this.getLog().info((CharSequence)("    Private key: " + account.getPrivateKey()));
                if (!showBalance) continue;
                BigInteger balance = null;
                try {
                    balance = localAvmAdapter.getBalance(account.getAddress());
                    BigDecimal aionValue = CryptoUtil.ampToAion((BigInteger)balance);
                    this.getLog().info((CharSequence)String.format("    Balance    : %s nAmp (%s Aion)", balance, String.format("%.12f", Float.valueOf(aionValue.floatValue()))));
                }
                catch (Exception e) {
                    this.getLog().debug((CharSequence)("Unable to fetch balance for account: " + account.getAddress()), (Throwable)e);
                    balance = BigInteger.ZERO;
                }
            }
        } else {
            this.getLog().info((CharSequence)"No account to show");
        }
    }
}

