/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.mojo;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.CodeSource;
import org.aion4j.avm.helper.local.LocalAvmNode;
import org.aion4j.maven.avm.mojo.AVMBaseMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;

public abstract class AVMAbstractBaseMojo
extends AVMBaseMojo {
    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.isLocal()) {
            this.executeLocalAVM();
        } else {
            this.executeRemote();
        }
    }

    protected void executeLocalAVM() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"----------- AVM classpath Urls --------------");
        URL urlsForClassLoader = null;
        try {
            if (!new File(this.getAvmLibDir() + File.separator + "avm.jar").exists()) {
                this.getLog().error((CharSequence)"avm.jar not found. Please make sure avm.jar exists in avm lib folder.\n You can also execution aion4j:init-lib maven goal to copy default jars to avm lib folder.");
                throw new MojoExecutionException("avm.jar is not found in " + this.getAvmLibDir());
            }
            urlsForClassLoader = new File(this.getAvmLibDir() + File.separator + "avm.jar").toURI().toURL();
            this.getLog().debug((CharSequence)urlsForClassLoader.toURI().toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        URL pluginJar = this.getLocalAVMNodeClassJarLocation();
        if (pluginJar != null) {
            try {
                this.getLog().debug((CharSequence)pluginJar.toURI().toString());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        this.getLog().debug((CharSequence)"----------- AVM classpath Urls Ends --------------");
        ClassLoader originalClassLoader = Thread.currentThread().getContextClassLoader();
        URLClassLoader classLoader = new URLClassLoader(new URL[]{urlsForClassLoader, pluginJar});
        Thread.currentThread().setContextClassLoader(classLoader);
        Object shutDownMethod = null;
        Object localAvmInstance = null;
        try {
            localAvmInstance = this.getLocalAvmImplInstance(classLoader);
            this.preexecuteLocalAvm();
            this.executeLocalAvm(classLoader, localAvmInstance);
        }
        catch (MojoExecutionException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new MojoExecutionException("Avm maven execution failed", ex);
        }
        finally {
            this.postExecuteLocalAvm(localAvmInstance);
            Thread.currentThread().setContextClassLoader(originalClassLoader);
        }
    }

    protected URL getLocalAVMNodeClassJarLocation() {
        CodeSource src = LocalAvmNode.class.getProtectionDomain().getCodeSource();
        if (src != null) {
            URL jar = src.getLocation();
            return jar;
        }
        return null;
    }

    protected Class getLocalAVMClass() throws MojoExecutionException {
        this.getLog().debug((CharSequence)"----------- AVM classpath Urls --------------");
        URL urlsForClassLoader = null;
        try {
            if (!new File(this.getAvmLibDir() + File.separator + "avm.jar").exists()) {
                this.getLog().error((CharSequence)"avm.jar not found. Please make sure avm.jar exists in avm lib folder.\n You can also execution aion4j:init-lib maven goal to copy default jars to avm lib folder.");
                throw new MojoExecutionException("avm.jar is not found in " + this.getAvmLibDir());
            }
            urlsForClassLoader = new File(this.getAvmLibDir() + File.separator + "avm.jar").toURI().toURL();
            this.getLog().debug((CharSequence)urlsForClassLoader.toURI().toString());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
        }
        URL pluginJar = this.getLocalAVMNodeClassJarLocation();
        if (pluginJar != null) {
            try {
                this.getLog().debug((CharSequence)pluginJar.toURI().toString());
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        this.getLog().debug((CharSequence)"----------- AVM classpath Urls Ends --------------");
        URLClassLoader avmClassLoader = new URLClassLoader(new URL[]{urlsForClassLoader, pluginJar});
        try {
            Class<?> localAvmClazz = avmClassLoader.loadClass("org.aion4j.avm.helper.local.LocalAvmNode");
            return localAvmClazz;
        }
        catch (ClassNotFoundException e) {
            this.getLog().debug((Throwable)e);
            return null;
        }
    }

    protected void executeRemote() throws MojoExecutionException {
    }

    protected abstract void preexecuteLocalAvm() throws MojoExecutionException;

    protected abstract void executeLocalAvm(ClassLoader var1, Object var2) throws MojoExecutionException;

    protected abstract void postExecuteLocalAvm(Object var1) throws MojoExecutionException;

    protected abstract Object getLocalAvmImplInstance(ClassLoader var1);
}

