/*
 * Decompiled with CFR 0.152.
 */
package org.aion4j.maven.avm.adapter;

import java.lang.reflect.Method;
import java.math.BigInteger;
import org.aion4j.maven.avm.util.StringUtils;
import org.apache.maven.plugin.MojoExecutionException;

public class LocalAvmAdapter {
    private Object localAvmInstance;

    public LocalAvmAdapter(Object localAvmInstance) {
        this.localAvmInstance = localAvmInstance;
    }

    public BigInteger getBalance(String address) throws MojoExecutionException {
        if (StringUtils.isEmpty(address)) {
            return null;
        }
        try {
            Method getBalanceMethod = this.localAvmInstance.getClass().getMethod("getBalance", String.class);
            Object response = getBalanceMethod.invoke(this.localAvmInstance, address);
            if (response != null) {
                return (BigInteger)response;
            }
            return null;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Get balance failed", e);
        }
    }

    public boolean transfer(String toAddress, BigInteger amount) throws MojoExecutionException {
        if (StringUtils.isEmpty(toAddress)) {
            return false;
        }
        if (amount == null) {
            amount = BigInteger.ZERO;
        }
        try {
            Method transferMethod = this.localAvmInstance.getClass().getMethod("transfer", String.class, BigInteger.class);
            Object response = transferMethod.invoke(this.localAvmInstance, toAddress, amount);
            if (response != null) {
                return (Boolean)response;
            }
            return false;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Transfer in embedded Avm failed", e);
        }
    }

    public boolean createAccountWithBalance(String address, BigInteger balance) throws MojoExecutionException {
        try {
            Method createAccountMethod = this.localAvmInstance.getClass().getMethod("createAccountWithBalance", String.class, BigInteger.class);
            Object response = createAccountMethod.invoke(this.localAvmInstance, address, balance);
            return (Boolean)response;
        }
        catch (Exception e) {
            throw new MojoExecutionException("Create account error in embedded Avm", e);
        }
    }
}

