group orm_object;

license() ::=<<
$! 
Copyright 2012 Brian Hawkins
Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
!$
>>

derivedSetAndGetMethods(col) ::= <<

//------------------------------------------------------------------------------
/**
	$col.comment$
*/
public $col.type$ get$col.methodName$() 
	{ 
	return (get$col.methodName$_base()); 
	}
	
public void set$col.methodName$($col.type$ id)
	{
	set$col.methodName$_base(id);
	}

$if(col.allowNull)$
public void set$col.methodName$Null()
	{
	set$col.methodName$Null_base();
	}
$endif$

>>

foreignGetAndSetMethods(foreignKeys) ::= <<

//------------------------------------------------------------------------------
public $foreignKeys.table.className$ get$foreignKeys.methodName$()
	{
	return (get$foreignKeys.methodName$_base());
	}
	
public void set$foreignKeys.methodName$($foreignKeys.table.className$ table)
	{
	set$foreignKeys.methodName$_base(table);
	}

>>

derivedClass(package,table,columns,foreignKeys) ::= <<
package $package$;

/**
	This class has been automatically generated by GenORMous.  This file is for
	adding custom code to.  This file will not be regenerated once it exists.
	
	$table.comment$
*/
public class $table.className$ extends $table.className$_base
	{
	
	}
>>
