/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.rest.api.resources.assembler;

import java.util.ArrayList;
import org.activiti.services.core.model.Task;
import org.activiti.services.rest.api.HomeController;
import org.activiti.services.rest.api.ProcessInstanceController;
import org.activiti.services.rest.api.TaskController;
import org.activiti.services.rest.api.resources.TaskResource;
import org.springframework.hateoas.Link;
import org.springframework.hateoas.mvc.ControllerLinkBuilder;
import org.springframework.hateoas.mvc.ResourceAssemblerSupport;
import org.springframework.stereotype.Component;

@Component
public class TaskResourceAssembler
extends ResourceAssemblerSupport<Task, TaskResource> {
    public TaskResourceAssembler() {
        super(TaskController.class, TaskResource.class);
    }

    public TaskResource toResource(Task task) {
        ArrayList<Link> links = new ArrayList<Link>();
        links.add(ControllerLinkBuilder.linkTo(((TaskController)ControllerLinkBuilder.methodOn(TaskController.class, (Object[])new Object[0])).getTaskById(task.getId())).withSelfRel());
        if (!task.getStatus().equals(Task.TaskStatus.ASSIGNED.name())) {
            links.add(ControllerLinkBuilder.linkTo(((TaskController)ControllerLinkBuilder.methodOn(TaskController.class, (Object[])new Object[0])).claimTask(task.getId())).withRel("claim"));
        } else {
            links.add(ControllerLinkBuilder.linkTo(((TaskController)ControllerLinkBuilder.methodOn(TaskController.class, (Object[])new Object[0])).releaseTask(task.getId())).withRel("release"));
            links.add(ControllerLinkBuilder.linkTo(((TaskController)ControllerLinkBuilder.methodOn(TaskController.class, (Object[])new Object[0])).completeTask(task.getId(), null)).withRel("complete"));
        }
        links.add(ControllerLinkBuilder.linkTo(((ProcessInstanceController)ControllerLinkBuilder.methodOn(ProcessInstanceController.class, (Object[])new Object[0])).getProcessInstanceById(task.getProcessInstanceId())).withRel("processInstance"));
        if (task.getParentTaskId() != null && !task.getParentTaskId().isEmpty()) {
            links.add(ControllerLinkBuilder.linkTo(((TaskController)ControllerLinkBuilder.methodOn(TaskController.class, (Object[])new Object[0])).getTaskById(task.getParentTaskId())).withRel("parent"));
        }
        links.add(ControllerLinkBuilder.linkTo(HomeController.class).withRel("home"));
        return new TaskResource(task, links);
    }
}

