/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.rest.api;

import org.activiti.services.core.model.Task;
import org.activiti.services.core.model.commands.CompleteTaskCmd;
import org.activiti.services.rest.api.resources.TaskResource;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@RequestMapping(value={"/v1/tasks"}, produces={"application/hal+json"})
public interface TaskController {
    @RequestMapping(method={RequestMethod.GET})
    public PagedResources<TaskResource> getTasks(Pageable var1, PagedResourcesAssembler<Task> var2);

    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.GET})
    public Resource<Task> getTaskById(@PathVariable String var1);

    @RequestMapping(value={"/{taskId}/claim"}, method={RequestMethod.POST})
    public Resource<Task> claimTask(@PathVariable String var1);

    @RequestMapping(value={"/{taskId}/release"}, method={RequestMethod.POST})
    public Resource<Task> releaseTask(@PathVariable String var1);

    @RequestMapping(value={"/{taskId}/complete"}, method={RequestMethod.POST})
    public ResponseEntity<Void> completeTask(@PathVariable String var1, @RequestBody(required=false) CompleteTaskCmd var2);
}

