/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.rest.api;

import org.activiti.services.core.model.ProcessInstance;
import org.activiti.services.core.model.commands.SignalProcessInstancesCmd;
import org.activiti.services.core.model.commands.StartProcessInstanceCmd;
import org.activiti.services.rest.api.resources.ProcessInstanceResource;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/v1/process-instances"}, produces={"application/hal+json"})
public interface ProcessInstanceController {
    @RequestMapping(method={RequestMethod.GET})
    public PagedResources<ProcessInstanceResource> getProcessInstances(Pageable var1, PagedResourcesAssembler<ProcessInstance> var2);

    @RequestMapping(method={RequestMethod.POST})
    public Resource<ProcessInstance> startProcess(@RequestBody StartProcessInstanceCmd var1);

    @RequestMapping(value={"/{processInstanceId}"}, method={RequestMethod.GET})
    public Resource<ProcessInstance> getProcessInstanceById(@PathVariable String var1);

    @RequestMapping(value={"/{processInstanceId}/svg"}, method={RequestMethod.GET}, produces={"image/svg+xml"})
    @ResponseBody
    public String getProcessDiagram(@PathVariable String var1);

    @RequestMapping(value={"/signal"})
    public ResponseEntity<Void> sendSignal(@RequestBody SignalProcessInstancesCmd var1);

    @RequestMapping(value={"{processInstanceId}/suspend"})
    public ResponseEntity<Void> suspend(@PathVariable String var1);

    @RequestMapping(value={"{processInstanceId}/activate"})
    public ResponseEntity<Void> activate(@PathVariable String var1);
}

