/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.query.rest.controller;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import org.activiti.services.query.app.repository.VariableRepository;
import org.activiti.services.query.model.QVariable;
import org.activiti.services.query.model.Variable;
import org.activiti.services.query.resource.VariableQueryResource;
import org.activiti.services.query.rest.assembler.VariableQueryResourceAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/tasks/{taskId}/variables"}, produces={"application/hal+json"})
public class TaskVariableQueryController {
    private final VariableRepository variableRepository;
    private final VariableQueryResourceAssembler resourceAssembler;

    @Autowired
    public TaskVariableQueryController(VariableRepository variableRepository, VariableQueryResourceAssembler resourceAssembler) {
        this.variableRepository = variableRepository;
        this.resourceAssembler = resourceAssembler;
    }

    @RequestMapping(method={RequestMethod.GET})
    public PagedResources<VariableQueryResource> findAll(@PathVariable String taskId, @QuerydslPredicate(root=Variable.class) Predicate predicate, Pageable pageable, PagedResourcesAssembler<Variable> pagedResourcesAssembler) {
        BooleanExpression filterOnTask = QVariable.variable.taskId.eq((Object)taskId);
        if (predicate != null) {
            filterOnTask = filterOnTask.and(predicate);
        }
        return pagedResourcesAssembler.toResource(this.variableRepository.findAll((Predicate)filterOnTask, pageable), (ResourceAssembler)this.resourceAssembler);
    }
}

