/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.query.rest.controller;

import com.querydsl.core.types.Predicate;
import org.activiti.services.query.app.repository.EntityFinder;
import org.activiti.services.query.app.repository.TaskRepository;
import org.activiti.services.query.model.Task;
import org.activiti.services.query.resource.TaskQueryResource;
import org.activiti.services.query.rest.assembler.TaskQueryResourceAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/tasks"}, produces={"application/hal+json"})
public class TaskQueryController {
    private final TaskRepository dao;
    private final EntityFinder entityFinder;
    private final TaskQueryResourceAssembler resourceAssembler;

    @Autowired
    public TaskQueryController(TaskRepository dao, EntityFinder entityFinder, TaskQueryResourceAssembler resourceAssembler) {
        this.dao = dao;
        this.entityFinder = entityFinder;
        this.resourceAssembler = resourceAssembler;
    }

    @RequestMapping(method={RequestMethod.GET})
    public PagedResources<TaskQueryResource> findAllByWebQuerydsl(@QuerydslPredicate(root=Task.class) Predicate predicate, Pageable pageable, PagedResourcesAssembler<Task> pagedResourcesAssembler) {
        return pagedResourcesAssembler.toResource(this.dao.findAll(predicate, pageable), (ResourceAssembler)this.resourceAssembler);
    }

    @RequestMapping(value={"/{taskId}"}, method={RequestMethod.GET})
    public Resource<Task> getTaskById(@PathVariable String taskId) {
        return this.resourceAssembler.toResource((Task)this.entityFinder.findById((CrudRepository)this.dao, (Object)taskId, "Unable to find task: " + taskId));
    }
}

