/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.query.rest.controller;

import com.querydsl.core.types.Predicate;
import org.activiti.services.query.app.repository.EntityFinder;
import org.activiti.services.query.app.repository.ProcessInstanceRepository;
import org.activiti.services.query.model.ProcessInstance;
import org.activiti.services.query.resource.ProcessInstanceQueryResource;
import org.activiti.services.query.rest.assembler.ProcessInstanceQueryResourceAssembler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.querydsl.binding.QuerydslPredicate;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.web.PagedResourcesAssembler;
import org.springframework.hateoas.PagedResources;
import org.springframework.hateoas.Resource;
import org.springframework.hateoas.ResourceAssembler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/process-instances"}, produces={"application/hal+json"})
public class ProcessInstanceQueryController {
    private final ProcessInstanceRepository processInstanceRepository;
    private final EntityFinder entityFinder;
    private final ProcessInstanceQueryResourceAssembler resourceAssembler;

    @Autowired
    public ProcessInstanceQueryController(ProcessInstanceRepository processInstanceRepository, EntityFinder entityFinder, ProcessInstanceQueryResourceAssembler resourceAssembler) {
        this.processInstanceRepository = processInstanceRepository;
        this.entityFinder = entityFinder;
        this.resourceAssembler = resourceAssembler;
    }

    @RequestMapping(method={RequestMethod.GET})
    @ResponseBody
    public PagedResources<ProcessInstanceQueryResource> findAllByWebQuerydsl(@QuerydslPredicate(root=ProcessInstance.class) Predicate predicate, Pageable pageable, PagedResourcesAssembler<ProcessInstance> pagedResourcesAssembler) {
        return pagedResourcesAssembler.toResource(this.processInstanceRepository.findAll(predicate, pageable), (ResourceAssembler)this.resourceAssembler);
    }

    @RequestMapping(value={"/{processInstanceId}"}, method={RequestMethod.GET})
    public Resource<ProcessInstance> getProcessInstanceById(@PathVariable Long processInstanceId) {
        return this.resourceAssembler.toResource((ProcessInstance)this.entityFinder.findById((CrudRepository)this.processInstanceRepository, (Object)processInstanceId, "Unable to find process instance: " + processInstanceId));
    }
}

