/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.query.events.handlers;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import org.activiti.services.query.events.handlers.VariableUpdater;
import org.activiti.services.query.model.QVariable;
import org.activiti.services.query.model.Variable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskVariableUpdatedHandler {
    private final VariableUpdater variableUpdater;

    @Autowired
    public TaskVariableUpdatedHandler(VariableUpdater variableUpdater) {
        this.variableUpdater = variableUpdater;
    }

    public void handle(Variable updatedVariable) {
        String variableName = updatedVariable.getName();
        String taskId = updatedVariable.getTaskId();
        BooleanExpression predicate = QVariable.variable.name.eq((Object)variableName).and((Predicate)QVariable.variable.taskId.eq((Object)String.valueOf(taskId)));
        this.variableUpdater.update(updatedVariable, (Predicate)predicate, "Unable to find variable named '" + variableName + "' for task '" + taskId + "'");
    }
}

