/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.query.events.handlers;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import org.activiti.services.query.app.repository.EntityFinder;
import org.activiti.services.query.app.repository.VariableRepository;
import org.activiti.services.query.events.VariableDeletedEvent;
import org.activiti.services.query.model.QVariable;
import org.activiti.services.query.model.Variable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Component;

@Component
public class TaskVariableDeletedHandler {
    private final VariableRepository variableRepository;
    private final EntityFinder entityFinder;

    @Autowired
    public TaskVariableDeletedHandler(VariableRepository variableRepository, EntityFinder entityFinder) {
        this.variableRepository = variableRepository;
        this.entityFinder = entityFinder;
    }

    public void handle(VariableDeletedEvent event) {
        String variableName = event.getVariableName();
        String taskId = event.getTaskId();
        BooleanExpression predicate = QVariable.variable.taskId.eq((Object)taskId).and((Predicate)QVariable.variable.name.eq((Object)variableName));
        Variable variable = (Variable)this.entityFinder.findOne((QuerydslPredicateExecutor)this.variableRepository, (Predicate)predicate, "Unable to find variable with name '" + variableName + "' for task '" + taskId + "'");
        this.variableRepository.delete((Object)variable);
    }
}

