/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.query.events.handlers;

import java.util.Date;
import org.activiti.services.api.events.ProcessEngineEvent;
import org.activiti.services.query.app.repository.TaskRepository;
import org.activiti.services.query.events.TaskCreatedEvent;
import org.activiti.services.query.events.handlers.QueryEventHandler;
import org.activiti.services.query.model.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskCreatedEventHandler
implements QueryEventHandler {
    private TaskRepository taskRepository;

    @Autowired
    public TaskCreatedEventHandler(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    @Override
    public void handle(ProcessEngineEvent event) {
        TaskCreatedEvent taskCreatedEvent = (TaskCreatedEvent)event;
        Task task = taskCreatedEvent.getTask();
        task.setStatus("CREATED");
        task.setLastModified(new Date(taskCreatedEvent.getTimestamp()));
        this.taskRepository.save((Object)task);
    }

    @Override
    public Class<? extends ProcessEngineEvent> getHandledEventClass() {
        return TaskCreatedEvent.class;
    }
}

