/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.query.events.handlers;

import java.util.Date;
import java.util.Optional;
import org.activiti.engine.ActivitiException;
import org.activiti.services.api.events.ProcessEngineEvent;
import org.activiti.services.query.app.repository.TaskRepository;
import org.activiti.services.query.events.TaskCompletedEvent;
import org.activiti.services.query.events.handlers.QueryEventHandler;
import org.activiti.services.query.model.Task;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class TaskCompletedEventHandler
implements QueryEventHandler {
    private final TaskRepository taskRepository;

    @Autowired
    public TaskCompletedEventHandler(TaskRepository taskRepository) {
        this.taskRepository = taskRepository;
    }

    @Override
    public void handle(ProcessEngineEvent event) {
        TaskCompletedEvent taskCompletedEvent = (TaskCompletedEvent)event;
        Task eventTask = taskCompletedEvent.getTask();
        Optional findResult = this.taskRepository.findById((Object)eventTask.getId());
        if (!findResult.isPresent()) {
            throw new ActivitiException("Unable to find task with id: " + eventTask.getId());
        }
        Task task = (Task)findResult.get();
        task.setStatus("COMPLETED");
        task.setLastModified(new Date(taskCompletedEvent.getTimestamp()));
        this.taskRepository.save((Object)task);
    }

    @Override
    public Class<? extends ProcessEngineEvent> getHandledEventClass() {
        return TaskCompletedEvent.class;
    }
}

