/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.query.events.handlers;

import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.activiti.services.api.events.ProcessEngineEvent;
import org.activiti.services.query.events.AbstractProcessEngineEvent;
import org.activiti.services.query.events.handlers.QueryEventHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class QueryEventHandlerContext {
    private static Logger LOGGER = LoggerFactory.getLogger(QueryEventHandlerContext.class);
    private Map<Class<? extends ProcessEngineEvent>, QueryEventHandler> handlers;

    @Autowired
    public QueryEventHandlerContext(Set<QueryEventHandler> handlers) {
        this.handlers = handlers.stream().collect(Collectors.toMap(QueryEventHandler::getHandledEventClass, Function.identity()));
    }

    public void handle(AbstractProcessEngineEvent[] events) {
        for (AbstractProcessEngineEvent event : events) {
            QueryEventHandler handler = this.handlers.get(event.getClass());
            if (handler == null) continue;
            LOGGER.debug("Handling event: " + handler.getHandledEventClass().getName());
            handler.handle(event);
        }
    }

    protected Map<Class<? extends ProcessEngineEvent>, QueryEventHandler> getHandlers() {
        return this.handlers;
    }
}

