/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.query.events.handlers;

import com.querydsl.core.types.Predicate;
import com.querydsl.core.types.dsl.BooleanExpression;
import org.activiti.services.query.app.repository.EntityFinder;
import org.activiti.services.query.app.repository.VariableRepository;
import org.activiti.services.query.events.VariableDeletedEvent;
import org.activiti.services.query.model.QVariable;
import org.activiti.services.query.model.Variable;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.querydsl.QuerydslPredicateExecutor;
import org.springframework.stereotype.Component;

@Component
public class ProcessVariableDeletedHandler {
    private final VariableRepository variableRepository;
    private final EntityFinder entityFinder;

    @Autowired
    public ProcessVariableDeletedHandler(VariableRepository variableRepository, EntityFinder entityFinder) {
        this.variableRepository = variableRepository;
        this.entityFinder = entityFinder;
    }

    public void handle(VariableDeletedEvent event) {
        String variableName = event.getVariableName();
        String processInstanceId = event.getProcessInstanceId();
        BooleanExpression predicate = QVariable.variable.processInstanceId.eq((Object)processInstanceId).and((Predicate)QVariable.variable.name.eq((Object)variableName));
        Variable variable = (Variable)this.entityFinder.findOne((QuerydslPredicateExecutor)this.variableRepository, (Predicate)predicate, "Unable to find variable with name '" + variableName + "' for process instance '" + processInstanceId + "'");
        this.variableRepository.delete((Object)variable);
    }
}

