/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.query.events.handlers;

import java.util.Date;
import org.activiti.services.api.events.ProcessEngineEvent;
import org.activiti.services.query.app.repository.ProcessInstanceRepository;
import org.activiti.services.query.events.ProcessStartedEvent;
import org.activiti.services.query.events.handlers.QueryEventHandler;
import org.activiti.services.query.model.ProcessInstance;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessStartedHandler
implements QueryEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessStartedHandler.class);
    private ProcessInstanceRepository processInstanceRepository;

    @Autowired
    public ProcessStartedHandler(ProcessInstanceRepository processInstanceRepository) {
        this.processInstanceRepository = processInstanceRepository;
    }

    @Override
    public void handle(ProcessEngineEvent event) {
        LOGGER.debug("Handling start of process Instance " + event.getProcessInstanceId());
        this.processInstanceRepository.save((Object)new ProcessInstance(Long.valueOf(Long.parseLong(event.getProcessInstanceId())), event.getProcessDefinitionId(), "RUNNING", new Date(event.getTimestamp())));
    }

    @Override
    public Class<? extends ProcessEngineEvent> getHandledEventClass() {
        return ProcessStartedEvent.class;
    }
}

