/*
 * Decompiled with CFR 0.152.
 */
package org.activiti.services.query.events.handlers;

import java.util.Date;
import java.util.Optional;
import org.activiti.engine.ActivitiException;
import org.activiti.services.api.events.ProcessEngineEvent;
import org.activiti.services.query.app.repository.ProcessInstanceRepository;
import org.activiti.services.query.events.ProcessCompletedEvent;
import org.activiti.services.query.events.handlers.QueryEventHandler;
import org.activiti.services.query.model.ProcessInstance;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ProcessCompletedEventHandler
implements QueryEventHandler {
    private ProcessInstanceRepository processInstanceRepository;

    @Autowired
    public ProcessCompletedEventHandler(ProcessInstanceRepository processInstanceRepository) {
        this.processInstanceRepository = processInstanceRepository;
    }

    @Override
    public void handle(ProcessEngineEvent completedEvent) {
        long processInstanceId = Long.parseLong(completedEvent.getProcessInstanceId());
        Optional findResult = this.processInstanceRepository.findById((Object)processInstanceId);
        if (!findResult.isPresent()) {
            throw new ActivitiException("Unable to find process instance with the given id: " + processInstanceId);
        }
        ProcessInstance processInstance = (ProcessInstance)findResult.get();
        processInstance.setStatus("COMPLETED");
        processInstance.setLastModified(new Date(completedEvent.getTimestamp()));
        this.processInstanceRepository.save((Object)processInstance);
    }

    @Override
    public Class<? extends ProcessEngineEvent> getHandledEventClass() {
        return ProcessCompletedEvent.class;
    }
}

