/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.invoke.mapper;

import jadex.commons.SReflect;
import jadex.extension.rs.publish.mapper.IValueMapper;
import java.util.Iterator;

public class IterableStringMapper
implements IValueMapper {
    protected String delim;
    protected String prefix;
    protected String postfix;
    protected IValueMapper submapper;

    public IterableStringMapper() {
        this(null, ",", null);
    }

    public IterableStringMapper(String delim) {
        this(null, delim, null);
    }

    public IterableStringMapper(String delim, IValueMapper submapper) {
        this(null, delim, null, submapper);
    }

    public IterableStringMapper(String prefix, String delim) {
        this(prefix, delim, null);
    }

    public IterableStringMapper(String prefix, String delim, String postfix) {
        this(prefix, delim, postfix, null);
    }

    public IterableStringMapper(String prefix, String delim, String postfix, IValueMapper submapper) {
        this.prefix = prefix;
        this.delim = delim;
        this.postfix = postfix;
        this.submapper = submapper;
    }

    @Override
    public Object convertValue(Object value) throws Exception {
        StringBuffer ret = new StringBuffer();
        if (this.prefix != null) {
            ret.append(this.prefix);
        }
        Iterator it = SReflect.getIterator((Object)value);
        while (it.hasNext()) {
            Object next = it.next();
            if (this.submapper != null) {
                next = this.submapper.convertValue(next);
            }
            ret.append(next);
            if (this.delim == null || !it.hasNext()) continue;
            ret.append(this.delim);
        }
        if (this.postfix != null) {
            ret.append(this.postfix);
        }
        return ret.toString();
    }
}

