/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.invoke;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.Value;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.SUtil;
import jadex.commons.future.DelegationResultListener;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.extension.rs.invoke.RSJAXAnnotationHelper;
import jadex.extension.rs.invoke.RestResponse;
import jadex.extension.rs.invoke.annotation.ParameterMapper;
import jadex.extension.rs.invoke.annotation.ParameterMappers;
import jadex.extension.rs.invoke.annotation.ParametersInURL;
import jadex.extension.rs.publish.annotation.ParametersMapper;
import jadex.extension.rs.publish.annotation.ResultMapper;
import jadex.extension.rs.publish.mapper.IValueMapper;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@Service
public class RestServiceWrapperInvocationHandler
implements InvocationHandler {
    public static String[] defaultimports = new String[]{"jadex.extension.rs.invoke.*", "jadex.extension.rs.invoke.annotation.*", "jadex.extension.rs.invoke.mapper.*"};
    protected IInternalAccess agent;
    protected Class<?> iface;

    public RestServiceWrapperInvocationHandler(IInternalAccess agent, Class<?> iface) {
        if (agent == null) {
            throw new IllegalArgumentException("Agent must not null.");
        }
        if (iface == null) {
            throw new IllegalArgumentException("Rest interface must not be null.");
        }
        this.agent = agent;
        this.iface = iface;
    }

    @Override
    public Object invoke(Object proxy, final Method method, final Object[] args) throws Throwable {
        final Future ret = new Future();
        IFuture fut = SServiceProvider.getService((IInternalAccess)this.agent, IComponentManagementService.class, (String)"platform");
        fut.addResultListener(((IExecutionFeature)this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentManagementService, Object>(ret){

            public void customResultAvailable(final IComponentManagementService cms) {
                CreationInfo ci = new CreationInfo(RestServiceWrapperInvocationHandler.this.agent.getComponentIdentifier());
                cms.createComponent(null, "jadex/extension/rs/invoke/RestServiceInvocationAgent.class", ci, null).addResultListener(((IExecutionFeature)RestServiceWrapperInvocationHandler.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentIdentifier, Object>(ret){

                    public void customResultAvailable(IComponentIdentifier cid) {
                        cms.getExternalAccess(cid).addResultListener(((IExecutionFeature)RestServiceWrapperInvocationHandler.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new ExceptionDelegationResultListener<IExternalAccess, Object>(ret){

                            public void customResultAvailable(IExternalAccess exta) {
                                exta.scheduleStep((IComponentStep)new IComponentStep<Object>(){

                                    public IFuture<Object> execute(IInternalAccess ia) {
                                        Future re = new Future();
                                        try {
                                            int i;
                                            String baseuri = RestServiceWrapperInvocationHandler.this.iface.getAnnotation(Path.class).value();
                                            Method m = RestServiceWrapperInvocationHandler.this.iface.getMethod(method.getName(), method.getParameterTypes());
                                            Class<?> resttype = RSJAXAnnotationHelper.getDeclaredRestType(m);
                                            String methodname = m.getAnnotation(Path.class).value();
                                            String[] consumes = SUtil.EMPTY_STRING_ARRAY;
                                            if (m.isAnnotationPresent(Consumes.class)) {
                                                consumes = m.getAnnotation(Consumes.class).value();
                                            }
                                            String[] produces = SUtil.EMPTY_STRING_ARRAY;
                                            if (m.isAnnotationPresent(Produces.class)) {
                                                produces = m.getAnnotation(Produces.class).value();
                                            }
                                            ParametersMapper pmap = null;
                                            if (m.isAnnotationPresent(ParametersMapper.class)) {
                                                pmap = m.getAnnotation(ParametersMapper.class);
                                            }
                                            ArrayList<Object[]> pmappers = null;
                                            if (pmap == null) {
                                                pmappers = new ArrayList<Object[]>();
                                                Annotation[][] anoss = m.getParameterAnnotations();
                                                for (int i2 = 0; i2 < anoss.length; ++i2) {
                                                    Annotation[] anos = anoss[i2];
                                                    for (int j = 0; j < anos.length; ++j) {
                                                        if (!(anos[j] instanceof ParameterMapper)) continue;
                                                        pmappers.add(new Object[]{anos[j], new int[]{i2}});
                                                    }
                                                }
                                                if (m.isAnnotationPresent(ParameterMapper.class)) {
                                                    ParameterMapper qpm = m.getAnnotation(ParameterMapper.class);
                                                    pmappers.add(new Object[]{qpm, new int[]{-1}});
                                                }
                                                if (m.isAnnotationPresent(ParameterMappers.class)) {
                                                    ParameterMappers qpms = m.getAnnotation(ParameterMappers.class);
                                                    ParameterMapper[] mps = qpms.value();
                                                    for (i = 0; i < mps.length; ++i) {
                                                        pmappers.add(new Object[]{mps[i], new int[]{-1}});
                                                    }
                                                }
                                            }
                                            Value rmapper = null;
                                            if (m.isAnnotationPresent(ResultMapper.class)) {
                                                rmapper = m.getAnnotation(ResultMapper.class).value();
                                            }
                                            Object targetparams = args;
                                            if (pmap != null) {
                                                IValueMapper pm;
                                                Value pmapper = pmap.value();
                                                if (pmapper != null && (pm = (IValueMapper)jadex.extension.rs.publish.Value.evaluate(pmapper, defaultimports)) != null) {
                                                    targetparams = pm.convertValue(args);
                                                }
                                            } else if (pmappers != null) {
                                                MultivaluedHashMap mv = new MultivaluedHashMap();
                                                for (i = 0; i < pmappers.size(); ++i) {
                                                    Object[] pm = (Object[])pmappers.get(i);
                                                    ParameterMapper qpm = (ParameterMapper)pm[0];
                                                    String name = qpm.value();
                                                    Value val = qpm.mapper();
                                                    int[] src = qpm.source().length > 0 ? qpm.source() : (int[])pm[1];
                                                    IValueMapper mapper = (IValueMapper)jadex.extension.rs.publish.Value.evaluate(val, defaultimports);
                                                    ArrayList<Object> params = new ArrayList<Object>();
                                                    for (int j = 0; j < src.length; ++j) {
                                                        if (src[j] == -1) continue;
                                                        params.add(args[src[j]]);
                                                    }
                                                    String p = (String)mapper.convertValue(params.size() == 1 ? params.get(0) : params);
                                                    mv.add((Object)name, (Object)p);
                                                }
                                                targetparams = mv;
                                            }
                                            Client client = ClientBuilder.newClient();
                                            WebTarget wt = client.target(baseuri);
                                            wt = wt.path(methodname);
                                            Response res = null;
                                            boolean inurl = GET.class.equals(resttype);
                                            if (!inurl && m.isAnnotationPresent(ParametersInURL.class)) {
                                                inurl = m.getAnnotation(ParametersInURL.class).value();
                                            }
                                            if (inurl && targetparams != null) {
                                                MultivaluedMap ps = (MultivaluedMap)targetparams;
                                                for (String key : ps.keySet()) {
                                                    wt = wt.queryParam(key, (Object[])((List)ps.get((Object)key)).toArray(new String[0]));
                                                }
                                            }
                                            Invocation.Builder ib = wt.request(consumes);
                                            for (int i3 = 0; i3 < produces.length; ++i3) {
                                                ib = ib.accept(new String[]{produces[i3]});
                                            }
                                            if (GET.class.equals(resttype)) {
                                                res = ib.get();
                                            } else {
                                                Entity data = null;
                                                if (!inurl && targetparams != null && targetparams instanceof MultivaluedMap) {
                                                    data = Entity.form((MultivaluedMap)((MultivaluedMap)targetparams));
                                                }
                                                if (POST.class.equals(resttype)) {
                                                    res = ib.post(data);
                                                } else if (PUT.class.equals(resttype)) {
                                                    res = ib.put(data);
                                                } else if (HEAD.class.equals(resttype)) {
                                                    res = ib.head();
                                                } else if (OPTIONS.class.equals(resttype)) {
                                                    res = ib.options();
                                                } else if (DELETE.class.equals(resttype)) {
                                                    res = ib.delete();
                                                }
                                            }
                                            Object targetret = res;
                                            if (rmapper != null) {
                                                IValueMapper rm = (IValueMapper)jadex.extension.rs.publish.Value.evaluate(rmapper, defaultimports);
                                                RestResponse restResponse = new RestResponse((InputStream)res.getEntity());
                                                restResponse.setContentLength(res.getLength());
                                                if (res.getMediaType() != null) {
                                                    restResponse.setContentType(res.getMediaType().toString());
                                                }
                                                if (res.getDate() != null) {
                                                    restResponse.setDate(res.getDate().getTime());
                                                }
                                                targetret = rm.convertValue(restResponse);
                                            }
                                            System.out.println("result is: " + res);
                                            re.setResult(targetret);
                                            ia.killComponent();
                                        }
                                        catch (Exception e) {
                                            re.setException(e);
                                        }
                                        return re;
                                    }
                                }).addResultListener(((IExecutionFeature)RestServiceWrapperInvocationHandler.this.agent.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new DelegationResultListener(ret)));
                            }
                        }));
                    }
                }));
            }
        }));
        return ret;
    }
}

