/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.invoke;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IExternalAccess;
import jadex.bridge.IInternalAccess;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.bridge.service.types.threadpool.IDaemonThreadPoolService;
import jadex.commons.Tuple2;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.micro.annotation.Agent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.DELETE;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MultivaluedHashMap;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;

@Agent
public class RestInvocationHelper {
    public static boolean USE_THREADS = true;
    protected Client client = ClientBuilder.newClient();

    public IFuture<String> invokeJson(IInternalAccess component, String uri, String path, Map<String, Object> headers, Map<String, Object> params, Class<?> resttype, boolean inurlparams) {
        return this.invokeJson(component, uri, path, headers, params, null, resttype, inurlparams);
    }

    public IFuture<String> invokeJson(IInternalAccess component, final String uri, final String path, final Map<String, Object> headers, final Map<String, Object> params, final String postplainjson, final Class<?> resttype, final boolean inurlparams) {
        IDaemonThreadPoolService tp = (IDaemonThreadPoolService)SServiceProvider.getLocalService((IComponentIdentifier)component.getComponentIdentifier(), IDaemonThreadPoolService.class, (String)"platform");
        final Future ret = new Future();
        final IExternalAccess exta = component.getExternalAccess();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                RestInvocationHelper.performRequest(exta, RestInvocationHelper.this.client, uri, path, headers, params, postplainjson, resttype, inurlparams, (Future<String>)ret);
            }
        };
        if (USE_THREADS) {
            tp.execute(runnable);
        } else {
            HashMap<String, Object> restargs = new HashMap<String, Object>();
            restargs.put("uri", uri);
            restargs.put("path", path);
            restargs.put("headers", headers);
            restargs.put("params", params);
            restargs.put("postplainjson", postplainjson);
            restargs.put("resttype", resttype);
            restargs.put("inurlparams", inurlparams);
            CreationInfo info = new CreationInfo();
            info.addArgument("restargs", restargs);
            IComponentManagementService cms = (IComponentManagementService)SServiceProvider.getLocalService((IInternalAccess)component, IComponentManagementService.class, (String)"platform");
            cms.createComponent(null, "jadex.extension.rs.invoke.RestInvocationAgent.class", info, (IResultListener)new IResultListener<Collection<Tuple2<String, Object>>>(){

                public void resultAvailable(Collection<Tuple2<String, Object>> result) {
                    Tuple2<String, Object> res = result.iterator().next();
                    ret.setResult((Object)((String)res));
                }

                public void exceptionOccurred(Exception exception) {
                    ret.setException(exception);
                }
            });
        }
        return ret;
    }

    /*
     * WARNING - void declaration
     */
    public static final void performRequest(IExternalAccess exta, Client client, String uri, String path, Map<String, Object> headers, Map<String, Object> params, String postplainjson, Class<?> resttype, boolean inurlparams, final Future<String> ret) {
        void var13_25;
        WebTarget wt = client.target(uri).path(path);
        Entity data = null;
        if (params != null) {
            if (inurlparams) {
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    if (entry.getValue() instanceof Collection) {
                        Collection coll = (Collection)entry.getValue();
                        for (Object obj : coll) {
                            wt.queryParam(entry.getKey(), new Object[]{obj});
                        }
                        continue;
                    }
                    wt = wt.queryParam(entry.getKey(), new Object[]{entry.getValue()});
                }
            } else {
                MultivaluedHashMap datamap = new MultivaluedHashMap();
                for (Map.Entry<String, Object> entry : params.entrySet()) {
                    if (entry.getValue() instanceof Collection) {
                        Collection coll = (Collection)entry.getValue();
                        datamap.put((Object)entry.getKey(), (Object)(coll instanceof List ? (List)coll : new ArrayList(coll)));
                        continue;
                    }
                    datamap.put((Object)entry.getKey(), Arrays.asList(entry.getValue()));
                }
                data = Entity.form((MultivaluedMap)datamap);
            }
        }
        if (postplainjson != null) {
            data = Entity.json((Object)postplainjson);
        }
        Invocation.Builder ib = wt.request(new String[]{"application/json"});
        if (headers != null) {
            for (Map.Entry<String, Object> entry : headers.entrySet()) {
                ib.header(entry.getKey(), entry.getValue());
            }
        }
        ib.accept(new String[]{"application/json"});
        Object var13_18 = null;
        if (POST.class.equals(resttype)) {
            Response response = ib.post(data);
        } else if (PUT.class.equals(resttype)) {
            Response response = ib.put(data);
        } else if (HEAD.class.equals(resttype)) {
            Response response = ib.head();
        } else if (OPTIONS.class.equals(resttype)) {
            Response response = ib.options();
        } else if (DELETE.class.equals(resttype)) {
            Response response = ib.delete();
        } else {
            Response response = ib.get();
        }
        final int statuscode = var13_25.getStatus();
        final String content = (String)var13_25.readEntity(String.class);
        var13_25.close();
        exta.scheduleStep((IComponentStep)new IComponentStep<Void>(){

            public IFuture<Void> execute(IInternalAccess ia) {
                if (statuscode >= 400 && statuscode < 600) {
                    ret.setException((Exception)new RequestFailedException("Request failed with status code: " + statuscode, statuscode, content));
                } else {
                    ret.setResult((Object)content);
                }
                return IFuture.DONE;
            }
        });
    }

    public static class RequestFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;
        protected int statuscode;
        protected String content;

        public RequestFailedException(String message, int statuscode, String content) {
            super(message);
            this.statuscode = statuscode;
        }

        public int getStatuscode() {
            return this.statuscode;
        }

        public void setStatuscode(int statuscode) {
            this.statuscode = statuscode;
        }

        public String getContent() {
            return this.content;
        }

        public void setContent(String content) {
            this.content = content;
        }
    }
}

