/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.base.PlatformConfiguration;
import jadex.base.Starter;
import jadex.bridge.IExternalAccess;
import jadex.bridge.ServiceCall;
import jadex.bridge.service.component.interceptors.CallAccess;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.ICommand;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.future.IResultListener;
import jadex.extension.rs.publish.HttpServletRequestWrapper;
import jadex.extension.rs.publish.IAsyncContextInfo;
import jadex.extension.rs.publish.IRequestHandlerService;
import jadex.javaparser.SJavaParser;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JadexGatewayServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    public static final String JADEX_PLATFORM = "jadex_platform";
    public static final String JADEX_PLATFORM_REFCOUNT = "jadex_platform_refcount";
    protected IExternalAccess platform;
    protected IRequestHandlerService handler;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.platform = this.startPlatform();
        ServletCallAccess.purgeServiceCalls();
        IComponentManagementService cms = (IComponentManagementService)SServiceProvider.getService((IExternalAccess)this.platform, IComponentManagementService.class, (String)"platform").get();
        this.handler = (IRequestHandlerService)SServiceProvider.getService((IExternalAccess)this.platform, IRequestHandlerService.class, (String)"platform").get();
        Enumeration pnames = config.getInitParameterNames();
        HashMap<String, Map<String, Object>> comps = new HashMap<String, Map<String, Object>>();
        ArrayList<ICommand> initcmds = new ArrayList<ICommand>();
        while (pnames.hasMoreElements()) {
            String cname = (String)pnames.nextElement();
            if (cname.startsWith("component")) {
                int cnt = SUtil.countOccurrences((String)cname, (char)'_');
                if (cnt == 1) {
                    Map<String, Object> comp = this.getComoponentMap(cname, comps);
                    comp.put("__model", config.getInitParameter(cname));
                } else if (cnt == 2) {
                    int idx = cname.lastIndexOf("_");
                    String pname = cname.substring(idx + 1);
                    String rcname = cname.substring(0, idx);
                    Map<String, Object> comp = this.getComoponentMap(rcname, comps);
                    String arg = config.getInitParameter(pname);
                    if (arg != null) {
                        try {
                            Object o = SJavaParser.evaluateExpression((String)arg, null);
                            comp.put(pname, o);
                        }
                        catch (Exception e) {
                            ServletCallAccess.purgeServiceCalls();
                            throw new RuntimeException("Arguments evaluation error: " + e);
                        }
                    }
                }
            }
            if (!cname.startsWith("initcommand")) continue;
            try {
                Class cmdcl = SReflect.classForName((String)config.getInitParameter(cname), null);
                ICommand cmd = (ICommand)cmdcl.newInstance();
                initcmds.add(cmd);
            }
            catch (Exception e) {
                ServletCallAccess.purgeServiceCalls();
                throw new RuntimeException("Initcommand error: " + config.getInitParameter(cname));
            }
        }
        System.out.println("Found components: " + comps);
        for (Map.Entry entry : comps.entrySet()) {
            String model = (String)((Map)entry.getValue()).remove("__model");
            CreationInfo cinfo = new CreationInfo((Map)entry.getValue());
            cms.createComponent(model, cinfo).getFirstResult();
        }
        System.out.println("Found init commands: " + initcmds);
        for (ICommand cmd : initcmds) {
            cmd.execute((Object)this.platform);
        }
        ServletCallAccess.purgeServiceCalls();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IExternalAccess startPlatform() {
        ServletContext ctx = this.getServletContext();
        IExternalAccess ret = null;
        ServletContext servletContext = ctx;
        synchronized (servletContext) {
            Integer refcount;
            ret = (IExternalAccess)ctx.getAttribute(JADEX_PLATFORM);
            if (ret == null) {
                PlatformConfiguration pc = PlatformConfiguration.getDefault();
                pc.getRootConfig().setGui(false);
                pc.getRootConfig().setRsPublish(true);
                ret = (IExternalAccess)Starter.createPlatform((PlatformConfiguration)pc).get();
                ctx.setAttribute(JADEX_PLATFORM, (Object)ret);
            }
            refcount = (refcount = (Integer)ctx.getAttribute(JADEX_PLATFORM_REFCOUNT)) == null ? new Integer(1) : new Integer(refcount + 1);
            ctx.setAttribute(JADEX_PLATFORM_REFCOUNT, (Object)refcount);
        }
        return ret;
    }

    protected Map<String, Object> getComoponentMap(String cname, Map<String, Map<String, Object>> comps) {
        Map<String, Object> comp = comps.get(cname);
        if (comp == null) {
            comp = new HashMap<String, Object>();
            comps.put(cname, comp);
        }
        return comp;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            final String ctxtpath = request.getContextPath();
            request = new HttpServletRequestWrapper(request){

                @Override
                public String getContextPath() {
                    return ctxtpath;
                }
            };
            final AsyncContext ctx = request.startAsync();
            final boolean[] complete = new boolean[1];
            AsyncListener alis = new AsyncListener(){

                public void onTimeout(AsyncEvent arg0) throws IOException {
                }

                public void onStartAsync(AsyncEvent arg0) throws IOException {
                }

                public void onError(AsyncEvent arg0) throws IOException {
                }

                public void onComplete(AsyncEvent arg0) throws IOException {
                    complete[0] = true;
                }
            };
            ctx.addListener(alis);
            request.setAttribute("__cinfo", (Object)new IAsyncContextInfo(){

                @Override
                public boolean isComplete() {
                    return complete[0];
                }
            });
            this.handler.handleRequest(request, response, null).addResultListener((IResultListener)new IResultListener<Void>(){

                public void exceptionOccurred(Exception e) {
                    if (!complete[0]) {
                        ctx.complete();
                    }
                    throw SUtil.throwUnchecked((Throwable)e);
                }

                public void resultAvailable(Void result) {
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
        ServletCallAccess.purgeServiceCalls();
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ServletContext ctx;
        System.out.println("Executing Servlet destroy.");
        super.destroy();
        ServletContext servletContext = ctx = this.getServletContext();
        synchronized (servletContext) {
            Integer refcount = (Integer)ctx.getAttribute(JADEX_PLATFORM_REFCOUNT);
            if (refcount == null || refcount - 1 == 0) {
                if (this.platform != null) {
                    try {
                        this.platform.killComponent().get();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                ctx.removeAttribute(JADEX_PLATFORM);
                ctx.removeAttribute(JADEX_PLATFORM_REFCOUNT);
            } else {
                refcount = new Integer(refcount - 1);
                ctx.setAttribute(JADEX_PLATFORM_REFCOUNT, (Object)refcount);
            }
        }
        ServletCallAccess.purgeServiceCalls();
    }

    protected static class ServletCallAccess
    extends CallAccess {
        protected ServletCallAccess() {
        }

        public static void purgeServiceCalls() {
            ServiceCall.LAST.remove();
            ServiceCall.CURRENT.remove();
            ServiceCall.NEXT.remove();
        }
    }
}

