/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.bridge.service.IService;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.PublishInfo;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.ServiceStart;
import jadex.bridge.service.component.IProvidedServicesFeature;
import jadex.commons.Tuple2;
import jadex.commons.collection.MultiCollection;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.extension.rs.publish.AbstractRestPublishService;
import jadex.extension.rs.publish.IRequestHandler;
import jadex.extension.rs.publish.IRequestHandlerService;
import jadex.extension.rs.publish.PathHandler;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

@Service
public class ExternalRestPublishService
extends AbstractRestPublishService
implements IRequestHandlerService {
    public static final String DEFAULT_HOST = "DEFAULTHOST";
    public static final int DEFAULT_PORT = 0;
    public static final String DEFAULT_APP = "DEFAULTAPP";
    public static final String DEFAULT_COMPLETECONTEXT = "http://DEFAULTHOST:0/DEFAULTAPP/";
    protected Map<IServiceIdentifier, Tuple2<PathHandler, URI>> sidservers;
    protected Map<Integer, PathHandler> portservers;
    protected boolean inited;

    @Override
    @ServiceStart
    public IFuture<Void> init() {
        if (!this.inited) {
            this.inited = true;
            super.init();
            IProvidedServicesFeature psf = (IProvidedServicesFeature)this.component.getComponentFeature(IProvidedServicesFeature.class);
            return psf.addService("requesthandlerser", IRequestHandlerService.class, (Object)this);
        }
        return IFuture.DONE;
    }

    @Override
    public IFuture<Void> handleRequest(HttpServletRequest request, HttpServletResponse response, Object args) {
        Future ret = new Future();
        String err = null;
        if (this.portservers != null) {
            PathHandler ph = this.portservers.get(request.getLocalPort());
            if (ph == null) {
                ph = this.portservers.get(0);
            }
            if (ph != null) {
                try {
                    ph.handleRequest(request, response, args);
                }
                catch (Exception e) {
                    err = this.getServicesInfo(request, ph);
                }
            } else {
                err = "No service registered to handle the request.";
            }
        } else {
            err = "No server at port: " + request.getLocalPort();
        }
        if (err != null) {
            response.setContentType("text/html");
            try {
                PrintWriter out = response.getWriter();
                ((Writer)out).write("<html><head></head><body>" + err + "</body></html>");
                this.complete(request, response);
                ret.setResult(null);
            }
            catch (Exception e) {
                ret.setException(e);
            }
        } else {
            ret.setResult(null);
        }
        return ret;
    }

    @Override
    public IFuture<Boolean> isSupported(String publishtype) {
        return "rs".equals(publishtype) ? IFuture.TRUE : IFuture.FALSE;
    }

    @Override
    public IFuture<Void> publishService(ClassLoader cl, final IService service, PublishInfo info) {
        try {
            String infopid = info.getPublishId();
            if (infopid.endsWith("/")) {
                infopid = infopid.substring(0, infopid.length() - 1);
            }
            URI uri = new URI(infopid.replace("[", "").replace("]", ""));
            String pid = infopid;
            if (pid.startsWith("[")) {
                pid = pid.substring(pid.indexOf("]") + 1);
                uri = new URI(DEFAULT_COMPLETECONTEXT + pid);
            }
            System.out.println("Adding http handler to server: " + uri.getPath());
            PathHandler ph = (PathHandler)this.getHttpServer(uri, info);
            final MultiCollection<String, AbstractRestPublishService.MappingInfo> mappings = this.evaluateMapping(service.getServiceIdentifier(), info);
            IRequestHandler rh = new IRequestHandler(){

                @Override
                public void handleRequest(HttpServletRequest request, HttpServletResponse response, Object args) throws Exception {
                    ExternalRestPublishService.this.handleRequest(service, (MultiCollection<String, AbstractRestPublishService.MappingInfo>)mappings, request, response, null);
                }
            };
            ph.addSubhandler(null, uri.getPath(), rh);
            if (this.sidservers == null) {
                this.sidservers = new HashMap<IServiceIdentifier, Tuple2<PathHandler, URI>>();
            }
            this.sidservers.put(service.getServiceIdentifier(), (Tuple2<PathHandler, URI>)new Tuple2((Object)ph, (Object)uri));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return IFuture.DONE;
    }

    @Override
    public Object getHttpServer(URI uri, PublishInfo info) {
        PathHandler server = null;
        try {
            PathHandler pathHandler = server = this.portservers == null ? null : this.portservers.get(uri.getPort());
            if (server == null) {
                System.out.println("Starting new server: " + uri.getPort());
                PathHandler ph = new PathHandler();
                if (this.portservers == null) {
                    this.portservers = new HashMap<Integer, PathHandler>();
                }
                this.portservers.put(uri.getPort(), ph);
                server = ph;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return server;
    }

    @Override
    public IFuture<Void> unpublishService(IServiceIdentifier sid) {
        Tuple2<PathHandler, URI> tup = this.sidservers.get(sid);
        if (tup != null) {
            ((PathHandler)tup.getFirstEntity()).removeSubhandler(null, ((URI)tup.getSecondEntity()).toString());
        }
        return IFuture.DONE;
    }

    @Override
    public IFuture<Void> publishHMTLPage(URI uri, String vhost, String html) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFuture<Void> publishResources(URI uri, String rootpath) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IFuture<Void> publishExternal(URI uri, String rootpath) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> publishRedirect(URI uri, String html) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> unpublish(String vhost, URI uri) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> mirrorHttpServer(URI sourceserveruri, URI targetserveruri, PublishInfo info) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> shutdownHttpServer(URI uri) {
        throw new UnsupportedOperationException();
    }

    public String getServicesInfo(HttpServletRequest request, PathHandler ph) {
        StringBuffer ret = new StringBuffer();
        try {
            String functionsjs = this.loadFunctionJS();
            String stylecss = this.loadStyleCSS();
            ret.append("<html>");
            ret.append("\n");
            ret.append("<head>");
            ret.append("\n");
            ret.append(stylecss);
            ret.append("\n");
            ret.append(functionsjs);
            ret.append("\n");
            ret.append("</head>");
            ret.append("\n");
            ret.append("<body>");
            ret.append("\n");
            ret.append("<div class=\"header\">");
            ret.append("\n");
            ret.append("<h1>");
            ret.append("Published Services Info");
            ret.append("</h1>");
            ret.append("\n");
            ret.append("</div>");
            ret.append("\n");
            ret.append("<div class=\"middle\">");
            ret.append("\n");
            Map<Tuple2<String, String>, Tuple2<String, IRequestHandler>> subhandlers = ph.getSubhandlers();
            for (Tuple2<String, String> key : subhandlers.keySet()) {
                ret.append("<div class=\"method\">");
                String path = (String)key.getSecondEntity();
                if (path.startsWith("/DEFAULTAPP")) {
                    path = path.replaceFirst("/DEFAULTAPP", request.getContextPath());
                }
                String url = ExternalRestPublishService.getServletHost(request) + path;
                ret.append("Host: ").append(key.getFirstEntity() != null ? (String)key.getFirstEntity() : "-").append(" Path: ").append(path).append("<br/>");
                ret.append("<a href=\"").append(url).append("\">").append(url).append("</a>");
                ret.append("</div>");
            }
            ret.append("</div>");
            ret.append("\n");
            ret.append("<div id=\"result\"></div>");
            ret.append("<div class=\"powered\"> <span class=\"powered\">powered by</span> <span class=\"jadex\">Jadex Active Components</span> <a class=\"jadexurl\" href=\"http://www.activecomponents.org\">http://www.activecomponents.org</a> </div>\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        ret.append("</body>\n</html>\n");
        return ret.toString();
    }
}

