/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import com.eclipsesource.json.Json;
import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonValue;
import jadex.base.PlatformConfiguration;
import jadex.base.Starter;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IComponentStep;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ServiceCall;
import jadex.bridge.component.IExecutionFeature;
import jadex.bridge.service.IService;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.PublishInfo;
import jadex.bridge.service.annotation.ParameterInfo;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.ServiceComponent;
import jadex.bridge.service.annotation.ServiceStart;
import jadex.bridge.service.types.publish.IWebPublishService;
import jadex.commons.ICommand;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.collection.ILeaseTimeSet;
import jadex.commons.collection.LeaseTimeSet;
import jadex.commons.collection.MultiCollection;
import jadex.commons.concurrent.TimeoutException;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IIntermediateFutureCommandResultListener;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.future.ITerminableFuture;
import jadex.commons.transformation.BasicTypeConverter;
import jadex.commons.transformation.IObjectStringConverter;
import jadex.commons.transformation.binaryserializer.IErrorReporter;
import jadex.extension.rs.publish.IAsyncContextInfo;
import jadex.extension.rs.publish.annotation.ParametersMapper;
import jadex.extension.rs.publish.annotation.ResultMapper;
import jadex.extension.rs.publish.mapper.DefaultParameterMapper;
import jadex.extension.rs.publish.mapper.IParameterMapper;
import jadex.extension.rs.publish.mapper.IValueMapper;
import jadex.javaparser.SJavaParser;
import jadex.transformation.jsonserializer.JsonTraverser;
import jadex.xml.bean.JavaReader;
import jadex.xml.bean.JavaWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Service
public abstract class AbstractRestPublishService
implements IWebPublishService {
    public static final String ASYNC_CONTEXT_INFO = "__cinfo";
    public static final String HEADER_JADEX_CALLID = "x-jadex-callid";
    public static final String HEADER_JADEX_CALLFINISHED = "x-jadex-callidfin";
    public static final String HEADER_JADEX_CLIENTTIMEOUT = "x-jadex-clienttimeout";
    public static final String FINISHED = "__finished__";
    public static List<String> PARAMETER_MEDIATYPES = Arrays.asList("text/plain", "application/json", "application/xml");
    @ServiceComponent
    protected IInternalAccess component;
    protected Map<String, RequestInfo> requestinfos;
    protected MultiCollection<String, AsyncContext> requestspercall;
    protected MultiCollection<String, IObjectStringConverter> converters;

    @ServiceStart
    public IFuture<Void> init() {
        this.converters = new MultiCollection();
        this.requestinfos = new LinkedHashMap<String, RequestInfo>();
        IObjectStringConverter jsonc = new IObjectStringConverter(){

            public String convertObject(Object val, Object context) {
                byte[] data = JsonTraverser.objectToByteArray((Object)val, (ClassLoader)AbstractRestPublishService.this.component.getClassLoader(), null, (boolean)false, (boolean)false, null, null);
                return new String(data);
            }
        };
        this.converters.add((Object)"application/json", (Object)jsonc);
        this.converters.add((Object)"*/*", (Object)jsonc);
        IObjectStringConverter jjsonc = new IObjectStringConverter(){

            public String convertObject(Object val, Object context) {
                byte[] data = JsonTraverser.objectToByteArray((Object)val, (ClassLoader)AbstractRestPublishService.this.component.getClassLoader(), null, (boolean)true, (boolean)true, null, null);
                return new String(data);
            }
        };
        this.converters.add((Object)"application/x.json+jadex", (Object)jjsonc);
        this.converters.add((Object)"*/*", (Object)jjsonc);
        IObjectStringConverter xmlc = new IObjectStringConverter(){

            public String convertObject(Object val, Object context) {
                byte[] data = JavaWriter.objectToByteArray((Object)val, (ClassLoader)AbstractRestPublishService.this.component.getClassLoader());
                return new String(data);
            }
        };
        this.converters.add((Object)"application/xml", (Object)xmlc);
        this.converters.add((Object)"*/*", (Object)xmlc);
        IObjectStringConverter tostrc = new IObjectStringConverter(){

            public String convertObject(Object val, Object context) {
                System.out.println("write response in plain text (toString)");
                return val.toString();
            }
        };
        this.converters.add((Object)"text/plain", (Object)tostrc);
        this.converters.add((Object)"*/*", (Object)tostrc);
        final Long to = (Long)PlatformConfiguration.getPlatformValue((IComponentIdentifier)this.component.getComponentIdentifier(), (String)"default_remote_timeout");
        System.out.println("Using default client timeout: " + to);
        this.requestspercall = new MultiCollection<String, AsyncContext>(){

            public Collection<AsyncContext> createCollection(final String callid) {
                return LeaseTimeSet.createLeaseTimeCollection((long)to, (ICommand)new ICommand<AsyncContext>(){

                    public void execute(AsyncContext ctx) {
                        System.out.println("sending timeout to client " + ctx.getRequest());
                        AbstractRestPublishService.this.writeResponse(null, Response.Status.REQUEST_TIMEOUT.getStatusCode(), callid, null, (HttpServletRequest)ctx.getRequest(), (HttpServletResponse)ctx.getResponse(), false);
                    }
                });
            }
        };
        return IFuture.DONE;
    }

    public void addConverter(String[] mediatypes, IObjectStringConverter converter) {
        for (String mediatype : mediatypes) {
            this.converters.add((Object)mediatype, (Object)converter);
        }
    }

    public void removeConverter(String[] mediatypes, IObjectStringConverter converter) {
        for (String mediatype : mediatypes) {
            this.converters.removeObject((Object)mediatype, (Object)converter);
        }
    }

    public IFuture<Boolean> isSupported(String publishtype) {
        return "rs".equals(publishtype) ? IFuture.TRUE : IFuture.FALSE;
    }

    public void handleRequest(final IService service, final MultiCollection<String, MappingInfo> mappings, final HttpServletRequest request, final HttpServletResponse response, final Object[] others) throws IOException, ServletException {
        block17: {
            String callid;
            if (!((IExecutionFeature)this.component.getComponentFeature(IExecutionFeature.class)).isComponentThread()) {
                ((IExecutionFeature)this.component.getComponentFeature(IExecutionFeature.class)).scheduleStep((IComponentStep)new IComponentStep<Void>(){

                    public IFuture<Void> execute(IInternalAccess ia) {
                        try {
                            AbstractRestPublishService.this.handleRequest(service, (MultiCollection<String, MappingInfo>)mappings, request, response, others);
                            return IFuture.DONE;
                        }
                        catch (Exception e) {
                            return new Future(e);
                        }
                    }
                }).get();
                return;
            }
            if (request.getAttribute(ASYNC_CONTEXT_INFO) == null) {
                AsyncContext rctx = request.startAsync();
                final boolean[] complete = new boolean[1];
                AsyncListener alis = new AsyncListener(){

                    public void onTimeout(AsyncEvent arg0) throws IOException {
                    }

                    public void onStartAsync(AsyncEvent arg0) throws IOException {
                    }

                    public void onError(AsyncEvent arg0) throws IOException {
                    }

                    public void onComplete(AsyncEvent arg0) throws IOException {
                        complete[0] = true;
                    }
                };
                rctx.addListener(alis);
                request.setAttribute(ASYNC_CONTEXT_INFO, (Object)new IAsyncContextInfo(){

                    @Override
                    public boolean isComplete() {
                        return complete[0];
                    }
                });
            }
            if (this.requestinfos.containsKey(callid = request.getHeader(HEADER_JADEX_CALLID))) {
                Object result;
                RequestInfo rinfo = this.requestinfos.get(callid);
                if (rinfo.checkForResult()) {
                    result = rinfo.getNextResult();
                    result = FINISHED.equals(result) ? result : this.mapResult(rinfo.getMappingInfo().getMethod(), result);
                    this.writeResponse(result, callid, rinfo.getMappingInfo(), request, response, false);
                } else if (rinfo.getException() != null) {
                    result = this.mapResult(rinfo.getMappingInfo().getMethod(), rinfo.getException());
                    this.writeResponse(result, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), callid, rinfo.getMappingInfo(), request, response, true);
                } else {
                    AsyncContext ctx = this.getAsyncContext(request);
                    this.saveRequestContext(callid, ctx);
                }
            } else if (callid != null) {
                this.writeResponse(null, Response.Status.NOT_FOUND.getStatusCode(), null, null, request, response, true);
            } else {
                String methodname = request.getPathInfo();
                if (methodname != null && methodname.startsWith("/")) {
                    methodname = methodname.substring(1);
                }
                if (mappings.containsKey((Object)methodname)) {
                    try {
                        Collection mis = mappings.get((Object)methodname);
                        Tuple2<MappingInfo, Object[]> tup = this.mapParameters(request, mis);
                        final MappingInfo mi = (MappingInfo)tup.getFirstEntity();
                        Object[] params = (Object[])tup.getSecondEntity();
                        Map<String, String> callerinfos = this.extractCallerValues(request);
                        ServiceCall.getOrCreateNextInvocation().setProperty("webcallerinfos", callerinfos);
                        final Method method = mi.getMethod();
                        final Object ret = method.invoke((Object)service, params);
                        if (ret instanceof IIntermediateFuture) {
                            AsyncContext ctx = this.getAsyncContext(request);
                            final String fcallid = SUtil.createUniqueId((String)methodname);
                            this.saveRequestContext(fcallid, ctx);
                            final RequestInfo rinfo = new RequestInfo(mi);
                            this.requestinfos.put(fcallid, rinfo);
                            ((IIntermediateFuture)ret).addIntermediateResultListener(((IExecutionFeature)this.component.getComponentFeature(IExecutionFeature.class)).createResultListener((IIntermediateResultListener)new IIntermediateFutureCommandResultListener<Object>(){

                                public void resultAvailable(Collection<Object> result) {
                                    for (Object res : result) {
                                        this.intermediateResultAvailable(res);
                                    }
                                    this.finished();
                                }

                                public void exceptionOccurred(Exception exception) {
                                    this.handleResult(null, exception, null);
                                }

                                public void intermediateResultAvailable(Object result) {
                                    this.handleResult(result, null, null);
                                }

                                public void commandAvailable(Object command) {
                                    this.handleResult(null, null, command);
                                }

                                public void finished() {
                                    this.handleResult(AbstractRestPublishService.FINISHED, null, null);
                                }

                                protected void handleResult(Object result, Throwable exception, Object command) {
                                    if (!rinfo.isTerminated()) {
                                        if (AbstractRestPublishService.this.requestspercall.containsKey((Object)fcallid) && AbstractRestPublishService.this.requestspercall.get((Object)fcallid).size() > 0) {
                                            Collection cls = AbstractRestPublishService.this.requestspercall.get((Object)fcallid);
                                            AsyncContext ctx = (AsyncContext)cls.iterator().next();
                                            cls.remove(ctx);
                                            if (command != null) {
                                                AbstractRestPublishService.this.writeResponse(null, 202, fcallid, mi, (HttpServletRequest)ctx.getRequest(), (HttpServletResponse)ctx.getResponse(), false);
                                            } else if (exception != null) {
                                                result = AbstractRestPublishService.this.mapResult(method, exception);
                                                AbstractRestPublishService.this.writeResponse(result, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), fcallid, mi, (HttpServletRequest)ctx.getRequest(), (HttpServletResponse)ctx.getResponse(), true);
                                            } else {
                                                result = AbstractRestPublishService.FINISHED.equals(result) ? result : AbstractRestPublishService.this.mapResult(method, result);
                                                AbstractRestPublishService.this.writeResponse(result, fcallid, mi, (HttpServletRequest)ctx.getRequest(), (HttpServletResponse)ctx.getResponse(), false);
                                            }
                                        } else {
                                            if (!AbstractRestPublishService.FINISHED.equals(result) && exception == null && System.currentTimeMillis() - rinfo.getTimestamp() > Starter.getRemoteDefaultTimeout((IComponentIdentifier)AbstractRestPublishService.this.component.getComponentIdentifier())) {
                                                rinfo.setTerminated();
                                                if (ret instanceof ITerminableFuture) {
                                                    ((ITerminableFuture)ret).terminate((Exception)new TimeoutException());
                                                } else {
                                                    throw new TimeoutException();
                                                }
                                            }
                                            if (!rinfo.isTerminated() && exception != null) {
                                                rinfo.setException(exception);
                                            } else if (!rinfo.isTerminated() && command == null) {
                                                rinfo.addResult(result);
                                            }
                                        }
                                    }
                                }
                            }));
                            break block17;
                        }
                        if (ret instanceof IFuture) {
                            AsyncContext ctx = this.getAsyncContext(request);
                            ((IFuture)ret).addResultListener(((IExecutionFeature)this.component.getComponentFeature(IExecutionFeature.class)).createResultListener((IResultListener)new IResultListener<Object>(){

                                public void resultAvailable(Object ret) {
                                    ret = AbstractRestPublishService.this.mapResult(method, ret);
                                    AbstractRestPublishService.this.writeResponse(ret, null, mi, request, response, true);
                                }

                                public void exceptionOccurred(Exception exception) {
                                    Object result = AbstractRestPublishService.this.mapResult(method, exception);
                                    AbstractRestPublishService.this.writeResponse(result, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, mi, request, response, true);
                                }
                            }));
                            break block17;
                        }
                        Object res = this.mapResult(method, ret);
                        this.writeResponse(res, null, mi, request, response, true);
                    }
                    catch (Exception e) {
                        this.writeResponse(e, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, request, response, true);
                    }
                } else {
                    PrintWriter out = response.getWriter();
                    response.setContentType("text/html; charset=utf-8");
                    response.setStatus(200);
                    String info = this.getServiceInfo(service, AbstractRestPublishService.getServletUrl(request), mappings);
                    out.write(info);
                    this.complete(request, response);
                }
            }
        }
    }

    public abstract IFuture<Void> publishService(IServiceIdentifier var1, PublishInfo var2);

    public abstract Object getHttpServer(URI var1, PublishInfo var2);

    protected AsyncContext getAsyncContext(HttpServletRequest request) {
        return request.isAsyncStarted() ? request.getAsyncContext() : request.startAsync();
    }

    protected Tuple2<MappingInfo, Object[]> mapParameters(HttpServletRequest request, Collection<MappingInfo> mis) {
        try {
            MappingInfo mi;
            Object[] targetparams;
            block35: {
                int i;
                Object[] inparams;
                Method method;
                block33: {
                    MultiCollection inparamsmap;
                    block34: {
                        int i2;
                        targetparams = null;
                        inparamsmap = null;
                        if (request.getQueryString() != null) {
                            inparamsmap = AbstractRestPublishService.splitQueryString(request.getQueryString());
                        }
                        if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data") && request.getParts().size() > 0) {
                            if (inparamsmap == null) {
                                inparamsmap = new MultiCollection(new LinkedHashMap(), ArrayList.class);
                            }
                            for (Part part : request.getParts()) {
                                Object data = SUtil.readStream((InputStream)part.getInputStream());
                                inparamsmap.add((Object)part.getName(), (Object)new String((byte[])data));
                            }
                        }
                        mi = null;
                        if (mis.size() == 1) {
                            mi = mis.iterator().next();
                        } else {
                            int psize = inparamsmap == null ? 0 : inparamsmap.size();
                            for (MappingInfo tst : mis) {
                                if (psize != tst.getMethod().getParameterTypes().length) continue;
                                mi = tst;
                                break;
                            }
                        }
                        if (mi == null) {
                            throw new RuntimeException("No method mapping found.");
                        }
                        method = mi.getMethod();
                        Class<?>[] types = mi.getMethod().getParameterTypes();
                        String mts = request.getHeader("Content-Type");
                        List<String> cl = AbstractRestPublishService.parseMimetypes(mts);
                        List<String> sr = mi.getProducedMediaTypes();
                        if (sr == null || sr.size() == 0) {
                            sr = cl;
                        } else {
                            sr.retainAll(cl);
                        }
                        Object[] objectArray = inparams = inparamsmap == null ? SUtil.EMPTY_OBJECT_ARRAY : new Object[inparamsmap.size()];
                        if (inparamsmap != null) {
                            i2 = 0;
                            List<String> pnames = AbstractRestPublishService.getParameterNames(method);
                            for (String pname : pnames != null ? pnames : inparamsmap.keySet()) {
                                inparams[i2++] = inparamsmap.getObject((Object)pname);
                            }
                        }
                        for (i2 = 0; i2 < inparams.length; ++i2) {
                            if (!(inparams[i2] instanceof String)) continue;
                            inparams[i2] = this.convertParameter(sr, (String)inparams[i2], types[i2]);
                        }
                        String ct = request.getHeader("Content-Type");
                        if (ct == null) {
                            ct = request.getHeader("Accept");
                        }
                        if ((inparams == null || inparams.length == 0) && types.length > 0 && ct != null && (ct.trim().startsWith("application/json") || ct.trim().startsWith("test/plain"))) {
                            try {
                                byte[] jsonbytes = SUtil.readStream((InputStream)request.getInputStream());
                                String json = new String(jsonbytes, SUtil.UTF8);
                                if (types.length == 1 && json.trim().startsWith("{")) {
                                    List procs = null;
                                    if (SReflect.isSupertype(Map.class, types[0])) {
                                        procs = JsonTraverser.nestedreadprocs;
                                    }
                                    inparams = new Object[]{JsonTraverser.objectFromString((String)json, (ClassLoader)this.component.getClassLoader(), null, types[0], (List)procs)};
                                } else if (types.length == 1 && json.trim().startsWith("\"")) {
                                    inparams = new Object[]{JsonTraverser.objectFromString((String)json, (ClassLoader)this.component.getClassLoader(), null, types[0], null)};
                                } else {
                                    JsonArray array = (JsonArray)Json.parse((String)json);
                                    inparams = new Object[array.size()];
                                    for (int i3 = 0; i3 < array.size(); ++i3) {
                                        List procs = null;
                                        if (SReflect.isSupertype(Map.class, types[i3])) {
                                            procs = JsonTraverser.nestedreadprocs;
                                        }
                                        JsonValue val = array.get(i3);
                                        inparams[i3] = JsonTraverser.objectFromString((String)val.toString(), (ClassLoader)this.component.getClassLoader(), null, types[i3], (List)procs);
                                    }
                                }
                            }
                            catch (Exception e) {
                                this.component.getLogger().warning("No GET parameters and error parsing POST parameters for method: " + method + ", " + e);
                            }
                        }
                        if (!method.isAnnotationPresent(ParametersMapper.class)) break block33;
                        ParametersMapper mm = method.getAnnotation(ParametersMapper.class);
                        if (mm.automapping()) break block34;
                        Class pclazz = mm.value().clazz();
                        Object mapper = !Object.class.equals((Object)pclazz) ? pclazz.newInstance() : SJavaParser.evaluateExpression((String)mm.value().value(), null);
                        if (mapper instanceof IValueMapper) {
                            mapper = new DefaultParameterMapper((IValueMapper)mapper);
                        }
                        targetparams = ((IParameterMapper)mapper).convertParameters(inparams, (Object)request);
                        break block35;
                    }
                    Class<?>[] ts = method.getParameterTypes();
                    targetparams = new Object[ts.length];
                    if (ts.length != 1 || inparamsmap == null || !SReflect.isSupertype(ts[0], Map.class)) break block35;
                    targetparams[0] = inparamsmap;
                    ((Map)targetparams[0]).putAll(this.extractCallerValues(request));
                    break block35;
                }
                Class<?>[] ts = method.getParameterTypes();
                targetparams = new Object[ts.length];
                for (i = 0; i < targetparams.length && i < inparams.length; ++i) {
                    Object p = inparams[i];
                    if (p != null && SReflect.isSupertype(ts[i], p.getClass())) {
                        targetparams[i] = p;
                        continue;
                    }
                    if (p instanceof String && ((String)p).length() > 0 && BasicTypeConverter.isExtendedBuiltInType(ts[i])) {
                        targetparams[i] = BasicTypeConverter.getExtendedStringConverter(ts[i]).convertString((String)p, null);
                        continue;
                    }
                    if (p == null || !ts[i].isArray() || !SReflect.isSupertype(ts[i].getComponentType(), p.getClass())) continue;
                    targetparams[i] = Array.newInstance(ts[i].getComponentType(), 1);
                    Array.set(targetparams[i], 0, p);
                }
                for (i = 0; i < targetparams.length; ++i) {
                    if (targetparams[i] != null) continue;
                    if (ts[i].equals(Boolean.TYPE)) {
                        targetparams[i] = Boolean.FALSE;
                        continue;
                    }
                    if (ts[i].equals(Character.TYPE)) {
                        targetparams[i] = Character.valueOf('\u0000');
                        continue;
                    }
                    if (SReflect.getWrappedType(ts[i]) == ts[i]) continue;
                    targetparams[i] = 0;
                }
            }
            return new Tuple2((Object)mi, (Object)targetparams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object convertParameter(List<String> sr, String val, Class<?> targetclazz) {
        Object ret = val;
        boolean done = false;
        if (sr != null && sr.contains("application/json")) {
            try {
                ret = JsonTraverser.objectFromByteArray((byte[])val.getBytes(SUtil.UTF8), (ClassLoader)this.component.getClassLoader(), (IErrorReporter)null, null, targetclazz);
                done = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!done && sr != null && sr.contains("application/xml")) {
            try {
                ret = JavaReader.objectFromByteArray((byte[])val.getBytes(), (ClassLoader)this.component.getClassLoader(), null);
                done = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    protected Object mapResult(Method method, Object ret) {
        if (method.isAnnotationPresent(ResultMapper.class)) {
            try {
                ResultMapper mm = method.getAnnotation(ResultMapper.class);
                Class pclazz = mm.value().clazz();
                IValueMapper mapper = !Object.class.equals((Object)pclazz) ? (IValueMapper)pclazz.newInstance() : (IValueMapper)SJavaParser.evaluateExpression((String)mm.value().value(), null);
                ret = mapper.convertValue(ret);
            }
            catch (Exception e) {
                SUtil.throwUnchecked((Throwable)e);
            }
        }
        return ret;
    }

    protected void writeResponse(Object result, String callid, MappingInfo mi, HttpServletRequest request, HttpServletResponse response, boolean fin) {
        this.writeResponse(result, Response.Status.OK.getStatusCode(), callid, mi, request, response, fin);
    }

    protected void writeResponse(Object result, int status, String callid, MappingInfo mi, HttpServletRequest request, HttpServletResponse response, boolean fin) {
        if (this.isComplete(request, response)) {
            return;
        }
        if (FINISHED.equals(result)) {
            this.writeResponse(null, status, callid, mi, request, response, true);
        } else {
            List<String> sr = this.writeResponseHeader(result, status, callid, mi, request, response, fin);
            this.writeResponseContent(result, request, response, sr);
            if (fin) {
                this.requestspercall.remove((Object)callid);
                this.requestinfos.remove(callid);
            }
        }
    }

    protected List<String> writeResponseHeader(Object ret, int status, String callid, MappingInfo mi, HttpServletRequest request, HttpServletResponse response, boolean fin) {
        List<String> sr = null;
        if (ret instanceof Response) {
            Response resp = (Response)ret;
            response.setStatus(resp.getStatus());
            for (String name : resp.getStringHeaders().keySet()) {
                response.addHeader(name, resp.getHeaderString(name));
            }
            ret = resp.getEntity();
            if (resp.getMediaType() != null) {
                sr = new ArrayList<String>();
                sr.add(resp.getMediaType().toString());
            }
        } else {
            if (status > 0) {
                response.setStatus(status);
            }
            String mts = request.getHeader("Accept");
            List<String> cl = AbstractRestPublishService.parseMimetypes(mts);
            List<String> list = sr = mi == null ? null : mi.getProducedMediaTypes();
            if (sr == null || sr.size() == 0) {
                sr = cl;
            } else {
                sr.retainAll(cl);
            }
            if (callid != null) {
                if (fin) {
                    response.addHeader(HEADER_JADEX_CALLFINISHED, callid);
                } else {
                    response.addHeader(HEADER_JADEX_CALLID, callid);
                }
            }
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.addHeader("Access-Control-Allow-Credentials", "true ");
            response.addHeader("Access-Control-Allow-Methods", "OPTIONS, GET, POST");
            response.addHeader("Access-Control-Allow-Headers", "Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
        }
        return sr;
    }

    protected void writeResponseContent(Object result, HttpServletRequest request, HttpServletResponse response, List<String> sr) {
        try {
            PrintWriter out = response.getWriter();
            if (result != null) {
                String ret = null;
                String mt = null;
                if (sr != null) {
                    for (String mediatype : sr) {
                        Collection convs = this.converters.get((Object)(mediatype = mediatype.trim()));
                        if (convs == null || convs.size() <= 0) continue;
                        mt = mediatype;
                        Object input = result instanceof Response ? ((Response)result).getEntity() : result;
                        ret = ((IObjectStringConverter)convs.iterator().next()).convertObject(input, null);
                        break;
                    }
                }
                if (mt != null) {
                    if (response.getHeader("Content-Type") == null) {
                        response.setHeader("Content-Type", mt);
                    }
                    if (ret == null) {
                        System.out.println("dfhil");
                    }
                    out.write(ret);
                } else {
                    System.out.println("cannot convert result, writing as string: " + result);
                    response.setHeader("Content-Type", "text/plain");
                    out.write(result.toString());
                }
            }
            this.complete(request, response);
        }
        catch (Exception e) {
            SUtil.throwUnchecked((Throwable)e);
        }
    }

    protected void saveRequestContext(String callid, AsyncContext ctx) {
        this.requestspercall.add((Object)callid, (Object)ctx);
        long to = AbstractRestPublishService.getRequestTimeout((HttpServletRequest)ctx.getRequest());
        if (to > 0L) {
            ((ILeaseTimeSet)this.requestspercall.getCollection((Object)callid)).touch((Object)ctx, to);
        }
    }

    public static long getRequestTimeout(HttpServletRequest request) {
        Long to;
        long ret = -1L;
        String tostr = request.getHeader(HEADER_JADEX_CLIENTTIMEOUT);
        Long l = to = tostr != null ? Long.valueOf(tostr) : null;
        if (to != null) {
            ret = (long)((double)to.longValue() * 0.9);
        }
        return ret;
    }

    public static List<String> parseMimetypes(String mts) {
        ArrayList<String> mimetypes = new ArrayList<String>();
        if (mts != null) {
            StringTokenizer stok = new StringTokenizer(mts, ",");
            while (stok.hasMoreTokens()) {
                String tok = stok.nextToken();
                StringTokenizer substok = new StringTokenizer(tok, ";");
                String mt = substok.nextToken();
                if (mimetypes == null) {
                    mimetypes = new ArrayList();
                }
                mimetypes.add(mt);
            }
        }
        return mimetypes;
    }

    public static MultiCollection<String, String> splitQueryString(String query) throws Exception {
        String[] pairs;
        MultiCollection ret = new MultiCollection(new LinkedHashMap(), ArrayList.class);
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            ret.add((Object)URLDecoder.decode(pair.substring(0, idx), "UTF-8"), (Object)URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        return ret;
    }

    public MultiCollection<String, MappingInfo> evaluateMapping(IServiceIdentifier sid, PublishInfo pi) {
        Class mapcl;
        Class clazz = mapcl = pi.getMapping() == null ? null : pi.getMapping().getType(this.component.getClassLoader());
        if (mapcl == null) {
            mapcl = sid.getServiceType().getType(this.component.getClassLoader());
        }
        MultiCollection ret = new MultiCollection();
        MultiCollection natret = new MultiCollection();
        for (Method m : SReflect.getAllMethods((Class)mapcl)) {
            MappingInfo mi = new MappingInfo();
            if (m.isAnnotationPresent(GET.class)) {
                mi.setHttpMethod(MappingInfo.HttpMethod.GET);
            } else if (m.isAnnotationPresent(POST.class)) {
                mi.setHttpMethod(MappingInfo.HttpMethod.POST);
            } else if (m.isAnnotationPresent(PUT.class)) {
                mi.setHttpMethod(MappingInfo.HttpMethod.PUT);
            } else if (m.isAnnotationPresent(DELETE.class)) {
                mi.setHttpMethod(MappingInfo.HttpMethod.DELETE);
            } else if (m.isAnnotationPresent(OPTIONS.class)) {
                mi.setHttpMethod(MappingInfo.HttpMethod.OPTIONS);
            } else if (m.isAnnotationPresent(HEAD.class)) {
                mi.setHttpMethod(MappingInfo.HttpMethod.HEAD);
            }
            if (m.isAnnotationPresent(Path.class)) {
                Path path = m.getAnnotation(Path.class);
                mi.setPath(path.value());
            } else if (!mi.isEmpty()) {
                mi.setPath(m.getName());
            }
            if (!mi.isEmpty()) {
                String[] types;
                if (m.isAnnotationPresent(Consumes.class)) {
                    Consumes con = m.getAnnotation(Consumes.class);
                    for (String type : types = con.value()) {
                        mi.addConsumedMediaType(type);
                    }
                }
                if (m.isAnnotationPresent(Produces.class)) {
                    Produces prod = m.getAnnotation(Produces.class);
                    for (String type : types = prod.value()) {
                        mi.addProducedMediaType(type);
                    }
                }
                mi.setMethod(m);
                ret.add((Object)mi.getPath(), (Object)mi);
            }
            natret.add((Object)m.getName(), (Object)new MappingInfo(null, m, m.getName()));
        }
        return ret.size() > 0 ? ret : natret;
    }

    public static String getServletUrl(HttpServletRequest req) {
        StringBuffer url = new StringBuffer(AbstractRestPublishService.getServletHost(req));
        String cp = req.getContextPath();
        String serp = req.getServletPath();
        if (cp != null) {
            url.append(cp);
        }
        if (serp != null) {
            url.append(serp);
        }
        return url.toString();
    }

    public static String getServletHost(HttpServletRequest req) {
        StringBuffer url = new StringBuffer();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
            url.append(':');
            url.append(req.getServerPort());
        }
        return url.toString();
    }

    public String getServiceInfo(Object service, String baseuri, MultiCollection<String, MappingInfo> mappings) {
        StringBuffer ret = new StringBuffer();
        try {
            String functionsjs = this.loadFunctionJS();
            String stylecss = this.loadStyleCSS();
            ret.append("<html>");
            ret.append("\n");
            ret.append("<head>");
            ret.append("\n");
            ret.append(stylecss);
            ret.append("\n");
            ret.append(functionsjs);
            ret.append("\n");
            ret.append("</head>");
            ret.append("\n");
            ret.append("<body>");
            ret.append("\n");
            ret.append("<div class=\"header\">");
            ret.append("\n");
            ret.append("<h1>");
            String ifacename = ((IService)service).getServiceIdentifier().getServiceType().getTypeName();
            ret.append(SReflect.getUnqualifiedTypeName((String)ifacename));
            ret.append("</h1>");
            ret.append("\n");
            ret.append("</div>");
            ret.append("\n");
            ret.append("<div class=\"middle\">");
            ret.append("\n");
            if (mappings != null) {
                for (MappingInfo mi : (MappingInfo[])mappings.getObjects(MappingInfo.class)) {
                    int j;
                    int j2;
                    Method method = mi.getMethod();
                    MappingInfo.HttpMethod restmethod = mi.getHttpMethod() != null ? mi.getHttpMethod() : this.guessRestType(method);
                    String path = mi.getPath() != null ? mi.getPath() : method.getName();
                    List<String> consumed = mi.getConsumedMediaTypes();
                    List<String> produced = mi.getProducedMediaTypes();
                    if (consumed == null) {
                        consumed = PARAMETER_MEDIATYPES;
                    }
                    if (produced == null) {
                        produced = PARAMETER_MEDIATYPES;
                    }
                    Class<?>[] ptypes = method.getParameterTypes();
                    String[] pnames = new String[ptypes.length];
                    Annotation[][] pannos = method.getParameterAnnotations();
                    for (int p = 0; p < ptypes.length; ++p) {
                        for (int a = 0; a < pannos[p].length; ++a) {
                            if (!(pannos[p][a] instanceof ParameterInfo)) continue;
                            pnames[p] = ((ParameterInfo)pannos[p][a]).value();
                        }
                        if (pnames[p] != null) continue;
                        pnames[p] = "arg" + p;
                    }
                    ret.append("<div class=\"method\">");
                    ret.append("\n");
                    ret.append("<div class=\"methodname\">");
                    ret.append(method.getName());
                    ret.append("(");
                    if (ptypes != null && ptypes.length > 0) {
                        for (j2 = 0; j2 < ptypes.length; ++j2) {
                            ret.append(SReflect.getUnqualifiedClassName(ptypes[j2]));
                            ret.append(" ");
                            ret.append(pnames[j2]);
                            if (j2 + 1 >= ptypes.length) continue;
                            ret.append(", ");
                        }
                    }
                    ret.append(")");
                    ret.append("</div>");
                    ret.append("\n");
                    ret.append("<div class=\"restproperties\">");
                    ret.append("<div id=\"httpmethod\">").append((Object)restmethod).append("</div>");
                    if (consumed != null && consumed.size() > 0) {
                        ret.append("<i>");
                        if (consumed != PARAMETER_MEDIATYPES) {
                            ret.append("Consumes: ");
                        } else {
                            ret.append("Consumes [not declared by the service]: ");
                        }
                        ret.append("</i>");
                        for (j2 = 0; j2 < consumed.size(); ++j2) {
                            ret.append(consumed.get(j2));
                            if (j2 + 1 >= consumed.size()) continue;
                            ret.append(" ,");
                        }
                        ret.append(" ");
                    }
                    if (produced != null && produced.size() > 0) {
                        ret.append("<i>");
                        if (produced != PARAMETER_MEDIATYPES) {
                            ret.append("Produces: ");
                        } else {
                            ret.append("Produces [not declared by the service]: ");
                        }
                        ret.append("</i>");
                        for (j2 = 0; j2 < produced.size(); ++j2) {
                            ret.append(produced.get(j2));
                            if (j2 + 1 >= produced.size()) continue;
                            ret.append(" ,");
                        }
                        ret.append(" ");
                    }
                    ret.append("</div>");
                    ret.append("\n");
                    String link = path;
                    ret.append("<div class=\"servicelink\">");
                    ret.append(link);
                    ret.append("</div>");
                    ret.append("\n");
                    ret.append("<form class=\"arguments\" action=\"").append(link).append("\" method=\"").append((Object)restmethod).append("\" enctype=\"multipart/form-data\" ");
                    ret.append("onSubmit=\"return extract(this)\"");
                    ret.append(">");
                    ret.append("\n");
                    for (j = 0; j < ptypes.length; ++j) {
                        ret.append(pnames[j]).append(": ");
                        ret.append("<input name=\"").append(pnames[j]).append("\" type=\"text\" />");
                    }
                    ret.append("<select name=\"mediatype\">");
                    if (consumed != null && consumed.size() > 0) {
                        for (j = 0; j < consumed.size(); ++j) {
                            if ("multipart/form-data".equals(consumed.get(j)) || "application/x-www-form-urlencoded".equals(consumed.get(j))) continue;
                            ret.append("<option>").append(consumed.get(j)).append("</option>");
                        }
                    } else {
                        ret.append("<option>").append("text/plain").append("</option>");
                    }
                    ret.append("</select>");
                    ret.append("\n");
                    ret.append("<input type=\"submit\" value=\"invoke\"/>");
                    ret.append("</form>");
                    ret.append("\n");
                    ret.append("</div>");
                    ret.append("\n");
                }
            }
            ret.append("</div>");
            ret.append("\n");
            ret.append("<div id=\"result\"></div>");
            ret.append("<div class=\"powered\"> <span class=\"powered\">powered by</span> <span class=\"jadex\">Jadex Active Components</span> <a class=\"jadexurl\" href=\"http://www.activecomponents.org\">http://www.activecomponents.org</a> </div>\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        ret.append("</body>\n</html>\n");
        return ret.toString();
    }

    public String loadFunctionJS() {
        String functionsjs;
        Scanner sc = null;
        try {
            InputStream is = SUtil.getResource0((String)"jadex/extension/rs/publish/functions.js", (ClassLoader)this.component.getClassLoader());
            sc = new Scanner(is);
            functionsjs = sc.useDelimiter("\\A").next();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
        return functionsjs;
    }

    public String loadStyleCSS() {
        String stylecss;
        Scanner sc = null;
        try {
            InputStream is = SUtil.getResource0((String)"jadex/extension/rs/publish/style.css", (ClassLoader)this.component.getClassLoader());
            sc = new Scanner(is);
            stylecss = sc.useDelimiter("\\A").next();
            String stripes = SUtil.loadBinary((String)"jadex/extension/rs/publish/jadex_stripes.png");
            stylecss = stylecss.replace("$stripes", stripes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
        return stylecss;
    }

    public MappingInfo.HttpMethod guessRestType(Method method) {
        boolean hasret;
        MappingInfo.HttpMethod ret = MappingInfo.HttpMethod.GET;
        Class rettype = SReflect.unwrapGenericType((Type)method.getGenericReturnType());
        Class<?>[] paramtypes = method.getParameterTypes();
        boolean hasparams = paramtypes.length > 0;
        boolean bl = hasret = rettype != null && !rettype.equals(Void.class) && !rettype.equals(Void.TYPE);
        if (hasret && hasparams) {
            ret = this.hasStringConvertableParameters(method, rettype, paramtypes) ? MappingInfo.HttpMethod.GET : MappingInfo.HttpMethod.POST;
        }
        return ret;
    }

    public boolean hasStringConvertableParameters(Method method, Class<?> rettype, Class<?>[] paramtypes) {
        boolean ret = true;
        for (int i = 0; i < paramtypes.length && ret; ++i) {
            ret = SReflect.isStringConvertableType(paramtypes[i]);
        }
        return ret;
    }

    protected void complete(HttpServletRequest request, HttpServletResponse response) {
        if (request.isAsyncStarted() && request.getAsyncContext() != null && !this.isComplete(request, response)) {
            request.getAsyncContext().complete();
        }
    }

    protected boolean isComplete(HttpServletRequest request, HttpServletResponse response) {
        IAsyncContextInfo cinfo = (IAsyncContextInfo)request.getAttribute(ASYNC_CONTEXT_INFO);
        if (cinfo == null) {
            System.out.println("warning, async context info is null: " + request.getRequestURL());
        }
        return cinfo != null ? cinfo.isComplete() : response.isCommitted();
    }

    public static List<String> getParameterNames(Method m) {
        ArrayList<String> ret = null;
        boolean anused = false;
        Annotation[][] annos = m.getParameterAnnotations();
        if (annos.length > 0) {
            ret = new ArrayList<String>();
            for (Annotation[] ans : annos) {
                boolean found = false;
                for (Annotation an : ans) {
                    if (!(an instanceof ParameterInfo)) continue;
                    ret.add(((ParameterInfo)an).value());
                    found = true;
                    anused = true;
                    break;
                }
                if (found) continue;
                ret.add(null);
            }
            if (!anused) {
                ret = null;
            }
        }
        return ret;
    }

    public Map<String, String> extractCallerValues(Object request) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (request != null && request instanceof HttpServletRequest) {
            HttpServletRequest sreq = (HttpServletRequest)request;
            ret.put("ip", sreq.getRemoteAddr());
            ret.put("browser", sreq.getHeader("User-Agent"));
            ret.put("querystring", sreq.getQueryString());
        }
        return ret;
    }

    public String getCleanPublishId(String id) {
        return id != null ? id.replace("[", "").replace("]", "") : null;
    }

    public static class RequestInfo {
        protected Queue<Object> results;
        protected MappingInfo mappingInfo;
        protected boolean terminated;
        protected Throwable exception;
        protected long lastcheck;

        public RequestInfo(MappingInfo mappingInfo) {
            this.mappingInfo = mappingInfo;
            this.lastcheck = System.currentTimeMillis();
        }

        public void setTerminated() {
            this.terminated = true;
        }

        public boolean isTerminated() {
            return this.terminated;
        }

        public boolean checkForResult() {
            this.lastcheck = System.currentTimeMillis();
            return this.results != null && !this.results.isEmpty();
        }

        public void addResult(Object result) {
            if (this.results == null) {
                this.results = new ArrayDeque<Object>();
            }
            this.results.add(result);
        }

        public MappingInfo getMappingInfo() {
            return this.mappingInfo;
        }

        public Throwable getException() {
            return this.exception;
        }

        public void setException(Throwable exception) {
            this.exception = exception;
        }

        public Object getNextResult() {
            return this.results.remove();
        }

        public long getTimestamp() {
            return this.lastcheck;
        }
    }

    public static class MappingInfo {
        protected HttpMethod httpmethod;
        protected Method method;
        protected String path;
        protected List<String> producedtypes;
        protected List<String> consumedtypes;

        public MappingInfo() {
        }

        public MappingInfo(HttpMethod httpMethod, Method method, String path) {
            this.httpmethod = httpMethod;
            this.method = method;
            this.path = path;
        }

        public HttpMethod getHttpMethod() {
            return this.httpmethod;
        }

        public void setHttpMethod(HttpMethod httpMethod) {
            this.httpmethod = httpMethod;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public List<String> getProducedMediaTypes() {
            return this.producedtypes;
        }

        public void setProducedMediaTypes(List<String> respmediatypes) {
            this.producedtypes = respmediatypes;
        }

        public void addProducedMediaType(String type) {
            if (this.producedtypes == null) {
                this.producedtypes = new ArrayList<String>();
            }
            this.producedtypes.add(type);
        }

        public List<String> getConsumedMediaTypes() {
            return this.consumedtypes;
        }

        public void setConsumedMediaTypes(List<String> respmediatypes) {
            this.consumedtypes = respmediatypes;
        }

        public void addConsumedMediaType(String type) {
            if (this.consumedtypes == null) {
                this.consumedtypes = new ArrayList<String>();
            }
            this.consumedtypes.add(type);
        }

        public boolean isEmpty() {
            return this.path == null && this.method == null && this.httpmethod == null;
        }

        public static enum HttpMethod {
            GET,
            POST,
            PUT,
            DELETE,
            OPTIONS,
            HEAD;

        }
    }
}

