/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.base.PlatformConfiguration;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ServiceCall;
import jadex.bridge.service.IService;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.PublishInfo;
import jadex.bridge.service.annotation.ParameterInfo;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.ServiceComponent;
import jadex.bridge.service.annotation.ServiceStart;
import jadex.bridge.service.types.publish.IWebPublishService;
import jadex.commons.ICommand;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.collection.ILeaseTimeCollection;
import jadex.commons.collection.LeaseTimeCollection;
import jadex.commons.collection.MultiCollection;
import jadex.commons.future.IFuture;
import jadex.commons.future.IIntermediateFuture;
import jadex.commons.future.IIntermediateResultListener;
import jadex.commons.future.IResultListener;
import jadex.commons.transformation.BasicTypeConverter;
import jadex.commons.transformation.IObjectStringConverter;
import jadex.commons.transformation.binaryserializer.IErrorReporter;
import jadex.extension.rs.publish.IAsyncContextInfo;
import jadex.extension.rs.publish.annotation.ParametersMapper;
import jadex.extension.rs.publish.annotation.ResultMapper;
import jadex.extension.rs.publish.mapper.DefaultParameterMapper;
import jadex.extension.rs.publish.mapper.IParameterMapper;
import jadex.extension.rs.publish.mapper.IValueMapper;
import jadex.javaparser.SJavaParser;
import jadex.transformation.jsonserializer.JsonTraverser;
import jadex.xml.bean.JavaReader;
import jadex.xml.bean.JavaWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.HEAD;
import javax.ws.rs.OPTIONS;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Service
public abstract class AbstractRestPublishService
implements IWebPublishService {
    public static final String ASYNC_CONTEXT_INFO = "__cinfo";
    public static final String HEADER_JADEX_CALLID = "x-jadex-callid";
    public static final String HEADER_JADEX_CALLFINISHED = "x-jadex-callidfin";
    public static final String HEADER_JADEX_CLIENTTIMEOUT = "x-jadex-clienttimeout";
    public static final String FINISHED = "finished";
    public static List<String> PARAMETER_MEDIATYPES = Arrays.asList("text/plain", "application/json", "application/xml");
    @ServiceComponent
    protected IInternalAccess component;
    protected MultiCollection<String, ResultInfo> resultspercall = new MultiCollection();
    protected MultiCollection<String, AsyncContext> requestspercall;
    protected MultiCollection<String, IObjectStringConverter> converters;

    @ServiceStart
    public IFuture<Void> init() {
        this.converters = new MultiCollection();
        this.resultspercall = new MultiCollection();
        IObjectStringConverter jsonc = new IObjectStringConverter(){

            public String convertObject(Object val, Object context) {
                System.out.println("write response in json");
                byte[] data = JsonTraverser.objectToByteArray((Object)val, (ClassLoader)AbstractRestPublishService.this.component.getClassLoader());
                return new String(data);
            }
        };
        this.converters.add((Object)"application/json", (Object)jsonc);
        this.converters.add((Object)"*/*", (Object)jsonc);
        IObjectStringConverter xmlc = new IObjectStringConverter(){

            public String convertObject(Object val, Object context) {
                System.out.println("write response in xml");
                byte[] data = JavaWriter.objectToByteArray((Object)val, (ClassLoader)AbstractRestPublishService.this.component.getClassLoader());
                return new String(data);
            }
        };
        this.converters.add((Object)"application/xml", (Object)xmlc);
        this.converters.add((Object)"*/*", (Object)xmlc);
        IObjectStringConverter tostrc = new IObjectStringConverter(){

            public String convertObject(Object val, Object context) {
                System.out.println("write response in plain text (toString)");
                return val.toString();
            }
        };
        this.converters.add((Object)"text/plain", (Object)tostrc);
        this.converters.add((Object)"*/*", (Object)tostrc);
        final Long to = (Long)PlatformConfiguration.getPlatformValue((IComponentIdentifier)this.component.getComponentIdentifier(), (String)"default_remote_timeout");
        System.out.println("Using default client timeout: " + to);
        this.requestspercall = new MultiCollection<String, AsyncContext>(){

            public Collection<AsyncContext> createCollection(final String callid) {
                return LeaseTimeCollection.createLeaseTimeCollection((long)to, (ICommand)new ICommand<AsyncContext>(){

                    public void execute(AsyncContext ctx) {
                        System.out.println("sending timeout to client");
                        AbstractRestPublishService.this.writeResponse(null, Response.Status.REQUEST_TIMEOUT.getStatusCode(), callid, null, (HttpServletRequest)ctx.getRequest(), (HttpServletResponse)ctx.getResponse(), false);
                    }
                });
            }
        };
        return IFuture.DONE;
    }

    public void addConverter(String[] mediatypes, IObjectStringConverter converter) {
        for (String mediatype : mediatypes) {
            this.converters.add((Object)mediatype, (Object)converter);
        }
    }

    public void removeConverter(String[] mediatypes, IObjectStringConverter converter) {
        for (String mediatype : mediatypes) {
            this.converters.removeObject((Object)mediatype, (Object)converter);
        }
    }

    public IFuture<Boolean> isSupported(String publishtype) {
        return "rs".equals(publishtype) ? IFuture.TRUE : IFuture.FALSE;
    }

    public void handleRequest(IService service, MultiCollection<String, MappingInfo> mappings, final HttpServletRequest request, final HttpServletResponse response, Object[] others) throws IOException, ServletException {
        block14: {
            String callid;
            if (request.getAttribute(ASYNC_CONTEXT_INFO) == null) {
                AsyncContext rctx = request.startAsync();
                final boolean[] complete = new boolean[1];
                AsyncListener alis = new AsyncListener(){

                    public void onTimeout(AsyncEvent arg0) throws IOException {
                    }

                    public void onStartAsync(AsyncEvent arg0) throws IOException {
                    }

                    public void onError(AsyncEvent arg0) throws IOException {
                    }

                    public void onComplete(AsyncEvent arg0) throws IOException {
                        complete[0] = true;
                    }
                };
                rctx.addListener(alis);
                request.setAttribute(ASYNC_CONTEXT_INFO, (Object)new IAsyncContextInfo(){

                    @Override
                    public boolean isComplete() {
                        return complete[0];
                    }
                });
            }
            if (this.requestspercall.containsKey((Object)(callid = request.getHeader(HEADER_JADEX_CALLID)))) {
                Collection results = this.resultspercall.get((Object)callid);
                if (results != null && results.size() > 0) {
                    ResultInfo result = (ResultInfo)results.iterator().next();
                    results.remove(result);
                    this.writeResponse(result.getResult(), callid, result.getMappingInfo(), request, response, false);
                } else {
                    AsyncContext ctx = this.getAsyncContext(request);
                    this.saveRequestContext(callid, ctx);
                }
            } else if (callid != null) {
                this.writeResponse(null, Response.Status.NOT_FOUND.getStatusCode(), null, null, request, response, true);
            } else {
                String methodname = request.getPathInfo();
                if (methodname != null && methodname.startsWith("/")) {
                    methodname = methodname.substring(1);
                }
                if (mappings.containsKey((Object)methodname)) {
                    try {
                        Collection mis = mappings.get((Object)methodname);
                        Tuple2<MappingInfo, Object[]> tup = this.mapParameters(request, mis);
                        final MappingInfo mi = (MappingInfo)tup.getFirstEntity();
                        Object[] params = (Object[])tup.getSecondEntity();
                        Map<String, String> callerinfos = this.extractCallerValues(request);
                        ServiceCall.getOrCreateNextInvocation().setProperty("webcallerinfos", callerinfos);
                        final Method method = mi.getMethod();
                        Object ret = method.invoke((Object)service, params);
                        if (ret instanceof IIntermediateFuture) {
                            AsyncContext ctx = this.getAsyncContext(request);
                            final String fcallid = SUtil.createUniqueId((String)methodname);
                            this.saveRequestContext(fcallid, ctx);
                            ((IIntermediateFuture)ret).addIntermediateResultListener((IIntermediateResultListener)new IIntermediateResultListener<Object>(){

                                public void resultAvailable(Collection<Object> result) {
                                    for (Object res : result) {
                                        this.intermediateResultAvailable(res);
                                    }
                                }

                                public void exceptionOccurred(Exception exception) {
                                    Object result = AbstractRestPublishService.this.mapResult(method, exception);
                                    AbstractRestPublishService.this.writeResponse(result, null, mi, request, response, true);
                                }

                                public void intermediateResultAvailable(Object result) {
                                    result = AbstractRestPublishService.this.mapResult(method, result);
                                    if (AbstractRestPublishService.this.requestspercall.containsKey((Object)fcallid) && AbstractRestPublishService.this.requestspercall.get((Object)fcallid).size() > 0) {
                                        Collection cls = AbstractRestPublishService.this.requestspercall.get((Object)fcallid);
                                        AsyncContext ctx = (AsyncContext)cls.iterator().next();
                                        cls.remove(ctx);
                                        AbstractRestPublishService.this.writeResponse(result, fcallid, mi, (HttpServletRequest)ctx.getRequest(), (HttpServletResponse)ctx.getResponse(), false);
                                    } else {
                                        AbstractRestPublishService.this.resultspercall.add((Object)fcallid, (Object)new ResultInfo(result, fcallid, mi));
                                    }
                                }

                                public void finished() {
                                    this.intermediateResultAvailable(AbstractRestPublishService.FINISHED);
                                }
                            });
                            break block14;
                        }
                        if (ret instanceof IFuture) {
                            AsyncContext ctx = this.getAsyncContext(request);
                            ((IFuture)ret).addResultListener((IResultListener)new IResultListener<Object>(){

                                public void resultAvailable(Object ret) {
                                    ret = AbstractRestPublishService.this.mapResult(method, ret);
                                    AbstractRestPublishService.this.writeResponse(ret, null, mi, request, response, true);
                                }

                                public void exceptionOccurred(Exception exception) {
                                    Object result = AbstractRestPublishService.this.mapResult(method, exception);
                                    AbstractRestPublishService.this.writeResponse(exception, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, mi, request, response, true);
                                }
                            });
                            break block14;
                        }
                        ret = this.mapResult(method, ret);
                        this.writeResponse(ret, null, mi, request, response, true);
                    }
                    catch (Exception e) {
                        this.writeResponse(e, Response.Status.INTERNAL_SERVER_ERROR.getStatusCode(), null, null, request, response, true);
                    }
                } else {
                    PrintWriter out = response.getWriter();
                    response.setContentType("text/html; charset=utf-8");
                    response.setStatus(200);
                    String info = this.getServiceInfo(service, AbstractRestPublishService.getServletUrl(request), mappings);
                    out.write(info);
                    this.complete(request, response);
                }
            }
        }
    }

    public abstract IFuture<Void> publishService(ClassLoader var1, IService var2, PublishInfo var3);

    public abstract Object getHttpServer(URI var1, PublishInfo var2);

    public abstract IFuture<Void> unpublishService(IServiceIdentifier var1);

    public abstract IFuture<Void> publishHMTLPage(URI var1, String var2, String var3);

    public abstract IFuture<Void> publishResources(URI var1, String var2);

    public abstract IFuture<Void> publishExternal(URI var1, String var2);

    protected AsyncContext getAsyncContext(HttpServletRequest request) {
        return request.isAsyncStarted() ? request.getAsyncContext() : request.startAsync();
    }

    protected Tuple2<MappingInfo, Object[]> mapParameters(HttpServletRequest request, Collection<MappingInfo> mis) {
        try {
            MappingInfo mi;
            Object[] targetparams;
            block24: {
                int i;
                Object[] inparams;
                Method method;
                block22: {
                    MultiCollection inparamsmap;
                    block23: {
                        int i2;
                        targetparams = null;
                        inparamsmap = null;
                        if (request.getQueryString() != null) {
                            inparamsmap = AbstractRestPublishService.splitQueryString(request.getQueryString());
                        }
                        if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data") && request.getParts().size() > 0) {
                            if (inparamsmap == null) {
                                inparamsmap = new MultiCollection(new LinkedHashMap(), ArrayList.class);
                            }
                            for (Part part : request.getParts()) {
                                Object data = SUtil.readStream((InputStream)part.getInputStream());
                                inparamsmap.add((Object)part.getName(), (Object)new String((byte[])data));
                            }
                        }
                        mi = null;
                        if (mis.size() == 1) {
                            mi = mis.iterator().next();
                        } else {
                            int psize = inparamsmap == null ? 0 : inparamsmap.size();
                            for (MappingInfo tst : mis) {
                                if (psize != tst.getMethod().getParameterTypes().length) continue;
                                mi = tst;
                                break;
                            }
                        }
                        if (mi == null) {
                            throw new RuntimeException("No method mapping found.");
                        }
                        method = mi.getMethod();
                        Class<?>[] types = mi.getMethod().getParameterTypes();
                        String mts = request.getHeader("Content-Type");
                        List<String> cl = AbstractRestPublishService.parseMimetypes(mts);
                        List<String> sr = mi.getProducedMediaTypes();
                        if (sr == null || sr.size() == 0) {
                            sr = cl;
                        } else {
                            sr.retainAll(cl);
                        }
                        if (sr.size() == 0) {
                            System.out.println("found no acceptable in types.");
                        }
                        Object[] objectArray = inparams = inparamsmap == null ? SUtil.EMPTY_OBJECT_ARRAY : new Object[inparamsmap.size()];
                        if (inparamsmap != null) {
                            i2 = 0;
                            List<String> pnames = AbstractRestPublishService.getParameterNames(method);
                            for (String pname : pnames != null ? pnames : inparamsmap.keySet()) {
                                inparams[i2++] = inparamsmap.getObject((Object)pname);
                            }
                        }
                        for (i2 = 0; i2 < inparams.length; ++i2) {
                            if (!(inparams[i2] instanceof String)) continue;
                            inparams[i2] = this.convertParameter(sr, (String)inparams[i2]);
                        }
                        if (!method.isAnnotationPresent(ParametersMapper.class)) break block22;
                        ParametersMapper mm = method.getAnnotation(ParametersMapper.class);
                        if (mm.automapping()) break block23;
                        Class pclazz = mm.value().clazz();
                        Object mapper = !Object.class.equals((Object)pclazz) ? pclazz.newInstance() : SJavaParser.evaluateExpression((String)mm.value().value(), null);
                        if (mapper instanceof IValueMapper) {
                            mapper = new DefaultParameterMapper((IValueMapper)mapper);
                        }
                        targetparams = ((IParameterMapper)mapper).convertParameters(inparams, (Object)request);
                        break block24;
                    }
                    Class<?>[] ts = method.getParameterTypes();
                    targetparams = new Object[ts.length];
                    if (ts.length != 1 || inparamsmap == null || !SReflect.isSupertype(ts[0], Map.class)) break block24;
                    targetparams[0] = inparamsmap;
                    ((Map)targetparams[0]).putAll(this.extractCallerValues(request));
                    break block24;
                }
                Class<?>[] ts = method.getParameterTypes();
                targetparams = new Object[ts.length];
                for (i = 0; i < targetparams.length && i < inparams.length; ++i) {
                    Object p = inparams[i];
                    if (p != null && SReflect.isSupertype(ts[i], p.getClass())) {
                        targetparams[i] = p;
                        continue;
                    }
                    if (!(p instanceof String) || ((String)p).length() <= 0 || !BasicTypeConverter.isExtendedBuiltInType(ts[i])) continue;
                    targetparams[i] = BasicTypeConverter.getExtendedStringConverter(ts[i]).convertString((String)p, null);
                }
                for (i = 0; i < targetparams.length; ++i) {
                    if (targetparams[i] != null) continue;
                    if (ts[i].equals(Boolean.TYPE)) {
                        targetparams[i] = Boolean.FALSE;
                        continue;
                    }
                    if (ts[i].equals(Character.TYPE)) {
                        targetparams[i] = Character.valueOf('\u0000');
                        continue;
                    }
                    if (SReflect.getWrappedType(ts[i]) == ts[i]) continue;
                    targetparams[i] = 0;
                }
            }
            return new Tuple2((Object)mi, (Object)targetparams);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected Object convertParameter(List<String> sr, String val) {
        Object ret = val;
        boolean done = false;
        if (sr != null && sr.contains("application/json")) {
            try {
                ret = JsonTraverser.objectFromByteArray((byte[])val.getBytes(), (ClassLoader)this.component.getClassLoader(), (IErrorReporter)null);
                done = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (!done && sr != null && sr.contains("application/xml")) {
            try {
                ret = JavaReader.objectFromByteArray((byte[])val.getBytes(), (ClassLoader)this.component.getClassLoader(), null);
                done = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    protected Object mapResult(Method method, Object ret) {
        if (method.isAnnotationPresent(ResultMapper.class)) {
            try {
                ResultMapper mm = method.getAnnotation(ResultMapper.class);
                Class pclazz = mm.value().clazz();
                IValueMapper mapper = !Object.class.equals((Object)pclazz) ? (IValueMapper)pclazz.newInstance() : (IValueMapper)SJavaParser.evaluateExpression((String)mm.value().value(), null);
                ret = mapper.convertValue(ret);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return ret;
    }

    protected void writeResponse(Object result, String callid, MappingInfo mi, HttpServletRequest request, HttpServletResponse response, boolean fin) {
        this.writeResponse(result, Response.Status.OK.getStatusCode(), callid, mi, request, response, fin);
    }

    protected void writeResponse(Object result, int status, String callid, MappingInfo mi, HttpServletRequest request, HttpServletResponse response, boolean fin) {
        if (this.isComplete(request, response)) {
            return;
        }
        if (FINISHED.equals(result)) {
            this.writeResponse(null, status, callid, mi, request, response, true);
        } else {
            List<String> sr = this.writeResponseHeader(result, status, callid, mi, request, response, fin);
            this.writeResponseContent(result, request, response, sr);
            if (fin) {
                this.requestspercall.remove((Object)callid);
                this.resultspercall.remove((Object)callid);
            }
        }
    }

    protected List<String> writeResponseHeader(Object ret, int status, String callid, MappingInfo mi, HttpServletRequest request, HttpServletResponse response, boolean fin) {
        List<String> sr = null;
        if (ret instanceof Response) {
            Response resp = (Response)ret;
            response.setStatus(resp.getStatus());
            for (String name : resp.getStringHeaders().keySet()) {
                response.addHeader(name, resp.getHeaderString(name));
            }
            ret = resp.getEntity();
            if (resp.getMediaType() != null) {
                sr = new ArrayList<String>();
                sr.add(resp.getMediaType().toString());
            }
        } else {
            if (status > 0) {
                response.setStatus(status);
            }
            String mts = request.getHeader("Accept");
            List<String> cl = AbstractRestPublishService.parseMimetypes(mts);
            List<String> list = sr = mi == null ? null : mi.getProducedMediaTypes();
            if (sr == null || sr.size() == 0) {
                sr = cl;
            } else {
                sr.retainAll(cl);
            }
            if (sr.size() == 0) {
                System.out.println("found no acceptable return types.");
            } else {
                System.out.println("acceptable return types: " + sr + " (" + cl + ")");
            }
            if (callid != null) {
                if (fin) {
                    response.addHeader(HEADER_JADEX_CALLFINISHED, callid);
                } else {
                    response.addHeader(HEADER_JADEX_CALLID, callid);
                }
            }
            response.addHeader("Access-Control-Allow-Origin", "*");
            response.addHeader("Access-Control-Allow-Credentials", "true ");
            response.addHeader("Access-Control-Allow-Methods", "OPTIONS, GET, POST");
            response.addHeader("Access-Control-Allow-Headers", "Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
        }
        return sr;
    }

    protected void writeResponseContent(Object result, HttpServletRequest request, HttpServletResponse response, List<String> sr) {
        try {
            PrintWriter out = response.getWriter();
            if (result != null) {
                String ret = null;
                String mt = null;
                Iterator<String> iterator = sr.iterator();
                while (iterator.hasNext()) {
                    String mediatype;
                    mt = mediatype = iterator.next();
                    Collection convs = this.converters.get((Object)mediatype);
                    if (convs == null || convs.size() <= 0) continue;
                    ret = ((IObjectStringConverter)convs.iterator().next()).convertObject(result, null);
                    break;
                }
                if (mt != null) {
                    if (response.getHeader("Content-Type") == null) {
                        response.setHeader("Content-Type", mt);
                    }
                    out.write(ret);
                } else {
                    System.out.println("cannot convert result, writing as string: " + result);
                    response.setHeader("Content-Type", "text/plain");
                    out.write(result.toString());
                }
            }
            this.complete(request, response);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected void saveRequestContext(String callid, AsyncContext ctx) {
        this.requestspercall.add((Object)callid, (Object)ctx);
        long to = AbstractRestPublishService.getRequestTimeout((HttpServletRequest)ctx.getRequest());
        if (to > 0L) {
            ((ILeaseTimeCollection)this.requestspercall.getCollection((Object)callid)).touch((Object)ctx, to);
        } else {
            System.out.println("no req timeout for call: " + callid);
        }
    }

    public static long getRequestTimeout(HttpServletRequest request) {
        Long to;
        long ret = -1L;
        String tostr = request.getHeader(HEADER_JADEX_CLIENTTIMEOUT);
        Long l = to = tostr != null ? Long.valueOf(tostr) : null;
        if (to != null) {
            ret = (long)((double)to.longValue() * 0.9);
        }
        return ret;
    }

    public static List<String> parseMimetypes(String mts) {
        ArrayList<String> mimetypes = new ArrayList<String>();
        if (mts != null) {
            StringTokenizer stok = new StringTokenizer(mts, ",");
            while (stok.hasMoreTokens()) {
                String tok = stok.nextToken();
                StringTokenizer substok = new StringTokenizer(tok, ";");
                String mt = substok.nextToken();
                if (mimetypes == null) {
                    mimetypes = new ArrayList();
                }
                mimetypes.add(mt);
            }
        }
        return mimetypes;
    }

    public static MultiCollection<String, String> splitQueryString(String query) throws Exception {
        String[] pairs;
        MultiCollection ret = new MultiCollection(new LinkedHashMap(), ArrayList.class);
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            ret.add((Object)URLDecoder.decode(pair.substring(0, idx), "UTF-8"), (Object)URLDecoder.decode(pair.substring(idx + 1), "UTF-8"));
        }
        return ret;
    }

    public MultiCollection<String, MappingInfo> evaluateMapping(IServiceIdentifier sid, PublishInfo pi) {
        Class mapcl;
        Class clazz = mapcl = pi.getMapping() == null ? null : pi.getMapping().getType(this.component.getClassLoader());
        if (mapcl == null) {
            mapcl = sid.getServiceType().getType(this.component.getClassLoader());
        }
        MultiCollection ret = new MultiCollection();
        MultiCollection natret = new MultiCollection();
        for (Method m : SReflect.getAllMethods((Class)mapcl)) {
            MappingInfo mi = new MappingInfo();
            if (m.isAnnotationPresent(GET.class)) {
                mi.setHttpMethod(MappingInfo.HttpMethod.GET);
            } else if (m.isAnnotationPresent(POST.class)) {
                mi.setHttpMethod(MappingInfo.HttpMethod.POST);
            } else if (m.isAnnotationPresent(PUT.class)) {
                mi.setHttpMethod(MappingInfo.HttpMethod.PUT);
            } else if (m.isAnnotationPresent(DELETE.class)) {
                mi.setHttpMethod(MappingInfo.HttpMethod.DELETE);
            } else if (m.isAnnotationPresent(OPTIONS.class)) {
                mi.setHttpMethod(MappingInfo.HttpMethod.OPTIONS);
            } else if (m.isAnnotationPresent(HEAD.class)) {
                mi.setHttpMethod(MappingInfo.HttpMethod.HEAD);
            }
            if (m.isAnnotationPresent(Path.class)) {
                Path path = m.getAnnotation(Path.class);
                mi.setPath(path.value());
            } else if (!mi.isEmpty()) {
                mi.setPath(m.getName());
            }
            if (!mi.isEmpty()) {
                String[] types;
                if (m.isAnnotationPresent(Consumes.class)) {
                    Consumes con = m.getAnnotation(Consumes.class);
                    for (String type : types = con.value()) {
                        mi.addConsumedMediaType(type);
                    }
                }
                if (m.isAnnotationPresent(Produces.class)) {
                    Produces prod = m.getAnnotation(Produces.class);
                    for (String type : types = prod.value()) {
                        mi.addProducedMediaType(type);
                    }
                }
                mi.setMethod(m);
                ret.add((Object)mi.getPath(), (Object)mi);
            }
            natret.add((Object)m.getName(), (Object)new MappingInfo(null, m, m.getName()));
        }
        return ret.size() > 0 ? ret : natret;
    }

    public static String getServletUrl(HttpServletRequest req) {
        StringBuffer url = new StringBuffer(AbstractRestPublishService.getServletHost(req));
        String cp = req.getContextPath();
        String serp = req.getServletPath();
        if (cp != null) {
            url.append(cp);
        }
        if (serp != null) {
            url.append(serp);
        }
        return url.toString();
    }

    public static String getServletHost(HttpServletRequest req) {
        StringBuffer url = new StringBuffer();
        String scheme = req.getScheme();
        int port = req.getServerPort();
        url.append(scheme);
        url.append("://");
        url.append(req.getServerName());
        if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
            url.append(':');
            url.append(req.getServerPort());
        }
        return url.toString();
    }

    public String getServiceInfo(Object service, String baseuri, MultiCollection<String, MappingInfo> mappings) {
        StringBuffer ret = new StringBuffer();
        try {
            String functionsjs = this.loadFunctionJS();
            String stylecss = this.loadStyleCSS();
            ret.append("<html>");
            ret.append("\n");
            ret.append("<head>");
            ret.append("\n");
            ret.append(stylecss);
            ret.append("\n");
            ret.append(functionsjs);
            ret.append("\n");
            ret.append("</head>");
            ret.append("\n");
            ret.append("<body>");
            ret.append("\n");
            ret.append("<div class=\"header\">");
            ret.append("\n");
            ret.append("<h1>");
            String ifacename = ((IService)service).getServiceIdentifier().getServiceType().getTypeName();
            ret.append(SReflect.getUnqualifiedTypeName((String)ifacename));
            ret.append("</h1>");
            ret.append("\n");
            ret.append("</div>");
            ret.append("\n");
            ret.append("<div class=\"middle\">");
            ret.append("\n");
            if (mappings != null) {
                for (MappingInfo mi : (MappingInfo[])mappings.getObjects(MappingInfo.class)) {
                    int j;
                    int j2;
                    Method method = mi.getMethod();
                    MappingInfo.HttpMethod restmethod = mi.getHttpMethod() != null ? mi.getHttpMethod() : this.guessRestType(method);
                    String path = mi.getPath() != null ? mi.getPath() : method.getName();
                    List<String> consumed = mi.getConsumedMediaTypes();
                    List<String> produced = mi.getProducedMediaTypes();
                    if (consumed == null) {
                        consumed = PARAMETER_MEDIATYPES;
                    }
                    if (produced == null) {
                        produced = PARAMETER_MEDIATYPES;
                    }
                    Class<?>[] ptypes = method.getParameterTypes();
                    ret.append("<div class=\"method\">");
                    ret.append("\n");
                    ret.append("<div class=\"methodname\">");
                    ret.append(method.getName());
                    ret.append("(");
                    if (ptypes != null && ptypes.length > 0) {
                        for (j2 = 0; j2 < ptypes.length; ++j2) {
                            ret.append(SReflect.getUnqualifiedClassName(ptypes[j2]));
                            if (j2 + 1 >= ptypes.length) continue;
                            ret.append(", ");
                        }
                    }
                    ret.append(")");
                    ret.append("</div>");
                    ret.append("\n");
                    ret.append("<div class=\"restproperties\">");
                    ret.append("<div id=\"httpmethod\">").append((Object)restmethod).append("</div>");
                    if (consumed != null && consumed.size() > 0) {
                        ret.append("<i>");
                        if (consumed != PARAMETER_MEDIATYPES) {
                            ret.append("Consumes: ");
                        } else {
                            ret.append("Consumes [not declared by the service]: ");
                        }
                        ret.append("</i>");
                        for (j2 = 0; j2 < consumed.size(); ++j2) {
                            ret.append(consumed.get(j2));
                            if (j2 + 1 >= consumed.size()) continue;
                            ret.append(" ,");
                        }
                        ret.append(" ");
                    }
                    if (produced != null && produced.size() > 0) {
                        ret.append("<i>");
                        if (produced != PARAMETER_MEDIATYPES) {
                            ret.append("Produces: ");
                        } else {
                            ret.append("Produces [not declared by the service]: ");
                        }
                        ret.append("</i>");
                        for (j2 = 0; j2 < produced.size(); ++j2) {
                            ret.append(produced.get(j2));
                            if (j2 + 1 >= produced.size()) continue;
                            ret.append(" ,");
                        }
                        ret.append(" ");
                    }
                    ret.append("</div>");
                    ret.append("\n");
                    String link = baseuri.toString();
                    if (path != null) {
                        link = link + "/" + path;
                    }
                    ret.append("<div class=\"servicelink\">");
                    ret.append(link);
                    ret.append("</div>");
                    ret.append("\n");
                    ret.append("<form class=\"arguments\" action=\"").append(link).append("\" method=\"").append((Object)restmethod).append("\" enctype=\"multipart/form-data\" ");
                    ret.append("onSubmit=\"return extract(this)\"");
                    ret.append(">");
                    ret.append("\n");
                    for (j = 0; j < ptypes.length; ++j) {
                        ret.append("arg").append(j).append(": ");
                        ret.append("<input name=\"arg").append(j).append("\" type=\"text\" />");
                    }
                    ret.append("<select name=\"mediatype\">");
                    if (consumed != null && consumed.size() > 0) {
                        for (j = 0; j < consumed.size(); ++j) {
                            if ("multipart/form-data".equals(consumed.get(j)) || "application/x-www-form-urlencoded".equals(consumed.get(j))) continue;
                            ret.append("<option>").append(consumed.get(j)).append("</option>");
                        }
                    } else {
                        ret.append("<option>").append("text/plain").append("</option>");
                    }
                    ret.append("</select>");
                    ret.append("\n");
                    ret.append("<input type=\"submit\" value=\"invoke\"/>");
                    ret.append("</form>");
                    ret.append("\n");
                    ret.append("</div>");
                    ret.append("\n");
                }
            }
            ret.append("</div>");
            ret.append("\n");
            ret.append("<div id=\"result\"></div>");
            ret.append("<div class=\"powered\"> <span class=\"powered\">powered by</span> <span class=\"jadex\">Jadex Active Components</span> <a class=\"jadexurl\" href=\"http://www.activecomponents.org\">http://www.activecomponents.org</a> </div>\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        ret.append("</body>\n</html>\n");
        return ret.toString();
    }

    public String loadFunctionJS() {
        String functionsjs;
        Scanner sc = null;
        try {
            InputStream is = SUtil.getResource0((String)"jadex/extension/rs/publish/functions.js", (ClassLoader)this.component.getClassLoader());
            sc = new Scanner(is);
            functionsjs = sc.useDelimiter("\\A").next();
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
        return functionsjs;
    }

    public String loadStyleCSS() {
        String stylecss;
        Scanner sc = null;
        try {
            InputStream is = SUtil.getResource0((String)"jadex/extension/rs/publish/style.css", (ClassLoader)this.component.getClassLoader());
            sc = new Scanner(is);
            stylecss = sc.useDelimiter("\\A").next();
            String stripes = SUtil.loadBinary((String)"jadex/extension/rs/publish/jadex_stripes.png");
            stylecss = stylecss.replace("$stripes", stripes);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        finally {
            if (sc != null) {
                sc.close();
            }
        }
        return stylecss;
    }

    public MappingInfo.HttpMethod guessRestType(Method method) {
        boolean hasret;
        MappingInfo.HttpMethod ret = MappingInfo.HttpMethod.GET;
        Class rettype = SReflect.unwrapGenericType((Type)method.getGenericReturnType());
        Class<?>[] paramtypes = method.getParameterTypes();
        boolean hasparams = paramtypes.length > 0;
        boolean bl = hasret = rettype != null && !rettype.equals(Void.class) && !rettype.equals(Void.TYPE);
        if (hasret && hasparams) {
            ret = this.hasStringConvertableParameters(method, rettype, paramtypes) ? MappingInfo.HttpMethod.GET : MappingInfo.HttpMethod.POST;
        }
        return ret;
    }

    public boolean hasStringConvertableParameters(Method method, Class<?> rettype, Class<?>[] paramtypes) {
        boolean ret = true;
        for (int i = 0; i < paramtypes.length && ret; ++i) {
            ret = SReflect.isStringConvertableType(paramtypes[i]);
        }
        return ret;
    }

    protected void complete(HttpServletRequest request, HttpServletResponse response) {
        if (request.isAsyncStarted() && request.getAsyncContext() != null && !this.isComplete(request, response)) {
            request.getAsyncContext().complete();
        }
    }

    protected boolean isComplete(HttpServletRequest request, HttpServletResponse response) {
        IAsyncContextInfo cinfo = (IAsyncContextInfo)request.getAttribute(ASYNC_CONTEXT_INFO);
        if (cinfo == null) {
            System.out.println("warning, async context info is null: " + request.getRequestURL());
        }
        return cinfo != null ? cinfo.isComplete() : response.isCommitted();
    }

    public static List<String> getParameterNames(Method m) {
        ArrayList<String> ret = null;
        boolean anused = false;
        Annotation[][] annos = m.getParameterAnnotations();
        if (annos.length > 0) {
            ret = new ArrayList<String>();
            for (Annotation[] ans : annos) {
                boolean found = false;
                for (Annotation an : ans) {
                    if (!(an instanceof ParameterInfo)) continue;
                    ret.add(((ParameterInfo)an).value());
                    found = true;
                    anused = true;
                    break;
                }
                if (found) continue;
                ret.add(null);
            }
            if (!anused) {
                ret = null;
            }
        }
        return ret;
    }

    public Map<String, String> extractCallerValues(Object request) {
        HashMap<String, String> ret = new HashMap<String, String>();
        if (request != null && request instanceof HttpServletRequest) {
            HttpServletRequest sreq = (HttpServletRequest)request;
            ret.put("ip", sreq.getRemoteAddr());
            ret.put("browser", sreq.getHeader("User-Agent"));
            ret.put("querystring", sreq.getQueryString());
        }
        return ret;
    }

    public static class ResultInfo {
        protected String callid;
        protected Object result;
        protected MappingInfo mappingInfo;

        public ResultInfo(Object result, String callid, MappingInfo mappingInfo) {
            this.result = result;
            this.callid = callid;
            this.mappingInfo = mappingInfo;
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object result) {
            this.result = result;
        }

        public String getCallid() {
            return this.callid;
        }

        public void setCallid(String callid) {
            this.callid = callid;
        }

        public MappingInfo getMappingInfo() {
            return this.mappingInfo;
        }

        public void setMappingInfo(MappingInfo mappingInfo) {
            this.mappingInfo = mappingInfo;
        }
    }

    public static class MappingInfo {
        protected HttpMethod httpmethod;
        protected Method method;
        protected String path;
        protected List<String> producedtypes;
        protected List<String> consumedtypes;

        public MappingInfo() {
        }

        public MappingInfo(HttpMethod httpMethod, Method method, String path) {
            this.httpmethod = httpMethod;
            this.method = method;
            this.path = path;
        }

        public HttpMethod getHttpMethod() {
            return this.httpmethod;
        }

        public void setHttpMethod(HttpMethod httpMethod) {
            this.httpmethod = httpMethod;
        }

        public Method getMethod() {
            return this.method;
        }

        public void setMethod(Method method) {
            this.method = method;
        }

        public String getPath() {
            return this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        public List<String> getProducedMediaTypes() {
            return this.producedtypes;
        }

        public void setProducedMediaTypes(List<String> respmediatypes) {
            this.producedtypes = respmediatypes;
        }

        public void addProducedMediaType(String type) {
            if (this.producedtypes == null) {
                this.producedtypes = new ArrayList<String>();
            }
            this.producedtypes.add(type);
        }

        public List<String> getConsumedMediaTypes() {
            return this.consumedtypes;
        }

        public void setConsumedMediaTypes(List<String> respmediatypes) {
            this.consumedtypes = respmediatypes;
        }

        public void addConsumedMediaType(String type) {
            if (this.consumedtypes == null) {
                this.consumedtypes = new ArrayList<String>();
            }
            this.consumedtypes.add(type);
        }

        public boolean isEmpty() {
            return this.path == null && this.method == null && this.httpmethod == null;
        }

        public static enum HttpMethod {
            GET,
            POST,
            PUT,
            DELETE,
            OPTIONS,
            HEAD;

        }
    }
}

