/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.ws.publish;

import jadex.bridge.service.IService;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.PublishInfo;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.types.publish.IPublishService;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.extension.SJavassist;
import jadex.extension.ws.publish.Proxy;
import jadex.extension.ws.publish.WebServiceToJadexWrapperInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.jws.WebService;
import javax.xml.ws.Endpoint;

@Service
public class DefaultWebServicePublishService
implements IPublishService {
    protected Map<IServiceIdentifier, Endpoint> endpoints;

    public IFuture<Boolean> isSupported(String publishtype) {
        return "ws".equals(publishtype) ? IFuture.TRUE : IFuture.FALSE;
    }

    public IFuture<Void> publishService(ClassLoader cl, IService service, PublishInfo pi) {
        Object pr = this.createProxy(service, cl, pi.getMapping().getType(cl));
        ClassLoader ccl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(cl);
        Endpoint endpoint = Endpoint.publish((String)pi.getPublishId(), (Object)pr);
        Thread.currentThread().setContextClassLoader(ccl);
        if (this.endpoints == null) {
            this.endpoints = new HashMap<IServiceIdentifier, Endpoint>();
        }
        this.endpoints.put(service.getServiceIdentifier(), endpoint);
        return IFuture.DONE;
    }

    public IFuture<Void> unpublishService(IServiceIdentifier sid) {
        Endpoint ep;
        Future ret = new Future();
        boolean stopped = false;
        if (this.endpoints != null && (ep = this.endpoints.remove(sid)) != null) {
            ep.stop();
            stopped = true;
            ret.setResult(null);
        }
        if (!stopped) {
            ret.setException((Exception)new RuntimeException("Published service could not be stopped: " + sid));
        }
        return ret;
    }

    protected Object createProxy(IService service, ClassLoader classloader, Class<?> type) {
        Object ret = null;
        try {
            Class<?> clazz = this.getProxyClass(type, classloader);
            ret = clazz.newInstance();
            Method shm = clazz.getMethod("setHandler", InvocationHandler.class);
            shm.invoke(ret, new WebServiceToJadexWrapperInvocationHandler(service));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return ret;
    }

    protected Class<?> getProxyClass(Class<?> type, ClassLoader classloader) {
        Class ret = null;
        ClassPool pool = ClassPool.getDefault();
        String name = type.getPackage().getName() + ".Proxy" + type.getSimpleName();
        try {
            ret = classloader.loadClass(name);
        }
        catch (Exception e) {
            try {
                CtClass proxyclazz = pool.makeClass(name, SJavassist.getCtClass(Proxy.class, pool));
                proxyclazz.addInterface(SJavassist.getCtClass(type, pool));
                Method[] ms = type.getMethods();
                CtMethod invoke = SJavassist.getCtClass(Proxy.class, pool).getDeclaredMethod("invoke");
                for (int i = 0; i < ms.length; ++i) {
                    CtMethod m = CtNewMethod.wrapped((CtClass)SJavassist.getCtClass(ms[i].getReturnType(), pool), (String)ms[i].getName(), (CtClass[])SJavassist.getCtClasses(ms[i].getParameterTypes(), pool), (CtClass[])SJavassist.getCtClasses(ms[i].getExceptionTypes(), pool), (CtMethod)invoke, null, (CtClass)proxyclazz);
                    proxyclazz.addMethod(m);
                }
                ClassFile cf = proxyclazz.getClassFile();
                ConstPool constpool = cf.getConstPool();
                AnnotationsAttribute attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
                Annotation annot = new Annotation(constpool, SJavassist.getCtClass(WebService.class, pool));
                String ns = "http://" + type.getPackage().getName() + "/";
                annot.addMemberValue("targetNamespace", (MemberValue)new StringMemberValue(ns, constpool));
                attr.addAnnotation(annot);
                cf.addAttribute((AttributeInfo)attr);
                proxyclazz.getClassFile().addAttribute((AttributeInfo)attr);
                ret = proxyclazz.toClass(classloader, type.getProtectionDomain());
                proxyclazz.freeze();
            }
            catch (Exception e2) {
                e2.printStackTrace();
                throw new RuntimeException(e2);
            }
        }
        return ret;
    }
}

