/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.base.PlatformConfiguration;
import jadex.base.Starter;
import jadex.bridge.IExternalAccess;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.CreationInfo;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.commons.SUtil;
import jadex.commons.future.IResultListener;
import jadex.extension.rs.publish.IAsyncContextInfo;
import jadex.extension.rs.publish.IRequestHandlerService;
import jadex.javaparser.SJavaParser;
import java.io.IOException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JadexGatewayServlet
extends HttpServlet {
    protected IExternalAccess platform;
    protected IRequestHandlerService handler;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        PlatformConfiguration pc = PlatformConfiguration.getDefault();
        pc.getRootConfig().setGui(false);
        pc.getRootConfig().setRsPublish(true);
        this.platform = (IExternalAccess)Starter.createPlatform((PlatformConfiguration)pc).get();
        IComponentManagementService cms = (IComponentManagementService)SServiceProvider.getService((IExternalAccess)this.platform, IComponentManagementService.class, (String)"platform").get();
        this.handler = (IRequestHandlerService)SServiceProvider.getService((IExternalAccess)this.platform, IRequestHandlerService.class, (String)"platform").get();
        Enumeration pnames = config.getInitParameterNames();
        HashMap<String, Map<String, Object>> comps = new HashMap<String, Map<String, Object>>();
        while (pnames.hasMoreElements()) {
            String cname = (String)pnames.nextElement();
            if (!cname.startsWith("component")) continue;
            int cnt = SUtil.countOccurrences((String)cname, (char)'_');
            if (cnt == 1) {
                Map<String, Object> comp = this.getComoponentMap(cname, comps);
                comp.put("__model", config.getInitParameter(cname));
                continue;
            }
            if (cnt != 2) continue;
            int idx = cname.lastIndexOf("_");
            String pname = cname.substring(idx + 1);
            String rcname = cname.substring(0, idx);
            Map<String, Object> comp = this.getComoponentMap(rcname, comps);
            String arg = config.getInitParameter(pname);
            if (arg == null) continue;
            try {
                Object o = SJavaParser.evaluateExpression((String)arg, null);
                comp.put(pname, o);
            }
            catch (Exception e) {
                throw new RuntimeException("Arguments evaluation error: " + e);
            }
        }
        System.out.println("Found components: " + comps);
        for (Map.Entry entry : comps.entrySet()) {
            String model = (String)((Map)entry.getValue()).remove("__model");
            CreationInfo cinfo = new CreationInfo((Map)entry.getValue());
            cms.createComponent(model, cinfo).getFirstResult();
        }
    }

    protected Map<String, Object> getComoponentMap(String cname, Map<String, Map<String, Object>> comps) {
        Map<String, Object> comp = comps.get(cname);
        if (comp == null) {
            comp = new HashMap<String, Object>();
            comps.put(cname, comp);
        }
        return comp;
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        try {
            System.out.println("received request: " + request.getRequestURL().toString());
            final AsyncContext ctx = request.startAsync();
            final boolean[] complete = new boolean[1];
            AsyncListener alis = new AsyncListener(){

                public void onTimeout(AsyncEvent arg0) throws IOException {
                }

                public void onStartAsync(AsyncEvent arg0) throws IOException {
                }

                public void onError(AsyncEvent arg0) throws IOException {
                }

                public void onComplete(AsyncEvent arg0) throws IOException {
                    complete[0] = true;
                }
            };
            ctx.addListener(alis);
            request.setAttribute("__cinfo", (Object)new IAsyncContextInfo(){

                @Override
                public boolean isComplete() {
                    return complete[0];
                }
            });
            this.handler.handleRequest(request, response, null).addResultListener((IResultListener)new IResultListener<Void>(){

                public void exceptionOccurred(Exception e) {
                    if (!complete[0]) {
                        ctx.complete();
                    }
                    throw e instanceof RuntimeException ? (RuntimeException)e : new RuntimeException(e);
                }

                public void resultAvailable(Void result) {
                }
            });
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }
}

