/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.commons.Tuple2;
import jadex.extension.rs.publish.HttpServletRequestWrapper;
import jadex.extension.rs.publish.IRequestHandler;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class PathHandler
implements IRequestHandler {
    protected Map<Tuple2<String, String>, Tuple2<String, IRequestHandler>> subhandlers = new HashMap<Tuple2<String, String>, Tuple2<String, IRequestHandler>>();
    protected Map<Tuple2<String, String>, Tuple2<String, IRequestHandler>> subhandlercache = new HashMap<Tuple2<String, String>, Tuple2<String, IRequestHandler>>();

    @Override
    public void handleRequest(HttpServletRequest request, HttpServletResponse response, Object args) throws Exception {
        Tuple2<String, IRequestHandler> tup;
        String path = request.getRequestURI();
        String host = request.getHeader("host");
        int idx = host.indexOf(":");
        if (idx != -1) {
            host = host.substring(0, idx);
        }
        if ((tup = this.subhandlercache.get(new Tuple2((Object)host, (Object)path))) == null) {
            tup = this.subhandlercache.get(new Tuple2(null, (Object)path));
        }
        int pidx = path.lastIndexOf(47);
        if (tup == null && pidx > 0 && pidx <= path.length() - 1) {
            String cpath = path.substring(0, pidx);
            tup = this.subhandlercache.get(new Tuple2((Object)host, (Object)cpath));
        }
        if (tup == null) {
            tup = this.findSubhandler(host, path);
            if (tup == null) {
                tup = this.findSubhandler(null, path);
            }
            if (tup != null) {
                this.subhandlercache.put((Tuple2<String, String>)new Tuple2((Object)host, (Object)path), tup);
            }
        }
        if (tup == null) {
            throw new RuntimeException("No handler found for path: " + path);
        }
        HttpServletRequestWrapper wr = new HttpServletRequestWrapper(request);
        String cp = (String)tup.getFirstEntity();
        wr.setContextPath(cp);
        String full = request.getRequestURI();
        idx = full.indexOf(cp) + cp.length();
        String npi = full.substring(idx);
        wr.setPathInfo(npi);
        ((IRequestHandler)tup.getSecondEntity()).handleRequest(wr, response, args);
    }

    public void addSubhandler(String vhost, String path, IRequestHandler subhandler) {
        this.subhandlers.put((Tuple2<String, String>)new Tuple2((Object)vhost, (Object)path), (Tuple2<String, IRequestHandler>)new Tuple2((Object)path, (Object)subhandler));
        this.subhandlercache = new HashMap<Tuple2<String, String>, Tuple2<String, IRequestHandler>>(this.subhandlers);
    }

    public boolean containsSubhandlerForExactUri(String vhost, String path) {
        return this.subhandlers.containsKey(new Tuple2((Object)vhost, (Object)path));
    }

    public boolean isEmpty() {
        return this.subhandlers.isEmpty();
    }

    public void removeSubhandler(String vhost, String path) {
        this.subhandlers.remove(new Tuple2((Object)vhost, (Object)path));
        this.subhandlercache = new HashMap<Tuple2<String, String>, Tuple2<String, IRequestHandler>>(this.subhandlers);
    }

    protected Tuple2<String, IRequestHandler> findSubhandler(String host, String path) {
        Tuple2<String, IRequestHandler> ret = null;
        do {
            int pidx;
            if ((pidx = path.lastIndexOf(47)) >= 0) {
                path = path.substring(0, pidx);
                ret = this.subhandlercache.get(new Tuple2((Object)host, (Object)path));
                continue;
            }
            path = null;
        } while (ret == null && path != null && path.length() > 0);
        return ret;
    }

    public Map<Tuple2<String, String>, Tuple2<String, IRequestHandler>> getSubhandlers() {
        return this.subhandlers;
    }
}

