/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.bridge.service.IService;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.PublishInfo;
import jadex.bridge.service.annotation.Service;
import jadex.commons.collection.MultiCollection;
import jadex.commons.future.IFuture;
import jadex.extension.rs.publish.AbstractRestPublishService;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandler;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;

@Service
public class JettyRestPublishService
extends AbstractRestPublishService {
    private static final MultipartConfigElement MULTI_PART_CONFIG = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));
    protected Map<IServiceIdentifier, Server> sidservers;
    protected Map<Integer, Server> portservers;

    public IFuture<Boolean> isSupported(String publishtype) {
        return "rs".equals(publishtype) ? IFuture.TRUE : IFuture.FALSE;
    }

    public IFuture<Void> publishService(ClassLoader cl, final IService service, PublishInfo info) {
        try {
            URI uri = new URI(info.getPublishId());
            Server server = (Server)this.getHttpServer(uri, info);
            System.out.println("Adding http handler to server: " + uri.getPath());
            ContextHandlerCollection collhandler = (ContextHandlerCollection)server.getHandler();
            final MultiCollection mappings = this.evaluateMapping(service.getServiceIdentifier(), info);
            ContextHandler ch = new ContextHandler(){

                public void doHandle(String target, Request baseRequest, HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
                    if (request.getContentType() != null && request.getContentType().startsWith("multipart/form-data")) {
                        baseRequest.setAttribute("org.eclipse.jetty.multipartConfig", (Object)MULTI_PART_CONFIG);
                    }
                    JettyRestPublishService.this.handleRequest(service, mappings, request, response, new Object[]{target, baseRequest});
                    baseRequest.setHandled(true);
                }
            };
            ch.setContextPath(uri.getPath());
            collhandler.addHandler((Handler)ch);
            ch.start();
            if (this.sidservers == null) {
                this.sidservers = new HashMap<IServiceIdentifier, Server>();
            }
            this.sidservers.put(service.getServiceIdentifier(), server);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return IFuture.DONE;
    }

    public Object getHttpServer(URI uri, PublishInfo info) {
        Server server = null;
        try {
            Server server2 = server = this.portservers == null ? null : this.portservers.get(uri.getPort());
            if (server == null) {
                System.out.println("Starting new server: " + uri.getPort());
                server = new Server(uri.getPort());
                server.dumpStdErr();
                ContextHandlerCollection collhandler = new ContextHandlerCollection();
                server.setHandler((Handler)collhandler);
                server.start();
                if (this.portservers == null) {
                    this.portservers = new HashMap<Integer, Server>();
                }
                this.portservers.put(uri.getPort(), server);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return server;
    }

    public IFuture<Void> unpublishService(IServiceIdentifier sid) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> publishHMTLPage(URI uri, String vhost, String html) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> publishResources(URI uri, String rootpath) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> publishExternal(URI uri, String rootpath) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> publishRedirect(URI uri, String html) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> unpublish(String vhost, URI uri) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> mirrorHttpServer(URI sourceserveruri, URI targetserveruri, PublishInfo info) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> shutdownHttpServer(URI uri) {
        throw new UnsupportedOperationException();
    }
}

