/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.bridge.service.IServiceIdentifier;
import jadex.commons.MethodInfo;
import jadex.commons.SReflect;
import jadex.extension.rs.invoke.RSJAXAnnotationHelper;
import jadex.extension.rs.publish.AbstractRestServicePublishService;
import jadex.extension.rs.publish.IRestMethodGenerator;
import jadex.extension.rs.publish.MethodWrapper;
import jadex.extension.rs.publish.RestMethodInfo;
import jadex.extension.rs.publish.Value;
import jadex.extension.rs.publish.annotation.MethodMapper;
import jadex.extension.rs.publish.annotation.ParametersMapper;
import jadex.extension.rs.publish.annotation.ResultMapper;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;

public class DefaultRestMethodGenerator
implements IRestMethodGenerator {
    @Override
    public List<RestMethodInfo> generateRestMethodInfos(IServiceIdentifier serviceid, ClassLoader classloader, Class<?> baseclass, Map<String, Object> mapprops) throws Exception {
        int i;
        Method[] ims;
        ArrayList<RestMethodInfo> ret = new ArrayList<RestMethodInfo>();
        boolean gen = mapprops.get("generate") != null ? (Boolean)mapprops.get("generate") : true;
        boolean geninfo = mapprops.get("generateinfo") != null ? (Boolean)mapprops.get("generateinfo") : true;
        Class iface = serviceid.getServiceType().getType(classloader);
        MediaType[] formats = AbstractRestServicePublishService.DEFAULT_FORMATS;
        Object tmp = mapprops.get("formats");
        if (tmp instanceof String[]) {
            String[] fms = (String[])tmp;
            formats = new MediaType[fms.length];
            for (int i2 = 0; i2 < fms.length; ++i2) {
                formats[i2] = MediaType.valueOf((String)fms[i2]);
            }
        } else if (tmp instanceof MediaType[]) {
            formats = (MediaType[])tmp;
        }
        HashSet<String> paths = new HashSet<String>();
        LinkedHashSet<MethodWrapper> methods = new LinkedHashSet<MethodWrapper>();
        if (baseclass != null) {
            if (baseclass.isInterface()) {
                ims = baseclass.getMethods();
                for (i = 0; i < ims.length; ++i) {
                    DefaultRestMethodGenerator.addMethodWrapper(new MethodWrapper(ims[i]), methods);
                }
            } else {
                Class<?> clazz = baseclass;
                while (!clazz.equals(Object.class)) {
                    Method[] bms = baseclass.getMethods();
                    for (int i3 = 0; i3 < bms.length; ++i3) {
                        if (Modifier.isAbstract(bms[i3].getModifiers())) {
                            DefaultRestMethodGenerator.addMethodWrapper(new MethodWrapper(bms[i3]), methods);
                            continue;
                        }
                        if (bms[i3].isAnnotationPresent(Path.class)) {
                            String path = "";
                            if (bms[i3].isAnnotationPresent(Path.class)) {
                                path = bms[i3].getAnnotation(Path.class).value();
                            }
                            DefaultRestMethodGenerator.addPath(path, paths);
                            continue;
                        }
                        if (RSJAXAnnotationHelper.getDeclaredRestType((Method)bms[i3]) == null) continue;
                        DefaultRestMethodGenerator.addPath("", paths);
                    }
                    clazz = clazz.getSuperclass();
                }
            }
            if (gen) {
                ims = iface.getMethods();
                for (i = 0; i < ims.length; ++i) {
                    try {
                        baseclass.getMethod(ims[i].getName(), ims[i].getParameterTypes());
                        continue;
                    }
                    catch (Exception e) {
                        DefaultRestMethodGenerator.addMethodWrapper(new MethodWrapper(ims[i]), methods);
                    }
                }
            }
        } else {
            ims = iface.getMethods();
            for (i = 0; i < ims.length; ++i) {
                DefaultRestMethodGenerator.addMethodWrapper(new MethodWrapper(ims[i]), methods);
            }
        }
        for (MethodWrapper mw : methods) {
            MethodInfo methodmapper;
            Method method = mw.getMethod();
            ArrayList<MediaType> consumed = new ArrayList<MediaType>();
            ArrayList<MediaType> produced = new ArrayList<MediaType>();
            Class<?> resttype = RSJAXAnnotationHelper.getDeclaredRestType((Method)method);
            if (resttype != null) {
                String[] prods;
                int i4;
                String[] cons;
                if (method.isAnnotationPresent(Consumes.class) && (cons = method.getAnnotation(Consumes.class).value()) != null) {
                    for (i4 = 0; i4 < cons.length; ++i4) {
                        consumed.add(MediaType.valueOf((String)cons[i4]));
                    }
                }
                if (method.isAnnotationPresent(Produces.class) && (prods = method.getAnnotation(Produces.class).value()) != null) {
                    for (i4 = 0; i4 < prods.length; ++i4) {
                        produced.add(MediaType.valueOf((String)prods[i4]));
                    }
                }
                methodmapper = null;
                if (method.isAnnotationPresent(MethodMapper.class)) {
                    MethodMapper mm = method.getAnnotation(MethodMapper.class);
                    methodmapper = new MethodInfo(mm.value(), mm.parameters());
                }
                Value parametermapper = null;
                boolean automapping = false;
                if (method.isAnnotationPresent(ParametersMapper.class)) {
                    ParametersMapper pm = method.getAnnotation(ParametersMapper.class);
                    if (!pm.automapping()) {
                        Class clazz = pm.value().clazz();
                        parametermapper = clazz != null && !Object.class.equals((Object)clazz) ? new Value(clazz) : new Value(pm.value().value());
                    }
                    automapping = pm.automapping();
                }
                Value resultmapper = null;
                if (method.isAnnotationPresent(ResultMapper.class)) {
                    ResultMapper pm = method.getAnnotation(ResultMapper.class);
                    Class clazz = pm.value().clazz();
                    resultmapper = clazz != null && !Object.class.equals((Object)clazz) ? new Value(clazz) : new Value(pm.value().value());
                }
                String path = "";
                path = method.isAnnotationPresent(Path.class) ? method.getAnnotation(Path.class).value() : mw.getName();
                ret.add(new RestMethodInfo(method, mw.getName(), DefaultRestMethodGenerator.getPathName(path, paths), resttype, consumed, produced, methodmapper, parametermapper, automapping, resultmapper, AbstractRestServicePublishService.class, "invoke"));
                continue;
            }
            resttype = this.guessRestType(method);
            if (!GET.class.equals(resttype)) {
                for (int j = 0; j < formats.length; ++j) {
                    consumed.add(formats[j]);
                }
            }
            if (POST.class.equals(resttype)) {
                consumed.add(MediaType.MULTIPART_FORM_DATA_TYPE);
            }
            if (GET.class.equals(resttype)) {
                consumed.add(MediaType.TEXT_PLAIN_TYPE);
            }
            for (int j = 0; j < formats.length; ++j) {
                produced.add(formats[j]);
            }
            methodmapper = new MethodInfo(method.getName(), (Class[])method.getParameterTypes());
            ret.add(new RestMethodInfo(method, mw.getName(), DefaultRestMethodGenerator.getPathName(mw.getName(), paths), resttype, consumed, produced, methodmapper, null, false, null, AbstractRestServicePublishService.class, "invoke"));
        }
        if (geninfo) {
            ArrayList<MediaType> consumed = new ArrayList<MediaType>();
            ArrayList<MediaType> produced = new ArrayList<MediaType>();
            produced.add(MediaType.TEXT_HTML_TYPE);
            ret.add(new RestMethodInfo(new Class[0], (Type)((Object)String.class), new Class[0], "getServiceInfo", DefaultRestMethodGenerator.getPathName("", paths), GET.class, (List<MediaType>)consumed, (List<MediaType>)produced, null, null, false, null, AbstractRestServicePublishService.class, "getServiceInfo"));
        }
        return ret;
    }

    public Class<?> guessRestType(Method method) {
        boolean hasret;
        Class ret = GET.class;
        Class rettype = SReflect.unwrapGenericType((Type)method.getGenericReturnType());
        Class<?>[] paramtypes = method.getParameterTypes();
        boolean hasparams = paramtypes.length > 0;
        boolean bl = hasret = rettype != null && !rettype.equals(Void.class) && !rettype.equals(Void.TYPE);
        if (hasret && hasparams) {
            ret = this.hasStringConvertableParameters(method, rettype, paramtypes) ? GET.class : POST.class;
        }
        return ret;
    }

    protected static void addMethodWrapper(MethodWrapper mw, Set<MethodWrapper> methods) {
        if (methods.contains(mw)) {
            String basename = mw.getName();
            int j = 0;
            while (methods.contains(mw)) {
                mw.setName(basename + j);
                ++j;
            }
        }
        methods.add(mw);
    }

    protected static String getPathName(String path, Set<String> paths) {
        if (paths.contains(path)) {
            String basename = path;
            int i = 0;
            while (paths.contains(path)) {
                path = basename + i;
                ++i;
            }
        }
        DefaultRestMethodGenerator.addPath(path, paths);
        return path;
    }

    protected static void addPath(String path, Set<String> paths) {
        String p = path;
        p = path.endsWith("/") ? path.substring(0, path.length() - 1) : path + "/";
        paths.add(path);
        paths.add(p);
    }

    public boolean hasStringConvertableParameters(Method method, Class<?> rettype, Class<?>[] paramtypes) {
        boolean ret = true;
        for (int i = 0; i < paramtypes.length && ret; ++i) {
            ret = DefaultRestMethodGenerator.isStringConvertableType(paramtypes[i]);
        }
        return ret;
    }

    public static boolean isStringConvertableType(Class<?> type) {
        boolean ret = true;
        if (!SReflect.isStringConvertableType(type)) {
            try {
                Method method = type.getMethod("fromString", String.class);
            }
            catch (Exception e) {
                try {
                    Method method = type.getMethod("valueOf", String.class);
                }
                catch (Exception e2) {
                    ret = false;
                }
            }
        }
        return ret;
    }
}

