/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.bridge.IInternalAccess;
import jadex.bridge.modelinfo.UnparsedExpression;
import jadex.bridge.service.IService;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.PublishInfo;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.annotation.ServiceComponent;
import jadex.bridge.service.types.publish.IWebPublishService;
import jadex.commons.IValueFetcher;
import jadex.commons.MethodInfo;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.Tuple2;
import jadex.commons.collection.LRU;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.extension.SJavassist;
import jadex.extension.rs.invoke.RSJAXAnnotationHelper;
import jadex.extension.rs.publish.DefaultRestMethodGenerator;
import jadex.extension.rs.publish.IRestMethodGenerator;
import jadex.extension.rs.publish.MethodComparator;
import jadex.extension.rs.publish.RestMethodInfo;
import jadex.extension.rs.publish.SInvokeHelper;
import jadex.extension.rs.publish.Value;
import jadex.extension.rs.publish.annotation.MethodMapper;
import jadex.extension.rs.publish.annotation.ParametersMapper;
import jadex.extension.rs.publish.annotation.ResultMapper;
import jadex.javaparser.SJavaParser;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.StringTokenizer;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javassist.ClassPool;
import javassist.CtClass;
import javassist.CtField;
import javassist.CtMethod;
import javassist.CtNewMethod;
import javassist.bytecode.AnnotationsAttribute;
import javassist.bytecode.AttributeInfo;
import javassist.bytecode.ClassFile;
import javassist.bytecode.ConstPool;
import javassist.bytecode.annotation.Annotation;
import javassist.bytecode.annotation.AnnotationMemberValue;
import javassist.bytecode.annotation.ArrayMemberValue;
import javassist.bytecode.annotation.BooleanMemberValue;
import javassist.bytecode.annotation.CharMemberValue;
import javassist.bytecode.annotation.ClassMemberValue;
import javassist.bytecode.annotation.DoubleMemberValue;
import javassist.bytecode.annotation.FloatMemberValue;
import javassist.bytecode.annotation.IntegerMemberValue;
import javassist.bytecode.annotation.LongMemberValue;
import javassist.bytecode.annotation.MemberValue;
import javassist.bytecode.annotation.ShortMemberValue;
import javassist.bytecode.annotation.StringMemberValue;
import javax.inject.Singleton;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.hk2.utilities.binding.AbstractBinder;
import org.glassfish.jersey.media.multipart.FormDataParam;
import org.glassfish.jersey.media.multipart.MultiPartFeature;
import org.glassfish.jersey.moxy.json.MoxyJsonConfig;
import org.glassfish.jersey.server.ContainerRequest;
import org.glassfish.jersey.server.ResourceConfig;

@Service
public abstract class AbstractRestServicePublishService
implements IWebPublishService {
    public static final String GENERATE = "generate";
    public static final String FORMATS = "formats";
    public static final String GENERATE_INFO = "generateinfo";
    public static final MediaType[] DEFAULT_FORMATS = new MediaType[]{MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_JSON_TYPE};
    public static final String JADEXSERVICE = "jadexservice";
    @ServiceComponent
    protected IInternalAccess component;
    protected IRestMethodGenerator generator;
    protected LRU<Tuple2<Class<?>, Class<?>>, Class<?>> proxyclasses;

    public AbstractRestServicePublishService() {
        this(new DefaultRestMethodGenerator());
    }

    public AbstractRestServicePublishService(IRestMethodGenerator generator) {
        this.generator = generator;
        this.proxyclasses = new LRU(50);
    }

    public IFuture<Boolean> isSupported(String publishtype) {
        return "rs".equals(publishtype) ? IFuture.TRUE : IFuture.FALSE;
    }

    protected Class<?> getProxyClass(IService service, ClassLoader classloader, Class<?> baseclass, Map<String, Object> mapprops) throws Exception {
        Class iface = service.getServiceIdentifier().getServiceType().getType(classloader);
        Class<?> ret = (Class<?>)this.proxyclasses.get((Object)new Tuple2((Object)iface, baseclass));
        if (ret == null) {
            List<RestMethodInfo> rmis = this.generator.generateRestMethodInfos(service, classloader, baseclass, mapprops);
            ret = this.createProxyClass(service, classloader, baseclass, mapprops, rmis);
            this.proxyclasses.put((Object)new Tuple2((Object)iface, baseclass), ret);
        }
        return ret;
    }

    public IFuture<Void> publishService(ClassLoader cl, IService service, final PublishInfo pi) {
        Future ret = new Future();
        System.out.println("start publish: " + pi.getPublishId());
        ret.addResultListener((IResultListener)new IResultListener<Void>(){

            public void resultAvailable(Void result) {
                System.out.println("end publish: " + pi.getPublishId());
            }

            public void exceptionOccurred(Exception exception) {
                exception.printStackTrace();
            }
        });
        try {
            ClassLoader ccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(cl);
            URI uri = new URI(pi.getPublishId());
            HashMap<String, Object> mapprops = new HashMap<String, Object>();
            if (pi.getProperties() != null) {
                for (int i = 0; i < pi.getProperties().size(); ++i) {
                    Object val = SJavaParser.getParsedValue(pi.getProperties().get(i), null, (IValueFetcher)(this.component != null ? this.component.getFetcher() : null), this.component != null ? this.component.getClassLoader() : null);
                    mapprops.put(((UnparsedExpression)pi.getProperties().get(i)).getName(), val);
                }
            }
            Class iface = service.getServiceIdentifier().getServiceType().getType(cl);
            Class baseclazz = pi.getMapping() != null ? pi.getMapping().getType(cl) : null;
            Class<?> rsimpl = this.getProxyClass(service, cl, baseclazz, mapprops);
            HashMap<String, Boolean> props = new HashMap<String, Boolean>();
            String pack = baseclazz != null && baseclazz.getPackage() != null ? baseclazz.getPackage().getName() : (iface.getPackage() != null ? iface.getPackage().getName() : null);
            props.put("com.sun.jersey.api.container.grizzly.AllowEncodedSlashFeature", Boolean.TRUE);
            props.put(JADEXSERVICE, (Boolean)service);
            final ResourceConfig rc = new ResourceConfig();
            rc.addProperties(props);
            rc.register(rsimpl);
            rc.register((Object)new AbstractBinder(){

                protected void configure() {
                    this.bind(ResourceConfig.class).in(Singleton.class);
                    this.bind(rc).to(ResourceConfig.class);
                }
            });
            MoxyJsonConfig mc = new MoxyJsonConfig();
            HashMap<String, String> m = new HashMap<String, String>(1);
            m.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            mc.setNamespacePrefixMapper(m).setNamespaceSeparator(':');
            rc.packages(new String[]{pack}).register((Object)mc.resolver());
            rc.register(MultiPartFeature.class);
            this.internalPublishService(uri, rc, service.getServiceIdentifier(), pi);
            String url = (String)mapprops.get("wp_url");
            if (url != null) {
                String name = (String)mapprops.get("wp_appname");
                String target = uri.toString();
                String user = (String)mapprops.get("wp_user");
                String pass = (String)mapprops.get("wp_pass");
                this.initWebProxyRefresh(url, name, target, user, pass, service.getServiceIdentifier());
            }
            Thread.currentThread().setContextClassLoader(ccl);
        }
        catch (Exception e) {
            e.printStackTrace();
            ret.setException(e);
        }
        return IFuture.DONE;
    }

    public abstract IFuture<Void> unpublishService(IServiceIdentifier var1);

    public abstract void internalPublishService(URI var1, ResourceConfig var2, IServiceIdentifier var3, PublishInfo var4);

    public abstract IFuture<Void> publishHMTLPage(URI var1, String var2, String var3);

    public abstract IFuture<Void> publishResources(URI var1, String var2);

    public abstract IFuture<Void> publishExternal(URI var1, String var2);

    protected Class<?> createProxyClass(IService service, ClassLoader classloader, Class<?> baseclass, Map<String, Object> mapprops, List<RestMethodInfo> geninfos) throws Exception {
        Class nameclazz;
        Class ret = null;
        Class iface = service.getServiceIdentifier().getServiceType().getType(classloader);
        StringBuilder builder = new StringBuilder();
        Class clazz = nameclazz = baseclass != null ? baseclass : iface;
        if (nameclazz.getPackage() != null) {
            builder.append(nameclazz.getPackage().getName());
        }
        builder.append(".Proxy");
        builder.append(nameclazz.getSimpleName());
        builder.append(geninfos.hashCode());
        String name = builder.toString();
        try {
            ret = classloader.loadClass(name);
        }
        catch (Exception e) {
            ClassPool pool = new ClassPool(null);
            pool.appendSystemPath();
            CtClass proxyclazz = pool.makeClass(name, baseclass == null || baseclass.isInterface() ? null : SJavassist.getCtClass((Class)baseclass, (ClassPool)pool));
            ClassFile cf = proxyclazz.getClassFile();
            ConstPool constpool = cf.getConstPool();
            CtField fjs = new CtField(SJavassist.getCtClass(String.class, (ClassPool)pool), "__functionsjs", proxyclazz);
            proxyclazz.addField(fjs);
            CtField scss = new CtField(SJavassist.getCtClass(String.class, (ClassPool)pool), "__stylecss", proxyclazz);
            proxyclazz.addField(scss);
            CtField rc = new CtField(SJavassist.getCtClass(ResourceConfig.class, (ClassPool)pool), "__rc", proxyclazz);
            AnnotationsAttribute attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            Annotation annot = new Annotation(constpool, SJavassist.getCtClass(Context.class, (ClassPool)pool));
            attr.addAnnotation(annot);
            rc.getFieldInfo().addAttribute((AttributeInfo)attr);
            proxyclazz.addField(rc);
            CtField ui = new CtField(SJavassist.getCtClass(UriInfo.class, (ClassPool)pool), "__ui", proxyclazz);
            attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            annot = new Annotation(constpool, SJavassist.getCtClass(Context.class, (ClassPool)pool));
            attr.addAnnotation(annot);
            ui.getFieldInfo().addAttribute((AttributeInfo)attr);
            proxyclazz.addField(ui);
            CtField req = new CtField(SJavassist.getCtClass(Request.class, (ClassPool)pool), "__greq", proxyclazz);
            attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            annot = new Annotation(constpool, SJavassist.getCtClass(Context.class, (ClassPool)pool));
            attr.addAnnotation(annot);
            req.getFieldInfo().addAttribute((AttributeInfo)attr);
            proxyclazz.addField(req);
            req = new CtField(SJavassist.getCtClass(ContainerRequest.class, (ClassPool)pool), "__creq", proxyclazz);
            attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            annot = new Annotation(constpool, SJavassist.getCtClass(Context.class, (ClassPool)pool));
            attr.addAnnotation(annot);
            req.getFieldInfo().addAttribute((AttributeInfo)attr);
            proxyclazz.addField(req);
            req = new CtField(SJavassist.getCtClass(HttpServletRequest.class, (ClassPool)pool), "__req", proxyclazz);
            attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            annot = new Annotation(constpool, SJavassist.getCtClass(Context.class, (ClassPool)pool));
            attr.addAnnotation(annot);
            req.getFieldInfo().addAttribute((AttributeInfo)attr);
            proxyclazz.addField(req);
            for (RestMethodInfo rmi : geninfos) {
                Annotation ans;
                int k;
                ConstPool cp;
                Value resultmapper;
                Value parametermapper;
                MethodInfo methodmapper;
                List<MediaType> produced;
                CtMethod invoke = SJavassist.getCtClass(rmi.getDelegateClazz(), (ClassPool)pool).getDeclaredMethod(rmi.getDelegateMethodName());
                Class rt = SReflect.unwrapGenericType((Type)rmi.getReturnType());
                if (rt == null && rmi.getReturnType() instanceof Class) {
                    rt = (Class)rmi.getReturnType();
                }
                CtClass rettype = SJavassist.getCtClass((Class)rt, (ClassPool)pool);
                CtClass[] paramtypes = SJavassist.getCtClasses((Class[])rmi.getParameterTypes(), (ClassPool)pool);
                CtClass[] exceptions = SJavassist.getCtClasses((Class[])rmi.getExceptionTypes(), (ClassPool)pool);
                CtMethod.ConstParameter cop = CtMethod.ConstParameter.string((String)rmi.getSignature());
                CtMethod m = CtNewMethod.wrapped((CtClass)rettype, (String)rmi.getName(), (CtClass[])paramtypes, (CtClass[])exceptions, (CtMethod)invoke, (CtMethod.ConstParameter)cop, (CtClass)proxyclazz);
                attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
                annot = new Annotation(constpool, SJavassist.getCtClass(rmi.getRestType(), (ClassPool)pool));
                attr.addAnnotation(annot);
                annot = new Annotation(constpool, SJavassist.getCtClass(Path.class, (ClassPool)pool));
                annot.addMemberValue("value", (MemberValue)new StringMemberValue(rmi.getPath(), constpool));
                attr.addAnnotation(annot);
                List<MediaType> consumed = rmi.getConsumed();
                if (!consumed.isEmpty()) {
                    ArrayList<StringMemberValue> cons = new ArrayList<StringMemberValue>();
                    for (MediaType mt : consumed) {
                        cons.add(new StringMemberValue(mt.toString(), constpool));
                    }
                    annot = new Annotation(constpool, SJavassist.getCtClass(Consumes.class, (ClassPool)pool));
                    ArrayMemberValue vals = new ArrayMemberValue((MemberValue)new StringMemberValue(constpool), constpool);
                    vals.setValue(cons.toArray(new MemberValue[0]));
                    annot.addMemberValue("value", (MemberValue)vals);
                    attr.addAnnotation(annot);
                }
                if (!(produced = rmi.getProduced()).isEmpty()) {
                    ArrayList<StringMemberValue> prods = new ArrayList<StringMemberValue>();
                    for (MediaType mt : produced) {
                        prods.add(new StringMemberValue(mt.toString(), constpool));
                    }
                    ArrayMemberValue vals = new ArrayMemberValue((MemberValue)new StringMemberValue(constpool), constpool);
                    vals.setValue(prods.toArray(new MemberValue[0]));
                    annot = new Annotation(constpool, SJavassist.getCtClass(Produces.class, (ClassPool)pool));
                    annot.addMemberValue("value", (MemberValue)vals);
                    attr.addAnnotation(annot);
                }
                if ((methodmapper = rmi.getMethodMapper()) != null) {
                    annot = new Annotation(constpool, SJavassist.getCtClass(MethodMapper.class, (ClassPool)pool));
                    annot.addMemberValue("value", (MemberValue)new StringMemberValue(methodmapper.getName(), constpool));
                    Class[] ptypes = methodmapper.getParameterTypes(classloader);
                    ArrayMemberValue vals = new ArrayMemberValue((MemberValue)new ClassMemberValue(constpool), constpool);
                    MemberValue[] mvals = new MemberValue[methodmapper.getParameterTypeInfos().length];
                    for (int i = 0; i < mvals.length; ++i) {
                        mvals[i] = new ClassMemberValue(ptypes[i].getName(), constpool);
                    }
                    vals.setValue(mvals);
                    annot.addMemberValue("parameters", (MemberValue)vals);
                    attr.addAnnotation(annot);
                }
                if ((parametermapper = rmi.getParameterMapper()) != null || rmi.isAutomapping()) {
                    annot = new Annotation(constpool, SJavassist.getCtClass(ParametersMapper.class, (ClassPool)pool));
                    Annotation value = new Annotation(constpool, SJavassist.getCtClass(jadex.bridge.service.annotation.Value.class, (ClassPool)pool));
                    if (parametermapper != null && parametermapper.getExpression() != null && parametermapper.getExpression().length() == 0) {
                        value.addMemberValue("value", (MemberValue)new StringMemberValue(parametermapper.getExpression(), constpool));
                    }
                    if (parametermapper != null && parametermapper.getClazz() != null && !parametermapper.getClazz().equals(Object.class)) {
                        value.addMemberValue("clazz", (MemberValue)new ClassMemberValue(parametermapper.getClazz().getName(), constpool));
                    }
                    annot.addMemberValue("value", (MemberValue)new AnnotationMemberValue(value, constpool));
                    annot.addMemberValue("automapping", (MemberValue)new BooleanMemberValue(rmi.isAutomapping(), constpool));
                    attr.addAnnotation(annot);
                }
                if ((resultmapper = rmi.getResultMapper()) != null) {
                    annot = new Annotation(constpool, SJavassist.getCtClass(ResultMapper.class, (ClassPool)pool));
                    Annotation value = new Annotation(constpool, SJavassist.getCtClass(jadex.bridge.service.annotation.Value.class, (ClassPool)pool));
                    if (resultmapper.getExpression() != null && resultmapper.getExpression().length() == 0) {
                        value.addMemberValue("value", (MemberValue)new StringMemberValue(resultmapper.getExpression(), constpool));
                    }
                    if (resultmapper.getClazz() != null && !resultmapper.getClazz().equals(Object.class)) {
                        value.addMemberValue("clazz", (MemberValue)new ClassMemberValue(resultmapper.getClazz().getName(), constpool));
                    }
                    annot.addMemberValue("value", (MemberValue)new AnnotationMemberValue(value, constpool));
                    attr.addAnnotation(annot);
                }
                m.getMethodInfo().addAttribute((AttributeInfo)attr);
                proxyclazz.addMethod(m);
                int pcnt = rmi.getParameterTypes().length;
                Annotation[][] annos = new Annotation[pcnt][];
                List<List<Tuple2<String, Map<String, Object>>>> aninfs = rmi.getAnnotationInfo();
                if (aninfs != null && !aninfs.isEmpty()) {
                    cp = m.getMethodInfo().getConstPool();
                    for (k = 0; k < annos.length; ++k) {
                        List<Tuple2<String, Map<String, Object>>> paninfs = aninfs.get(k);
                        Annotation[] ans2 = new Annotation[paninfs.size()];
                        annos[k] = ans2;
                        for (int l = 0; l < paninfs.size(); ++l) {
                            Tuple2<String, Map<String, Object>> tup = paninfs.get(l);
                            ans2[l] = new Annotation(cp, SJavassist.getCtClass((String)((String)tup.getFirstEntity()), (ClassPool)pool));
                            Map vals = (Map)tup.getSecondEntity();
                            for (Map.Entry entry : vals.entrySet()) {
                                StringMemberValue mv = null;
                                if (entry.getValue() instanceof String) {
                                    mv = new StringMemberValue((String)entry.getValue(), cp);
                                } else if (entry.getValue() instanceof Integer) {
                                    mv = new IntegerMemberValue(((Integer)entry.getValue()).intValue(), cp);
                                } else if (entry.getValue() instanceof Double) {
                                    mv = new DoubleMemberValue(((Double)entry.getValue()).doubleValue(), cp);
                                } else if (entry.getValue() instanceof Float) {
                                    mv = new FloatMemberValue(((Float)entry.getValue()).floatValue(), cp);
                                } else if (entry.getValue() instanceof Boolean) {
                                    mv = new BooleanMemberValue(((Boolean)entry.getValue()).booleanValue(), cp);
                                } else if (entry.getValue() instanceof Short) {
                                    mv = new ShortMemberValue(((Short)entry.getValue()).shortValue(), cp);
                                } else if (entry.getValue() instanceof Long) {
                                    mv = new LongMemberValue(((Long)entry.getValue()).longValue(), cp);
                                } else if (entry.getValue() instanceof Character) {
                                    mv = new CharMemberValue(((Character)entry.getValue()).charValue(), cp);
                                }
                                if (mv != null) {
                                    ans2[l].addMemberValue((String)entry.getKey(), (MemberValue)mv);
                                    continue;
                                }
                                System.out.println("Annotation member value currently not supported: " + entry.getValue());
                            }
                        }
                    }
                }
                if (GET.class.equals(rmi.getRestType())) {
                    if (pcnt > 0) {
                        cp = m.getMethodInfo().getConstPool();
                        for (k = 0; k < annos.length; ++k) {
                            ans = annos[k];
                            boolean hasq = false;
                            for (Annotation an : ans) {
                                if (!an.getTypeName().equals(QueryParam.class.getName())) continue;
                                hasq = true;
                                break;
                            }
                            if (hasq) continue;
                            Annotation anno = new Annotation(cp, SJavassist.getCtClass(QueryParam.class, (ClassPool)pool));
                            anno.addMemberValue("value", (MemberValue)new StringMemberValue("arg" + k, cp));
                            Annotation[] newans = new Annotation[((Annotation)ans).length + 1];
                            System.arraycopy(ans, 0, newans, 0, ((Annotation)ans).length);
                            newans[newans.length - 1] = anno;
                            annos[k] = newans;
                        }
                    }
                } else if (POST.class.equals(rmi.getRestType()) && pcnt > 0) {
                    cp = m.getMethodInfo().getConstPool();
                    for (k = 0; k < annos.length; ++k) {
                        ans = annos[k];
                        boolean hasq = false;
                        for (Annotation an : ans) {
                            if (!an.getTypeName().equals(FormDataParam.class.getName())) continue;
                            hasq = true;
                            break;
                        }
                        if (hasq) continue;
                        Annotation anno = new Annotation(cp, SJavassist.getCtClass(FormDataParam.class, (ClassPool)pool));
                        anno.addMemberValue("value", (MemberValue)new StringMemberValue("arg" + k, cp));
                        Annotation[] newans = new Annotation[((Annotation)ans).length + 1];
                        System.arraycopy(ans, 0, newans, 0, ((Annotation)ans).length);
                        newans[newans.length - 1] = anno;
                        annos[k] = newans;
                    }
                }
                SJavassist.addMethodParameterAnnotation((CtMethod)m, (Annotation[][])annos, (ClassPool)pool);
            }
            attr = new AnnotationsAttribute(constpool, "RuntimeVisibleAnnotations");
            annot = new Annotation(constpool, SJavassist.getCtClass(Path.class, (ClassPool)pool));
            annot.addMemberValue("value", (MemberValue)new StringMemberValue("", constpool));
            attr.addAnnotation(annot);
            cf.addAttribute((AttributeInfo)attr);
            ret = proxyclazz.toClass(classloader, iface.getProtectionDomain());
            proxyclazz.freeze();
        }
        return ret;
    }

    public Void initWebProxyRefresh(final String url, final String name, final String target, final String user, final String pass, final IServiceIdentifier sid) {
        if (url != null && name != null && target != null) {
            System.out.println("Init web proxy refresh: " + url + " " + name + " " + target);
            final ScheduledExecutorService ses = Executors.newScheduledThreadPool(1);
            Runnable run = new Runnable(){
                protected String cookie = null;

                @Override
                public void run() {
                    if (AbstractRestServicePublishService.this.isPublished(sid)) {
                        if (this.cookie == null) {
                            this.cookie = AbstractRestServicePublishService.this.login(url, user, pass);
                        }
                        if (this.cookie != null) {
                            Integer lt = AbstractRestServicePublishService.this.addMapping(url, name, target, this.cookie);
                            if (lt == null) {
                                System.out.println("Web proxy problems");
                                ses.schedule(this, 2L, TimeUnit.MINUTES);
                            } else {
                                this.cookie = null;
                                long dur = (long)((double)(lt * 1000 * 60) * 0.9);
                                ses.schedule(this, dur, TimeUnit.MILLISECONDS);
                            }
                        }
                    } else {
                        System.out.println("Webproxy refresh ends.");
                    }
                }
            };
            run.run();
        }
        return null;
    }

    protected String login(String url, String user, String pass) {
        String ret = null;
        HttpURLConnection con = null;
        try {
            if (url.indexOf("https") != -1) {
                URL urlc = new URL(url + "/login?name=" + user + "&pass=" + pass);
                con = (HttpURLConnection)urlc.openConnection();
                con.setRequestMethod("GET");
                con.setRequestProperty("Accept", "application/json");
                con.connect();
                if (200 == con.getResponseCode()) {
                    ret = con.getHeaderField("Set-Cookie");
                }
            } else {
                URL urlc = new URL(url + "/login");
                con = (HttpURLConnection)urlc.openConnection();
                con.connect();
                String auth = con.getHeaderField("WWW-Authenticate");
                if (auth.startsWith("Digest ")) {
                    Map<String, String> vals = this.parseHeader(auth, ",");
                    String realm = vals.get("realm");
                    String nonce = vals.get("nonce");
                    String ha1 = AbstractRestServicePublishService.hex(AbstractRestServicePublishService.digest(user + ":" + realm + ":" + pass));
                    String ha2 = AbstractRestServicePublishService.hex(AbstractRestServicePublishService.digest(con.getRequestMethod() + ":" + con.getURL().getPath()));
                    String ha3 = AbstractRestServicePublishService.hex(AbstractRestServicePublishService.digest(ha1 + ":" + nonce + ":" + ha2));
                    StringBuilder sb = new StringBuilder();
                    sb.append("Digest ");
                    sb.append("username").append("=\"").append(user).append("\",");
                    sb.append("realm").append("=\"").append(realm).append("\",");
                    sb.append("nonce").append("=\"").append(nonce).append("\",");
                    sb.append("uri").append("=\"").append(con.getURL().getPath()).append("\",");
                    sb.append("response").append("=\"").append(ha3).append("\"");
                    HttpURLConnection con2 = (HttpURLConnection)con.getURL().openConnection();
                    con2.addRequestProperty("Authorization", sb.toString());
                    con2.setRequestProperty("Accept", "application/json");
                    if (200 == con2.getResponseCode()) {
                        ret = con2.getHeaderField("Set-Cookie");
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    protected Integer addMapping(String url, String name, String target, String cookie) {
        Integer ret = null;
        HttpURLConnection con = null;
        try {
            URL urlc = new URL(url + "/addMapping?name=" + name + "&target=" + target);
            con = (HttpURLConnection)urlc.openConnection();
            con.setRequestProperty("Accept", "application/json");
            con.setRequestProperty("Cookie", cookie);
            con.connect();
            if (200 == con.getResponseCode()) {
                ret = 30;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public Object invoke(Object[] params, String sig) {
        return SInvokeHelper.invoke(params, sig, this);
    }

    public Object getServiceInfo(Object[] params, String sig) {
        StringBuffer ret = new StringBuffer();
        try {
            Field scss;
            String stylecss;
            ResourceConfig rc = (ResourceConfig)this.getClass().getDeclaredField("__rc").get(this);
            Object service = rc.getProperty(JADEXSERVICE);
            Field fjs = this.getClass().getDeclaredField("__functionsjs");
            String functionsjs = (String)fjs.get(this);
            if (functionsjs == null) {
                Scanner sc = null;
                try {
                    InputStream is = SUtil.getResource0((String)"jadex/extension/rs/publish/functions.js", (ClassLoader)Thread.currentThread().getContextClassLoader());
                    sc = new Scanner(is);
                    functionsjs = sc.useDelimiter("\\A").next();
                    fjs.set(this, functionsjs);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                finally {
                    if (sc != null) {
                        sc.close();
                    }
                }
            }
            if ((stylecss = (String)(scss = this.getClass().getDeclaredField("__stylecss")).get(this)) == null) {
                Scanner sc = null;
                try {
                    InputStream is = SUtil.getResource0((String)"jadex/extension/rs/publish/style.css", (ClassLoader)Thread.currentThread().getContextClassLoader());
                    sc = new Scanner(is);
                    stylecss = sc.useDelimiter("\\A").next();
                    String stripes = SUtil.loadBinary((String)"jadex/extension/rs/publish/jadex_stripes.png");
                    stylecss = stylecss.replace("$stripes", stripes);
                    scss.set(this, stylecss);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new RuntimeException(e);
                }
                finally {
                    if (sc != null) {
                        sc.close();
                    }
                }
            }
            ret.append("<html>");
            ret.append("\n");
            ret.append("<head>");
            ret.append("\n");
            ret.append(stylecss);
            ret.append("\n");
            ret.append(functionsjs);
            ret.append("\n");
            ret.append("</head>");
            ret.append("\n");
            ret.append("<body>");
            ret.append("\n");
            ret.append("<div class=\"header\">");
            ret.append("\n");
            ret.append("<h1>");
            String ifacename = ((IService)service).getServiceIdentifier().getServiceType().getTypeName();
            ret.append(SReflect.getUnqualifiedTypeName((String)ifacename));
            ret.append("</h1>");
            ret.append("\n");
            ret.append("</div>");
            ret.append("\n");
            ret.append("<div class=\"middle\">");
            ret.append("\n");
            UriInfo ui = (UriInfo)this.getClass().getDeclaredField("__ui").get(this);
            Class<?> clazz = this.getClass();
            ArrayList methods = new ArrayList();
            while (!clazz.equals(Object.class)) {
                List l = SUtil.arrayToList((Object)clazz.getDeclaredMethods());
                methods.addAll(l);
                clazz = clazz.getSuperclass();
            }
            Collections.sort(methods, new MethodComparator());
            if (methods != null) {
                for (int i = 0; i < methods.size(); ++i) {
                    String[] prods;
                    int j;
                    String[] cons;
                    Method method = (Method)methods.get(i);
                    Class restmethod = RSJAXAnnotationHelper.getDeclaredRestType((Method)method);
                    if (restmethod == null) continue;
                    Path path = method.getAnnotation(Path.class);
                    Consumes consumes = method.getAnnotation(Consumes.class);
                    Produces produces = method.getAnnotation(Produces.class);
                    Class<?>[] ptypes = method.getParameterTypes();
                    ret.append("<div class=\"method\">");
                    ret.append("\n");
                    ret.append("<div class=\"methodname\">");
                    ret.append(method.getName());
                    ret.append("(");
                    if (ptypes != null && ptypes.length > 0) {
                        for (int j2 = 0; j2 < ptypes.length; ++j2) {
                            ret.append(SReflect.getUnqualifiedClassName(ptypes[j2]));
                            if (j2 + 1 >= ptypes.length) continue;
                            ret.append(", ");
                        }
                    }
                    ret.append(")");
                    ret.append("</div>");
                    ret.append("\n");
                    ret.append("<div class=\"restproperties\">");
                    String resttype = SReflect.getUnqualifiedClassName((Class)restmethod);
                    ret.append(resttype).append(" ");
                    if (consumes != null && (cons = consumes.value()).length > 0) {
                        ret.append("<i>");
                        ret.append("Consumes: ");
                        ret.append("</i>");
                        for (j = 0; j < cons.length; ++j) {
                            ret.append(cons[j]);
                            if (j + 1 >= cons.length) continue;
                            ret.append(" ,");
                        }
                        ret.append(" ");
                    }
                    if (produces != null && (prods = produces.value()).length > 0) {
                        ret.append("<i>");
                        ret.append("Produces: ");
                        ret.append("</i>");
                        for (j = 0; j < prods.length; ++j) {
                            ret.append(prods[j]);
                            if (j + 1 >= prods.length) continue;
                            ret.append(" ,");
                        }
                        ret.append(" ");
                    }
                    ret.append("</div>");
                    ret.append("\n");
                    UriBuilder ub = ui.getBaseUriBuilder();
                    if (path != null) {
                        ub.path(path.value());
                    }
                    String link = ub.build(new Object[]{Collections.EMPTY_MAP}).toString();
                    if (ptypes.length > 0) {
                        ret.append("<div class=\"servicelink\">");
                        ret.append(link);
                        ret.append("</div>");
                        ret.append("\n");
                        ret.append("<form class=\"arguments\" action=\"").append(link).append("\" method=\"").append(resttype.toLowerCase()).append("\" enctype=\"multipart/form-data\" ");
                        if (restmethod.equals(POST.class)) {
                            ret.append("onSubmit=\"return extract(this)\"");
                        }
                        ret.append(">");
                        ret.append("\n");
                        for (int j3 = 0; j3 < ptypes.length; ++j3) {
                            ret.append("arg").append(j3).append(": ");
                            ret.append("<input name=\"arg").append(j3).append("\" type=\"text\" />");
                        }
                        ret.append("<select name=\"mediatype\">");
                        if (consumes != null) {
                            String[] cons2 = consumes.value();
                            if (cons2 != null && cons2.length > 0) {
                                for (int j4 = 0; j4 < cons2.length; ++j4) {
                                    if ("multipart/form-data".equals(cons2[j4]) || "application/x-www-form-urlencoded".equals(cons2[j4])) continue;
                                    ret.append("<option>").append(cons2[j4]).append("</option>");
                                }
                            }
                        } else {
                            ret.append("<option>").append("text/plain").append("</option>");
                        }
                        ret.append("</select>");
                        ret.append("\n");
                        ret.append("<input type=\"submit\" value=\"invoke\"/>");
                        ret.append("</form>");
                        ret.append("\n");
                    } else {
                        ret.append("<div class=\"servicelink\">");
                        ret.append("<a href=\"").append(link).append("\">").append(link).append("</a>");
                        ret.append("</div>");
                        ret.append("\n");
                    }
                    ret.append("</div>");
                    ret.append("\n");
                }
            }
            ret.append("</div>");
            ret.append("\n");
            ret.append("<div class=\"powered\"> <span class=\"powered\">powered by</span> <span class=\"jadex\">Jadex Active Components</span> <a class=\"jadexurl\" href=\"http://www.activecomponents.org\">http://www.activecomponents.org</a> </div>\n");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        ret.append("</body>\n</html>\n");
        return ret.toString();
    }

    public abstract boolean isPublished(IServiceIdentifier var1);

    public static String hex(byte[] data) {
        return SUtil.hex((byte[])data, (boolean)false);
    }

    public static byte[] digest(String input) {
        return AbstractRestServicePublishService.digest(input.getBytes());
    }

    public static byte[] digest(byte[] input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] output = md.digest(input);
            return output;
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    protected Map<String, String> parseHeader(String header, String delims) {
        HashMap<String, String> values = new HashMap<String, String>();
        StringTokenizer stok = new StringTokenizer(header, delims);
        while (stok.hasMoreTokens()) {
            String keyval = stok.nextToken();
            if (!keyval.contains("=")) continue;
            String key = keyval.substring(0, keyval.indexOf("="));
            String value = keyval.substring(keyval.indexOf("=") + 1);
            values.put(key.trim(), value.replaceAll("\"", "").trim());
        }
        return values;
    }
}

