/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.commons.MethodInfo;
import jadex.commons.Tuple2;
import jadex.extension.rs.publish.Value;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.MediaType;

public class RestMethodInfo {
    protected Method method;
    protected String signature;
    protected Class<?>[] parametertypes;
    protected Type returntype;
    protected Class<?>[] exceptiontypes;
    protected String name;
    protected String path;
    protected Class<?> resttype;
    protected List<MediaType> consumed;
    protected List<MediaType> produced;
    protected MethodInfo methodmapper;
    protected Value parametermapper;
    protected boolean automapping;
    protected Value resultmapper;
    protected Class<?> dclazz;
    protected String dmname;
    protected List<List<Tuple2<String, Map<String, Object>>>> parameterannos;

    public RestMethodInfo(Method method, String name, String path, Class<?> resttype, List<MediaType> consumed, List<MediaType> produced, MethodInfo methodmapper, Value parametermapper, boolean automapping, Value resultmapper, Class<?> dclazz, String dmname) {
        if (method == null) {
            throw new IllegalArgumentException("Method must not null.");
        }
        this.method = method;
        this.name = name;
        this.path = path;
        this.resttype = resttype;
        this.consumed = consumed;
        this.produced = produced;
        this.methodmapper = methodmapper;
        this.parametermapper = parametermapper;
        this.automapping = automapping;
        this.resultmapper = resultmapper;
        this.dclazz = dclazz;
        this.dmname = dmname;
        this.getAnnotationInfo();
    }

    public RestMethodInfo(Class<?>[] parametertypes, Type returntype, Class<?>[] exceptiontypes, String name, String path, Class<?> resttype, List<MediaType> consumed, List<MediaType> produced, MethodInfo methodmapper, Value parametermapper, boolean automapping, Value resultmapper, Class<?> dclazz, String dmname) {
        this.name = name;
        this.parametertypes = parametertypes;
        this.returntype = returntype;
        this.exceptiontypes = exceptiontypes;
        this.path = path;
        this.resttype = resttype;
        this.consumed = consumed;
        this.produced = produced;
        this.methodmapper = methodmapper;
        this.parametermapper = parametermapper;
        this.automapping = automapping;
        this.resultmapper = resultmapper;
        this.dclazz = dclazz;
        this.dmname = dmname;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Class<?>[] getParameterTypes() {
        return this.parametertypes != null ? this.parametertypes : (this.method != null ? this.method.getParameterTypes() : null);
    }

    public void setParameterTypes(Class<?>[] parametertypes) {
        this.parametertypes = parametertypes;
    }

    public Type getReturnType() {
        return this.returntype != null ? this.returntype : (this.method != null ? this.method.getGenericReturnType() : null);
    }

    public void setReturnType(Type returntype) {
        this.returntype = returntype;
    }

    public Class<?>[] getExceptionTypes() {
        return this.exceptiontypes != null ? this.exceptiontypes : (this.method != null ? this.method.getExceptionTypes() : null);
    }

    public void setExceptionTypes(Class<?>[] exceptiontypes) {
        this.exceptiontypes = exceptiontypes;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Class<?> getRestType() {
        return this.resttype;
    }

    public void setRestType(Class<?> resttype) {
        this.resttype = resttype;
    }

    public List<MediaType> getConsumed() {
        return this.consumed;
    }

    public void setConsumed(List<MediaType> consumed) {
        this.consumed = consumed;
    }

    public List<MediaType> getProduced() {
        return this.produced;
    }

    public void setProduced(List<MediaType> produced) {
        this.produced = produced;
    }

    public MethodInfo getMethodMapper() {
        return this.methodmapper;
    }

    public void setMethodMapper(MethodInfo methodmapper) {
        this.methodmapper = methodmapper;
    }

    public Value getParameterMapper() {
        return this.parametermapper;
    }

    public void setParameterMapper(Value parametermapper) {
        this.parametermapper = parametermapper;
    }

    public Value getResultMapper() {
        return this.resultmapper;
    }

    public void setResultMapper(Value resultmapper) {
        this.resultmapper = resultmapper;
    }

    public Class<?> getDelegateClazz() {
        return this.dclazz;
    }

    public void setDelegateClazz(Class<?> dclazz) {
        this.dclazz = dclazz;
    }

    public String getDelegateMethodName() {
        return this.dmname;
    }

    public void setDelegateMethodName(String dmname) {
        this.dmname = dmname;
    }

    public String getSignature() {
        if (this.signature == null) {
            this.signature = RestMethodInfo.buildSignature(this.getName(), this.getParameterTypes());
        }
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public boolean isAutomapping() {
        return this.automapping;
    }

    public void setAutomapping(boolean automapping) {
        this.automapping = automapping;
    }

    public static String buildSignature(String name, Class<?>[] paramtypes) {
        StringBuilder buf = new StringBuilder();
        buf.append(name).append(" ");
        if (paramtypes != null) {
            for (Class<?> pt : paramtypes) {
                buf.append(pt.getName()).append(" ");
            }
        }
        return buf.toString();
    }

    public List<List<Tuple2<String, Map<String, Object>>>> getAnnotationInfo() {
        if (this.method != null && this.parameterannos == null) {
            Annotation[][] annos;
            this.parameterannos = new ArrayList<List<Tuple2<String, Map<String, Object>>>>();
            for (Annotation[] ans : annos = this.method.getParameterAnnotations()) {
                ArrayList<Tuple2> list = new ArrayList<Tuple2>();
                for (Annotation an : ans) {
                    Method[] ms;
                    HashMap<String, Object> vals = new HashMap<String, Object>();
                    Class<? extends Annotation> anc = an.annotationType();
                    for (Method m : ms = anc.getDeclaredMethods()) {
                        try {
                            Object val = m.invoke((Object)an, null);
                            vals.put(m.getName(), val);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    Tuple2 tup = new Tuple2((Object)anc.getName(), vals);
                    list.add(tup);
                }
                this.parameterannos.add(list);
            }
        }
        return this.parameterannos;
    }

    public String toString() {
        return "RestMethodInfo(name=" + this.name + ", resttype=" + this.resttype + ", consumed=" + this.consumed + ", produced=" + this.produced + ")";
    }
}

