/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.bridge.modelinfo.UnparsedExpression;
import jadex.bridge.service.IService;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.PublishInfo;
import jadex.bridge.service.annotation.Service;
import jadex.commons.IValueFetcher;
import jadex.commons.SUtil;
import jadex.commons.collection.MultiCollection;
import jadex.commons.future.IFuture;
import jadex.extension.rs.publish.AbstractRestPublishService;
import jadex.javaparser.SJavaParser;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.MultipartConfigElement;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.glassfish.grizzly.http.server.ErrorPageGenerator;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.NetworkListener;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.ServerConfiguration;
import org.glassfish.grizzly.http.server.util.MappingData;
import org.glassfish.grizzly.servlet.HttpServletRequestImpl;
import org.glassfish.grizzly.servlet.HttpServletResponseImpl;
import org.glassfish.grizzly.servlet.WebappContext;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;

@Service
public class GrizzlyRestPublishService
extends AbstractRestPublishService {
    private static final MultipartConfigElement MULTI_PART_CONFIG = new MultipartConfigElement(System.getProperty("java.io.tmpdir"));
    protected Map<IServiceIdentifier, HttpServer> sidservers;
    protected Map<Integer, HttpServer> portservers;

    public IFuture<Boolean> isSupported(String publishtype) {
        return "rs".equals(publishtype) ? IFuture.TRUE : IFuture.FALSE;
    }

    public IFuture<Void> publishService(ClassLoader cl, final IService service, PublishInfo info) {
        try {
            final URI uri = new URI(info.getPublishId());
            HttpServer server = (HttpServer)this.getHttpServer(uri, info);
            System.out.println("Adding http handler to server: " + uri.getPath());
            final MultiCollection mappings = this.evaluateMapping(service.getServiceIdentifier(), info);
            HttpHandler handler = new HttpHandler(){

                public void service(Request request, Response response) throws Exception {
                    Method m;
                    HttpServletResponseImpl res = HttpServletResponseImpl.create();
                    HttpServletRequestImpl req = HttpServletRequestImpl.create();
                    req.initialize(request, res, new WebappContext(uri.getPath(), uri.getPath()));
                    res.initialize(response, req);
                    MappingData data = request.obtainMappingData();
                    String pi = request.getPathInfo();
                    if (pi == null) {
                        String ctx = request.getContextPath();
                        String full = request.getRequestURL().toString();
                        if (ctx != null && full != null) {
                            int start = full.indexOf(ctx) + ctx.length();
                            int end = full.indexOf("?");
                            if (start > 0 && full.length() > start) {
                                pi = full.substring(start, end > 0 ? end : full.length());
                            }
                        }
                        if ("/".equals(pi)) {
                            pi = null;
                        }
                    }
                    if (pi != null) {
                        req.setServletPath(data.wrapperPath.toString());
                        m = req.getClass().getDeclaredMethod("setPathInfo", String.class);
                        m.setAccessible(true);
                        m.invoke((Object)req, pi);
                    }
                    m = req.getClass().getDeclaredMethod("setContextPath", String.class);
                    m.setAccessible(true);
                    m.invoke((Object)req, data.contextPath.toString());
                    GrizzlyRestPublishService.this.handleRequest(service, mappings, (HttpServletRequest)req, (HttpServletResponse)res, null);
                }
            };
            ServerConfiguration sc = server.getServerConfiguration();
            sc.addHttpHandler(handler, new String[]{uri.getPath()});
            if (this.sidservers == null) {
                this.sidservers = new HashMap<IServiceIdentifier, HttpServer>();
            }
            this.sidservers.put(service.getServiceIdentifier(), server);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return IFuture.DONE;
    }

    public Object getHttpServer(URI uri, PublishInfo info) {
        HttpServer server = null;
        try {
            HttpServer httpServer = server = this.portservers == null ? null : this.portservers.get(uri.getPort());
            if (server == null) {
                System.out.println("Starting new server: " + uri.getPort());
                ErrorPageGenerator epg = null;
                String keystore = null;
                String keystorepass = null;
                if (info != null) {
                    for (UnparsedExpression upex : info.getProperties()) {
                        String errpage;
                        if ("sslkeystore".equals(upex.getName())) {
                            keystore = (String)SJavaParser.getParsedValue((Object)upex, null, (IValueFetcher)(this.component != null ? this.component.getFetcher() : null), this.component != null ? this.component.getClassLoader() : null);
                            continue;
                        }
                        if ("sslkeystorepass".equals(upex.getName())) {
                            keystorepass = (String)SJavaParser.getParsedValue((Object)upex, null, (IValueFetcher)(this.component != null ? this.component.getFetcher() : null), this.component != null ? this.component.getClassLoader() : null);
                            continue;
                        }
                        if (!"errorpage".equals(upex.getName()) || (errpage = (String)SJavaParser.getParsedValue((Object)upex, null, (IValueFetcher)(this.component != null ? this.component.getFetcher() : null), this.component != null ? this.component.getClassLoader() : null)) == null) continue;
                        final String errp = SUtil.readFile((String)errpage);
                        epg = new ErrorPageGenerator(){

                            public String generate(Request request, int status, String reasonPhrase, String description, Throwable exception) {
                                return errp;
                            }
                        };
                    }
                }
                if (keystore != null) {
                    SSLContextConfigurator sslContext = new SSLContextConfigurator();
                    sslContext.setKeyStoreFile(keystore);
                    sslContext.setKeyStorePass(keystorepass);
                    SSLEngineConfigurator sslConf = new SSLEngineConfigurator(sslContext).setClientMode(false);
                    server = new HttpServer();
                } else {
                    server = new HttpServer();
                }
                NetworkListener listener = new NetworkListener("lis", uri.getHost() != null ? uri.getHost() : "0.0.0.0", uri.getPort() != -1 ? uri.getPort() : 80);
                server.addListener(listener);
                if (epg != null) {
                    server.getServerConfiguration().setDefaultErrorPageGenerator(epg);
                }
                ServerConfiguration sc = server.getServerConfiguration();
                server.start();
                if (this.portservers == null) {
                    this.portservers = new HashMap<Integer, HttpServer>();
                }
                this.portservers.put(uri.getPort(), server);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return server;
    }

    public IFuture<Void> unpublishService(IServiceIdentifier sid) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> publishHMTLPage(URI uri, String vhost, String html) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> publishResources(URI uri, String rootpath) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> publishExternal(URI uri, String rootpath) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> publishRedirect(URI uri, String html) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> unpublish(String vhost, URI uri) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> mirrorHttpServer(URI sourceserveruri, URI targetserveruri, PublishInfo info) {
        throw new UnsupportedOperationException();
    }

    public IFuture<Void> shutdownHttpServer(URI uri) {
        throw new UnsupportedOperationException();
    }
}

