/*
 * Decompiled with CFR 0.152.
 */
package jadex.extension.rs.publish;

import jadex.bridge.IComponentIdentifier;
import jadex.bridge.IInternalAccess;
import jadex.bridge.ServiceCall;
import jadex.bridge.modelinfo.UnparsedExpression;
import jadex.bridge.service.IServiceIdentifier;
import jadex.bridge.service.PublishInfo;
import jadex.bridge.service.annotation.Service;
import jadex.bridge.service.search.SServiceProvider;
import jadex.bridge.service.types.cms.IComponentDescription;
import jadex.bridge.service.types.cms.IComponentManagementService;
import jadex.bridge.service.types.library.ILibraryService;
import jadex.commons.IValueFetcher;
import jadex.commons.Tuple2;
import jadex.commons.future.ExceptionDelegationResultListener;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.future.IResultListener;
import jadex.extension.rs.publish.AbstractRestServicePublishService;
import jadex.extension.rs.publish.IRestMethodGenerator;
import jadex.javaparser.SJavaParser;
import java.io.Writer;
import java.lang.reflect.Method;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.ws.rs.core.Application;
import org.glassfish.grizzly.http.server.CLStaticHttpHandler;
import org.glassfish.grizzly.http.server.ErrorPageGenerator;
import org.glassfish.grizzly.http.server.HttpHandler;
import org.glassfish.grizzly.http.server.HttpServer;
import org.glassfish.grizzly.http.server.Request;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.server.StaticHttpHandler;
import org.glassfish.grizzly.http.util.Header;
import org.glassfish.grizzly.http.util.HttpStatus;
import org.glassfish.grizzly.ssl.SSLContextConfigurator;
import org.glassfish.grizzly.ssl.SSLEngineConfigurator;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpContainer;
import org.glassfish.jersey.grizzly2.httpserver.GrizzlyHttpServerFactory;
import org.glassfish.jersey.server.ContainerFactory;
import org.glassfish.jersey.server.ResourceConfig;

@Service
public class GrizzlyRestServicePublishService
extends AbstractRestServicePublishService {
    protected Map<IServiceIdentifier, Tuple2<HttpServer, URI>> sidservers;
    protected Map<Integer, Tuple2<MainHttpHandler, HttpServer>> portservers;

    public GrizzlyRestServicePublishService() {
    }

    public GrizzlyRestServicePublishService(IRestMethodGenerator generator) {
        super(generator);
    }

    @Override
    public void internalPublishService(URI uri, ResourceConfig rc, IServiceIdentifier sid, PublishInfo info) {
        try {
            Tuple2<MainHttpHandler, HttpServer> servertuple = this.getHttpServer(uri, info);
            System.out.println("Adding http handler to server: " + uri.getPath());
            HttpHandler handler = (HttpHandler)ContainerFactory.createContainer(HttpHandler.class, (Application)rc);
            ((MainHttpHandler)((Object)servertuple.getFirstEntity())).addSubhandler(null, uri.getPath(), handler);
            if (this.sidservers == null) {
                this.sidservers = new HashMap<IServiceIdentifier, Tuple2<HttpServer, URI>>();
            }
            this.sidservers.put(sid, (Tuple2<HttpServer, URI>)new Tuple2(servertuple.getSecondEntity(), (Object)uri));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Tuple2<MainHttpHandler, HttpServer> getHttpServer(URI uri, PublishInfo info) {
        Tuple2 servertuple = null;
        try {
            Tuple2 tuple2 = servertuple = this.portservers == null ? null : this.portservers.get(uri.getPort());
            if (servertuple == null) {
                HttpServer server = this.startServer(uri, info, null);
                MainHttpHandler mainhandler = new MainHttpHandler();
                server.getServerConfiguration().addHttpHandler((HttpHandler)mainhandler);
                servertuple = new Tuple2((Object)mainhandler, (Object)server);
                this.portservers.put(uri.getPort(), (Tuple2<MainHttpHandler, HttpServer>)servertuple);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return servertuple;
    }

    public IFuture<Void> mirrorHttpServer(URI sourceserveruri, URI targetserveruri, PublishInfo info) {
        Tuple2<MainHttpHandler, HttpServer> sourceservertuple;
        Future ret = new Future();
        Tuple2<MainHttpHandler, HttpServer> tuple2 = sourceservertuple = this.portservers == null ? null : this.portservers.get(sourceserveruri.getPort());
        if (sourceservertuple != null) {
            try {
                String errorfallback = null;
                if (((HttpServer)sourceservertuple.getSecondEntity()).getServerConfiguration().getDefaultErrorPageGenerator() instanceof RedirectErrorPageGenerator) {
                    errorfallback = ((RedirectErrorPageGenerator)((HttpServer)sourceservertuple.getSecondEntity()).getServerConfiguration().getDefaultErrorPageGenerator()).getRedirectUrl();
                }
                HttpServer newserver = this.startServer(targetserveruri, info, errorfallback);
                newserver.getServerConfiguration().addHttpHandler((HttpHandler)sourceservertuple.getFirstEntity());
                Tuple2 newservertuple = new Tuple2(sourceservertuple.getFirstEntity(), (Object)newserver);
                if (!(newserver.getServerConfiguration().getDefaultErrorPageGenerator() instanceof RedirectErrorPageGenerator)) {
                    ErrorPageGenerator epg = ((HttpServer)sourceservertuple.getSecondEntity()).getServerConfiguration().getDefaultErrorPageGenerator();
                    System.out.println(epg);
                    if (epg != null) {
                        newserver.getServerConfiguration().setDefaultErrorPageGenerator(epg);
                    }
                }
                this.portservers.put(targetserveruri.getPort(), (Tuple2<MainHttpHandler, HttpServer>)newservertuple);
            }
            catch (Exception e) {
                ret.setException(e);
            }
        } else {
            ret.setException((Exception)new RuntimeException("Server mirror source not found: " + sourceserveruri.toString()));
        }
        return ret;
    }

    public IFuture<Void> shutdownHttpServer(URI uri) {
        Tuple2<MainHttpHandler, HttpServer> servertuple = this.getHttpServer(uri, null);
        Iterator<Tuple2<MainHttpHandler, HttpServer>> servers = this.portservers.values().iterator();
        while (servers.hasNext()) {
            if (!((HttpServer)servers.next().getSecondEntity()).equals(servertuple.getSecondEntity())) continue;
            servers.remove();
            break;
        }
        System.out.println("Terminating server: " + uri.getPort());
        ((HttpServer)servertuple.getSecondEntity()).shutdownNow();
        return IFuture.DONE;
    }

    public IFuture<Void> publishRedirect(URI uri, final String html) {
        Tuple2<MainHttpHandler, HttpServer> servertuple = this.getHttpServer(uri, null);
        if (((MainHttpHandler)((Object)servertuple.getFirstEntity())).containsSubhandlerForExactUri(null, uri.getPath())) {
            return new Future((Exception)new IllegalArgumentException("Cannot redirect, URI already bound: " + uri.toString()));
        }
        HttpHandler redh = new HttpHandler(){

            public void service(Request request, Response response) {
                response.setStatus(HttpStatus.MOVED_PERMANENTLY_301);
                response.setHeader(Header.Location, html);
            }
        };
        ((MainHttpHandler)((Object)servertuple.getFirstEntity())).addSubhandler(null, uri.getPath(), redh);
        return IFuture.DONE;
    }

    @Override
    public IFuture<Void> publishHMTLPage(URI uri, String vhost, String html) {
        Tuple2<MainHttpHandler, HttpServer> servertuple = this.getHttpServer(uri, null);
        if (((MainHttpHandler)((Object)servertuple.getFirstEntity())).containsSubhandlerForExactUri(vhost, uri.getPath())) {
            return new Future((Exception)new IllegalArgumentException("Cannot publish HTML, URI already bound: " + uri.toString()));
        }
        HtmlHandler htmlh = new HtmlHandler(){

            @Override
            public void service(Request request, Response response) {
                response.addHeader("Access-Control-Allow-Origin", "*");
                response.addHeader("Access-Control-Allow-Credentials", "true ");
                response.addHeader("Access-Control-Allow-Methods", "OPTIONS, GET, POST");
                response.addHeader("Access-Control-Allow-Headers", "Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
                super.service(request, response);
            }
        };
        htmlh.addMapping(vhost, html);
        ((MainHttpHandler)((Object)servertuple.getFirstEntity())).addSubhandler(vhost, uri.getPath(), htmlh);
        return IFuture.DONE;
    }

    @Override
    public IFuture<Void> publishResources(final URI uri, final String path) {
        final Future ret = new Future();
        IComponentManagementService cms = (IComponentManagementService)SServiceProvider.getLocalService((IInternalAccess)this.component, IComponentManagementService.class, (String)"platform");
        IComponentIdentifier cid = ServiceCall.getLastInvocation() != null && ServiceCall.getLastInvocation().getCaller() != null ? ServiceCall.getLastInvocation().getCaller() : this.component.getComponentIdentifier();
        cms.getComponentDescription(cid).addResultListener((IResultListener)new ExceptionDelegationResultListener<IComponentDescription, Void>(ret){

            public void customResultAvailable(IComponentDescription desc) {
                ILibraryService ls = (ILibraryService)SServiceProvider.getLocalService((IInternalAccess)GrizzlyRestServicePublishService.this.component, ILibraryService.class, (String)"platform");
                ls.getClassLoader(desc.getResourceIdentifier()).addResultListener((IResultListener)new ExceptionDelegationResultListener<ClassLoader, Void>(ret){

                    public void customResultAvailable(ClassLoader cl) {
                        Tuple2<MainHttpHandler, HttpServer> servertuple = GrizzlyRestServicePublishService.this.getHttpServer(uri, null);
                        ((MainHttpHandler)((Object)servertuple.getFirstEntity())).addSubhandler(null, uri.getPath(), (HttpHandler)new CLStaticHttpHandler(cl, new String[]{path.endsWith("/") ? path : path + "/"}){

                            public void service(Request request, Response response) throws Exception {
                                response.addHeader("Access-Control-Allow-Origin", "*");
                                response.addHeader("Access-Control-Allow-Credentials", "true ");
                                response.addHeader("Access-Control-Allow-Methods", "OPTIONS, GET, POST");
                                response.addHeader("Access-Control-Allow-Headers", "Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
                                super.service(request, response);
                            }
                        });
                        System.out.println("Resource published at: " + uri.getPath());
                        ret.setResult(null);
                    }
                });
            }
        });
        return ret;
    }

    @Override
    public IFuture<Void> publishExternal(URI uri, String rootpath) {
        Tuple2<MainHttpHandler, HttpServer> servertuple = this.getHttpServer(uri, null);
        StaticHttpHandler handler = new StaticHttpHandler(new String[]{rootpath}){

            public void service(Request request, Response response) throws Exception {
                response.addHeader("Access-Control-Allow-Origin", "*");
                response.addHeader("Access-Control-Allow-Credentials", "true ");
                response.addHeader("Access-Control-Allow-Methods", "OPTIONS, GET, POST");
                response.addHeader("Access-Control-Allow-Headers", "Content-Type, Depth, User-Agent, X-File-Size, X-Requested-With, If-Modified-Since, X-File-Name, Cache-Control");
                super.service(request, response);
            }
        };
        handler.setFileCacheEnabled(false);
        ((MainHttpHandler)((Object)servertuple.getFirstEntity())).addSubhandler(null, uri.getPath(), (HttpHandler)handler);
        return IFuture.DONE;
    }

    @Override
    public IFuture<Void> unpublishService(IServiceIdentifier sid) {
        Tuple2<HttpServer, URI> tup;
        Future ret = new Future();
        boolean stopped = false;
        if (this.sidservers != null && (tup = this.sidservers.remove(sid)) != null) {
            HttpServer server = (HttpServer)tup.getFirstEntity();
            System.out.println("unpub: " + tup.getSecondEntity());
            Tuple2<MainHttpHandler, HttpServer> servertuple = this.getHttpServer((URI)tup.getSecondEntity(), null);
            ((MainHttpHandler)((Object)servertuple.getFirstEntity())).removeSubhandler(null, ((URI)tup.getSecondEntity()).getPath());
            if (((MainHttpHandler)((Object)servertuple.getFirstEntity())).isEmpty()) {
                Iterator<Tuple2<MainHttpHandler, HttpServer>> servers = this.portservers.values().iterator();
                while (servers.hasNext()) {
                    if (!((HttpServer)servers.next().getSecondEntity()).equals(server)) continue;
                    servers.remove();
                    break;
                }
                server.shutdownNow();
            }
            stopped = true;
            ret.setResult(null);
        }
        if (!stopped) {
            ret.setException((Exception)new RuntimeException("Published service could not be stopped: " + sid));
        }
        return ret;
    }

    public IFuture<Void> unpublish(String vhost, URI uri) {
        Tuple2<MainHttpHandler, HttpServer> servertuple = this.getHttpServer(uri, null);
        ((MainHttpHandler)((Object)servertuple.getFirstEntity())).removeSubhandler(vhost, uri.getPath());
        return IFuture.DONE;
    }

    @Override
    public boolean isPublished(IServiceIdentifier sid) {
        return this.sidservers != null && this.sidservers.containsKey(sid);
    }

    protected HttpServer startServer(URI uri, PublishInfo info, String errorpagefallback) throws Exception {
        HttpServer server = null;
        System.out.println("Starting new server: " + uri.getPort());
        RedirectErrorPageGenerator epg = null;
        String keystore = null;
        String keystorepass = null;
        if (info != null) {
            for (UnparsedExpression upex : info.getProperties()) {
                if ("sslkeystore".equals(upex.getName())) {
                    keystore = (String)SJavaParser.getParsedValue((Object)upex, null, (IValueFetcher)(this.component != null ? this.component.getFetcher() : null), this.component != null ? this.component.getClassLoader() : null);
                    continue;
                }
                if ("sslkeystorepass".equals(upex.getName())) {
                    keystorepass = (String)SJavaParser.getParsedValue((Object)upex, null, (IValueFetcher)(this.component != null ? this.component.getFetcher() : null), this.component != null ? this.component.getClassLoader() : null);
                    continue;
                }
                if (!"errorpage".equals(upex.getName())) continue;
                String errpage = null;
                try {
                    errpage = (String)SJavaParser.getParsedValue((Object)upex, null, (IValueFetcher)(this.component != null ? this.component.getFetcher() : null), this.component != null ? this.component.getClassLoader() : null);
                }
                catch (Exception e) {
                    errpage = upex.getValue();
                }
                if (errpage == null) continue;
                epg = new RedirectErrorPageGenerator(errpage);
            }
        }
        if (keystore != null) {
            SSLContextConfigurator sslContext = new SSLContextConfigurator();
            sslContext.setKeyStoreFile(keystore);
            sslContext.setKeyStorePass(keystorepass);
            SSLEngineConfigurator sslConf = new SSLEngineConfigurator(sslContext).setClientMode(false);
            server = GrizzlyHttpServerFactory.createHttpServer((URI)uri, (GrizzlyHttpContainer)null, (boolean)true, (SSLEngineConfigurator)sslConf, (boolean)false);
        } else {
            server = GrizzlyHttpServerFactory.createHttpServer((URI)uri, (boolean)false);
        }
        if (epg == null && errorpagefallback != null) {
            epg = new RedirectErrorPageGenerator(errorpagefallback);
        }
        if (epg != null) {
            server.getServerConfiguration().setDefaultErrorPageGenerator(epg);
        }
        server.start();
        if (this.portservers == null) {
            this.portservers = new HashMap<Integer, Tuple2<MainHttpHandler, HttpServer>>();
        }
        return server;
    }

    public static class RedirectErrorPageGenerator
    implements ErrorPageGenerator {
        protected String redirecturl;

        public RedirectErrorPageGenerator(String redirecturl) {
            this.redirecturl = redirecturl;
        }

        public String getRedirectUrl() {
            return this.redirecturl;
        }

        public String generate(Request request, int status, String reasonPhrase, String description, Throwable exception) {
            return "<html><html><head><meta http-equiv=\"refresh\" content=\"0;url=" + this.redirecturl + "\"><body></body></html>";
        }
    }

    public static class HtmlHandler
    extends HttpHandler {
        protected Map<String, String> mapping = new LinkedHashMap<String, String>();

        public void addMapping(String host, String html) {
            this.mapping.put(host, html);
        }

        public void service(Request request, Response resp) {
            String host = request.getHeader("host");
            int idx = host.indexOf(":");
            if (idx != -1) {
                host = host.substring(0, idx);
            }
            String html = null;
            for (Map.Entry<String, String> entry : this.mapping.entrySet()) {
                if (entry.getKey().equals(host)) {
                    html = entry.getValue();
                    break;
                }
                if (html != null) continue;
                html = entry.getValue();
            }
            try {
                resp.setContentType("text/html");
                Writer out = resp.getWriter();
                out.write(html);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static class MainHttpHandler
    extends HttpHandler {
        protected Map<Tuple2<String, String>, Tuple2<String, HttpHandler>> subhandlers = Collections.synchronizedMap(new HashMap());
        protected Map<Tuple2<String, String>, Tuple2<String, HttpHandler>> subhandlercache = Collections.synchronizedMap(new HashMap());

        public void service(Request request, Response resp) throws Exception {
            Tuple2<String, HttpHandler> subhandlertuple;
            String path = request.getRequest().getRequestURIRef().getURI();
            String host = request.getHeader("host");
            int idx = host.indexOf(":");
            if (idx != -1) {
                host = host.substring(0, idx);
            }
            if ((subhandlertuple = this.subhandlercache.get(new Tuple2((Object)host, (Object)path))) == null) {
                subhandlertuple = this.subhandlercache.get(new Tuple2(null, (Object)path));
            }
            int pidx = path.lastIndexOf(47);
            if (subhandlertuple == null && pidx > 0 && pidx <= path.length() - 1) {
                String cpath = path.substring(0, pidx);
                subhandlertuple = this.subhandlercache.get(new Tuple2((Object)host, (Object)cpath));
            }
            if (subhandlertuple == null) {
                subhandlertuple = this.findSubhandler(host, path);
                if (subhandlertuple == null) {
                    subhandlertuple = this.findSubhandler(null, path);
                }
                if (subhandlertuple != null) {
                    this.subhandlercache.put((Tuple2<String, String>)new Tuple2((Object)host, (Object)path), subhandlertuple);
                }
            }
            if (subhandlertuple == null) {
                throw new RuntimeException("No handler found for path: " + path);
            }
            try {
                Method setcontextpath = Request.class.getDeclaredMethod("setContextPath", String.class);
                setcontextpath.setAccessible(true);
                setcontextpath.invoke((Object)request, subhandlertuple.getFirstEntity());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            ((HttpHandler)subhandlertuple.getSecondEntity()).service(request, resp);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addSubhandler(String vhost, String path, HttpHandler subhandler) {
            this.subhandlers.put((Tuple2<String, String>)new Tuple2((Object)vhost, (Object)path), (Tuple2<String, HttpHandler>)new Tuple2((Object)path, (Object)subhandler));
            Map<Tuple2<String, String>, Tuple2<String, HttpHandler>> map = this.subhandlers;
            synchronized (map) {
                this.subhandlercache = Collections.synchronizedMap(new HashMap<Tuple2<String, String>, Tuple2<String, HttpHandler>>(this.subhandlers));
            }
        }

        public boolean containsSubhandlerForExactUri(String vhost, String path) {
            return this.subhandlers.containsKey(new Tuple2((Object)vhost, (Object)path));
        }

        public boolean isEmpty() {
            return this.subhandlers.isEmpty();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeSubhandler(String vhost, String path) {
            this.subhandlers.remove(new Tuple2((Object)vhost, (Object)path));
            Map<Tuple2<String, String>, Tuple2<String, HttpHandler>> map = this.subhandlers;
            synchronized (map) {
                this.subhandlercache = Collections.synchronizedMap(new HashMap<Tuple2<String, String>, Tuple2<String, HttpHandler>>(this.subhandlers));
            }
        }

        protected Tuple2<String, HttpHandler> findSubhandler(String host, String path) {
            Tuple2<String, HttpHandler> ret = null;
            do {
                int pidx;
                if ((pidx = path.lastIndexOf(47)) >= 0) {
                    path = path.substring(0, pidx);
                    ret = this.subhandlercache.get(new Tuple2((Object)host, (Object)path));
                    continue;
                }
                path = null;
            } while (ret == null && path != null && path.length() > 0);
            return ret;
        }
    }
}

