/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.relay;

import jadex.base.relay.PlatformInfo;
import jadex.base.relay.RelayHandler;
import jadex.bridge.BasicComponentIdentifier;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;

public class StatsDB {
    protected String peerid;
    protected Connection con;
    protected PreparedStatement insert;
    protected PreparedStatement insert2;
    protected PreparedStatement update;
    protected PreparedStatement getlatest;
    protected PreparedStatement deleteprops;
    protected PreparedStatement insertprops;
    protected Map<String, Integer> latest = new HashMap<String, Integer>();

    public static StatsDB createDB(String peerid) {
        StatsDB ret = null;
        try {
            ret = new StatsDB(peerid, StatsDB.openH2DB(peerid));
            if (new File(RelayHandler.SYSTEMDIR, "mydb").exists()) {
                StatsDB old = new StatsDB(peerid, StatsDB.openDerbyDB());
                ret.migrateFrom(old);
                old.shutdown();
                new File(RelayHandler.SYSTEMDIR, "mydb").renameTo(new File(RelayHandler.SYSTEMDIR, "derbydb_bak"));
            }
        }
        catch (Exception e) {
            StringWriter sw = new StringWriter();
            e.printStackTrace(new PrintWriter(sw));
            RelayHandler.getLogger().warning("Warning: Could not connect to relay stats DB: " + sw.toString());
        }
        return ret;
    }

    protected StatsDB(String peerid, Connection con) {
        this.peerid = peerid;
        this.con = con;
    }

    protected static Connection openDerbyDB() throws Exception {
        System.setProperty("derby.system.home", RelayHandler.SYSTEMDIR.getAbsolutePath());
        Class.forName("org.apache.derby.jdbc.EmbeddedDriver").newInstance();
        Connection con = DriverManager.getConnection("jdbc:derby:mydb;create=true");
        DatabaseMetaData meta = con.getMetaData();
        ResultSet rs = meta.getTables(null, "RELAY", "PLATFORMINFO", null);
        if (!rs.next()) {
            rs.close();
            Statement stmt = con.createStatement();
            stmt.execute("CREATE TABLE RELAY.PLATFORMINFO (ID\tINTEGER NOT NULL PRIMARY KEY GENERATED ALWAYS AS IDENTITY (START WITH 1, INCREMENT BY 1),PLATFORM\tVARCHAR(60),HOSTIP\tVARCHAR(32),HOSTNAME\tVARCHAR(60),SCHEME\tVARCHAR(10),CONTIME\tTIMESTAMP,DISTIME\tTIMESTAMP,MSGS\tINTEGER,BYTES\tDOUBLE,TRANSTIME\tDOUBLE,PREFIX\tVARCHAR(60))");
            stmt.close();
        } else {
            rs.close();
            Statement stmt = con.createStatement();
            stmt.executeUpdate("UPDATE RELAY.PLATFORMINFO SET DISTIME=CONTIME WHERE DISTIME IS NULL");
            stmt.executeUpdate("UPDATE RELAY.PLATFORMINFO SET HOSTNAME='IP '||HOSTIP WHERE HOSTIP=HOSTNAME");
            stmt.close();
            PreparedStatement update = con.prepareStatement("UPDATE RELAY.PLATFORMINFO SET PLATFORM=?, PREFIX=? WHERE ID=?");
            rs = con.createStatement().executeQuery("select ID, PLATFORM from relay.platforminfo where PLATFORM like 'and-%'");
            while (rs.next()) {
                int param = 1;
                String name = "and_" + rs.getString("PLATFORM").substring(4);
                update.setString(param++, name);
                update.setString(param++, BasicComponentIdentifier.getPlatformPrefix((String)name));
                update.setInt(param++, rs.getInt("ID"));
                update.executeUpdate();
            }
            rs.close();
            update.close();
        }
        meta = con.getMetaData();
        rs = meta.getTables(null, "RELAY", "PROPERTIES", null);
        if (!rs.next()) {
            con.createStatement().execute("CREATE TABLE RELAY.PROPERTIES (ID\tINTEGER CONSTRAINT PLATFORM_KEY REFERENCES RELAY.PLATFORMINFO(ID),NAME\tVARCHAR(30),VALUE\tVARCHAR(60))");
        }
        rs.close();
        return con;
    }

    protected static Connection openH2DB(String peerid) throws Exception {
        Class.forName("org.h2.Driver");
        Connection con = DriverManager.getConnection("jdbc:h2:" + RelayHandler.SYSTEMDIR.getAbsolutePath() + "/relaystats;INIT=CREATE SCHEMA IF NOT EXISTS RELAY");
        Statement stmt = con.createStatement();
        DatabaseMetaData meta = con.getMetaData();
        ResultSet rs = meta.getTables(null, "RELAY", "PLATFORMINFO", null);
        if (!rs.next()) {
            rs.close();
            stmt.execute("CREATE TABLE RELAY.PLATFORMINFO (ID\tINTEGER NOT NULL AUTO_INCREMENT,PEER VARCHAR(60) NOT NULL,PLATFORM\tVARCHAR(60),HOSTIP\tVARCHAR(32),HOSTNAME\tVARCHAR(60),SCHEME\tVARCHAR(10),CONTIME\tTIMESTAMP,DISTIME\tTIMESTAMP,MSGS\tINTEGER,BYTES\tDOUBLE,TRANSTIME\tDOUBLE,PREFIX\tVARCHAR(60),PRIMARY KEY (ID, PEER))");
        } else {
            rs.close();
            rs = meta.getColumns(null, "RELAY", "PLATFORMINFO", "PEER");
            if (!rs.next()) {
                rs.close();
                stmt.execute("ALTER TABLE RELAY.PLATFORMINFO ADD PEER VARCHAR(60)");
                stmt.executeUpdate("UPDATE RELAY.PLATFORMINFO SET PEER='" + peerid + "' WHERE PEER IS NULL");
                stmt.execute("ALTER TABLE RELAY.PLATFORMINFO ALTER COLUMN PEER SET NOT NULL");
                stmt.execute("ALTER TABLE RELAY.PLATFORMINFO DROP PRIMARY KEY");
                stmt.execute("ALTER TABLE RELAY.PLATFORMINFO ADD PRIMARY KEY(ID, PEER)");
            } else {
                rs.close();
                rs = meta.getPrimaryKeys(null, "RELAY", "PLATFORMINFO");
                boolean pks = rs.next();
                if (!pks || !rs.next()) {
                    stmt.execute("ALTER TABLE RELAY.PLATFORMINFO ALTER COLUMN PEER SET NOT NULL");
                    if (pks) {
                        stmt.execute("ALTER TABLE RELAY.PLATFORMINFO DROP PRIMARY KEY");
                    }
                    stmt.execute("ALTER TABLE RELAY.PLATFORMINFO ADD PRIMARY KEY(ID, PEER)");
                }
                rs.close();
            }
            stmt.executeUpdate("UPDATE RELAY.PLATFORMINFO SET DISTIME=CONTIME WHERE DISTIME IS NULL");
        }
        meta = con.getMetaData();
        rs = meta.getTables(null, "RELAY", "PROPERTIES", null);
        if (!rs.next()) {
            rs.close();
            con.createStatement().execute("CREATE TABLE RELAY.PROPERTIES (ID\tINTEGER NOT NULL,PEER VARCHAR(60) NOT NULL,NAME\tVARCHAR(30),VALUE\tVARCHAR(60),FOREIGN KEY (ID, PEER) REFERENCES PLATFORMINFO (ID, PEER))");
        } else {
            rs.close();
            rs = meta.getColumns(null, "RELAY", "PROPERTIES", "PEER");
            if (!rs.next()) {
                rs.close();
                stmt.execute("ALTER TABLE RELAY.PROPERTIES ADD PEER VARCHAR(60)");
                stmt.executeUpdate("UPDATE RELAY.PROPERTIES SET PEER='" + peerid + "' WHERE PEER IS NULL");
                stmt.execute("ALTER TABLE RELAY.PROPERTIES ALTER COLUMN PEER SET NOT NULL");
                stmt.execute("ALTER TABLE RELAY.PROPERTIES DROP CONSTRAINT PLATFORM_KEY");
                stmt.execute("ALTER TABLE RELAY.PROPERTIES ADD FOREIGN KEY (ID, PEER) REFERENCES PLATFORMINFO (ID, PEER)");
            } else {
                rs.close();
                rs = meta.getImportedKeys(null, "RELAY", "PROPERTIES");
                if (!rs.next() || !rs.next()) {
                    stmt.execute("ALTER TABLE RELAY.PROPERTIES ADD FOREIGN KEY (ID, PEER) REFERENCES PLATFORMINFO (ID, PEER)");
                }
                rs.close();
            }
        }
        stmt.close();
        return con;
    }

    public synchronized void save(PlatformInfo pi) {
        if (this.con != null) {
            try {
                int param;
                String name = pi.getId();
                if (name.startsWith("and-")) {
                    name = "and_" + name.substring(4);
                }
                if (pi.getDBId() == null) {
                    if (this.insert == null) {
                        this.insert = this.con.prepareStatement("INSERT INTO relay.platforminfo (PEER, PLATFORM, HOSTIP, HOSTNAME, SCHEME, CONTIME, DISTIME, MSGS, BYTES, TRANSTIME, PREFIX) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)", 1);
                    }
                    param = 1;
                    this.insert.setString(param++, this.peerid);
                    this.insert.setString(param++, name);
                    this.insert.setString(param++, pi.getHostIP());
                    this.insert.setString(param++, pi.getHostName());
                    this.insert.setString(param++, pi.getScheme());
                    this.insert.setTimestamp(param++, pi.getConnectDate() != null ? new Timestamp(pi.getConnectDate().getTime()) : null);
                    this.insert.setTimestamp(param++, pi.getDisconnectDate() != null ? new Timestamp(pi.getDisconnectDate().getTime()) : null);
                    this.insert.setInt(param++, pi.getMessageCount());
                    this.insert.setDouble(param++, pi.getBytes());
                    this.insert.setDouble(param++, pi.getTransferTime());
                    this.insert.setString(param++, BasicComponentIdentifier.getPlatformPrefix((String)name));
                    this.insert.executeUpdate();
                    ResultSet keys = this.insert.getGeneratedKeys();
                    keys.next();
                    pi.setDBId(keys.getInt(1));
                    keys.close();
                } else {
                    if (this.update == null) {
                        this.update = this.con.prepareStatement("UPDATE relay.platforminfo SET PLATFORM=?, HOSTIP=?, HOSTNAME=?, SCHEME=?, CONTIME=?, DISTIME=?, MSGS=?, BYTES=?, TRANSTIME=?, PREFIX=? WHERE ID=? AND PEER=?");
                    }
                    param = 1;
                    this.update.setString(param++, name);
                    this.update.setString(param++, pi.getHostIP());
                    this.update.setString(param++, pi.getHostName());
                    this.update.setString(param++, pi.getScheme());
                    this.update.setTimestamp(param++, pi.getConnectDate() != null ? new Timestamp(pi.getConnectDate().getTime()) : null);
                    this.update.setTimestamp(param++, pi.getDisconnectDate() != null ? new Timestamp(pi.getDisconnectDate().getTime()) : null);
                    this.update.setInt(param++, pi.getMessageCount());
                    this.update.setDouble(param++, pi.getBytes());
                    this.update.setDouble(param++, pi.getTransferTime());
                    this.update.setString(param++, BasicComponentIdentifier.getPlatformPrefix((String)name));
                    this.update.setInt(param++, pi.getDBId());
                    this.update.setString(param++, pi.getPeerId());
                    int cnt = this.update.executeUpdate();
                    if (cnt == 0) {
                        if (this.insert2 == null) {
                            this.insert2 = this.con.prepareStatement("INSERT INTO relay.platforminfo (ID, PEER, PLATFORM, HOSTIP, HOSTNAME, SCHEME, CONTIME, DISTIME, MSGS, BYTES, TRANSTIME, PREFIX) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
                        }
                        param = 1;
                        this.insert2.setInt(param++, pi.getDBId());
                        this.insert2.setString(param++, pi.getPeerId());
                        this.insert2.setString(param++, name);
                        this.insert2.setString(param++, pi.getHostIP());
                        this.insert2.setString(param++, pi.getHostName());
                        this.insert2.setString(param++, pi.getScheme());
                        this.insert2.setTimestamp(param++, pi.getConnectDate() != null ? new Timestamp(pi.getConnectDate().getTime()) : null);
                        this.insert2.setTimestamp(param++, pi.getDisconnectDate() != null ? new Timestamp(pi.getDisconnectDate().getTime()) : null);
                        this.insert2.setInt(param++, pi.getMessageCount());
                        this.insert2.setDouble(param++, pi.getBytes());
                        this.insert2.setDouble(param++, pi.getTransferTime());
                        this.insert2.setString(param++, BasicComponentIdentifier.getPlatformPrefix((String)name));
                        this.insert2.executeUpdate();
                    }
                }
                if (pi.getProperties() != null) {
                    if (this.deleteprops == null) {
                        this.deleteprops = this.con.prepareStatement("DELETE FROM relay.properties WHERE ID=? AND PEER=?");
                    }
                    param = 1;
                    this.deleteprops.setInt(param++, pi.getDBId());
                    this.deleteprops.setString(param++, pi.getPeerId());
                    this.deleteprops.executeUpdate();
                    if (this.insertprops == null) {
                        this.insertprops = this.con.prepareStatement("INSERT INTO relay.properties (ID, PEER, NAME, VALUE) VALUES (?, ?, ?, ?)");
                    }
                    for (String propname : pi.getProperties().keySet()) {
                        param = 1;
                        this.insertprops.setInt(param++, pi.getDBId());
                        this.insertprops.setString(param++, pi.getPeerId());
                        this.insertprops.setString(param++, propname);
                        this.insertprops.setString(param++, pi.getProperties().get(propname));
                        this.insertprops.executeUpdate();
                    }
                }
                if (pi.getPeerId() != null && this.latest.containsKey(pi.getPeerId())) {
                    this.latest.remove(pi.getPeerId());
                }
            }
            catch (Exception e) {
                RelayHandler.getLogger().warning("Warning: Could not save platform info: " + e);
            }
        }
    }

    public Iterator<PlatformInfo> getAllPlatformInfos(final boolean properties) {
        Iterator<PlatformInfo> ret;
        if (this.con != null) {
            try {
                final PreparedStatement ps = properties ? this.con.prepareStatement("select * from relay.properties where ID=?") : null;
                final ResultSet rs = this.con.createStatement().executeQuery("select * from relay.platforminfo order by id asc");
                ret = new Iterator<PlatformInfo>(){
                    boolean cursormoved;
                    boolean hasnext;

                    @Override
                    public boolean hasNext() {
                        if (!this.cursormoved) {
                            try {
                                this.hasnext = rs.next();
                                this.cursormoved = true;
                                if (!this.hasnext) {
                                    rs.close();
                                    if (ps != null) {
                                        ps.close();
                                    }
                                }
                            }
                            catch (SQLException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        return this.hasnext;
                    }

                    @Override
                    public PlatformInfo next() {
                        if (this.hasNext()) {
                            try {
                                String peer = null;
                                try {
                                    peer = rs.getString("PEER");
                                }
                                catch (Exception exception) {
                                    // empty catch block
                                }
                                PlatformInfo pi = new PlatformInfo(rs.getInt("ID"), peer, rs.getString("PLATFORM"), rs.getString("HOSTIP"), rs.getString("HOSTNAME"), rs.getString("SCHEME"), rs.getTimestamp("CONTIME"), rs.getTimestamp("DISTIME"), rs.getInt("MSGS"), rs.getDouble("BYTES"), rs.getDouble("TRANSTIME"));
                                if (properties) {
                                    HashMap<String, String> props = new HashMap<String, String>();
                                    pi.setProperties(props);
                                    ps.setInt(1, pi.getDBId());
                                    ResultSet rs2 = ps.executeQuery();
                                    while (rs2.next()) {
                                        props.put(rs2.getString("NAME"), rs2.getString("VALUE"));
                                    }
                                    rs2.close();
                                }
                                this.cursormoved = false;
                                return pi;
                            }
                            catch (SQLException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        throw new NoSuchElementException();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
            catch (Exception e) {
                e.printStackTrace();
                RelayHandler.getLogger().warning("Warning: Could not read from relay stats DB: " + e);
                List list = Collections.emptyList();
                ret = list.iterator();
            }
        } else {
            List list = Collections.emptyList();
            ret = list.iterator();
        }
        return ret;
    }

    public PlatformInfo[] getPlatformInfosForSync(String peerid, int startid, int cnt) {
        ArrayList<PlatformInfo> ret = new ArrayList<PlatformInfo>();
        if (this.con != null) {
            ResultSet rs = null;
            try {
                PreparedStatement ps = this.con.prepareStatement("SELECT * FROM RELAY.PROPERTIES WHERE PEER=? AND ID=?");
                PreparedStatement qpls = this.con.prepareStatement("SELECT * FROM RELAY.PLATFORMINFO WHERE PEER=? AND ID>=? ORDER BY ID ASC ");
                qpls.setString(1, peerid);
                qpls.setInt(2, startid);
                rs = qpls.executeQuery();
                while (rs.next() && ret.size() < cnt) {
                    PlatformInfo pi = new PlatformInfo(rs.getInt("ID"), rs.getString("PEER"), rs.getString("PLATFORM"), rs.getString("HOSTIP"), rs.getString("HOSTNAME"), null, rs.getTimestamp("CONTIME"), rs.getTimestamp("DISTIME"), rs.getInt("MSGS"), 0.0, 0.0);
                    ret.add(pi);
                    HashMap<String, String> props = new HashMap<String, String>();
                    pi.setProperties(props);
                    ps.setString(1, pi.getPeerId());
                    ps.setInt(2, pi.getDBId());
                    ResultSet rs2 = ps.executeQuery();
                    while (rs2.next()) {
                        props.put(rs2.getString("NAME"), rs2.getString("VALUE"));
                    }
                    rs2.close();
                }
                qpls.close();
                rs.close();
            }
            catch (Exception e) {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                e.printStackTrace();
                RelayHandler.getLogger().warning("Warning: Could not read from relay stats DB: " + e);
            }
        }
        return ret.toArray(new PlatformInfo[ret.size()]);
    }

    public PlatformInfo[] getPlatformInfos(int limit) {
        long start = System.nanoTime();
        ArrayList<PlatformInfo> ret = new ArrayList<PlatformInfo>();
        if (this.con != null) {
            ResultSet rs = null;
            try {
                HashMap<String, PlatformInfo> map = new HashMap<String, PlatformInfo>();
                rs = this.con.createStatement().executeQuery("select max(id) as ID, prefix as PLATFORM, hostip, max(HOSTNAME) as HOSTNAME, count(id) as MSGS, max(CONTIME) AS CONTIME, min(CONTIME) AS DISTIME from relay.platforminfo group by hostip, prefix order by CONTIME desc");
                System.out.println("took a: " + (System.nanoTime() - start) / 1000000L + " ms");
                while (rs.next() && (limit == -1 || ret.size() < limit)) {
                    PlatformInfo pi;
                    if (map.containsKey(rs.getString("HOSTIP"))) {
                        pi = (PlatformInfo)map.get(rs.getString("HOSTIP"));
                        if (pi.getId().indexOf(rs.getString("PLATFORM")) != -1) continue;
                        String platform = rs.getString("PLATFORM");
                        if (platform.length() > 16) {
                            String pre = rs.getString("PLATFORM").substring(0, 13);
                            if (pi.getId().indexOf(pre) == -1) {
                                pi.setId(pi.getId() + ", " + pre + "...");
                            }
                        } else {
                            pi.setId(pi.getId() + ", " + platform);
                        }
                        if (pi.getConnectDate() == null || rs.getTimestamp("CONTIME") != null && rs.getTimestamp("CONTIME").getTime() > pi.getConnectDate().getTime()) {
                            pi.setConnectDate(rs.getTimestamp("CONTIME"));
                        }
                        if (pi.getDisconnectDate() != null && (rs.getTimestamp("DISTIME") == null || rs.getTimestamp("DISTIME").getTime() >= pi.getDisconnectDate().getTime())) continue;
                        pi.setDisconnectDate(rs.getTimestamp("DISTIME"));
                        continue;
                    }
                    pi = new PlatformInfo(rs.getInt("ID"), null, rs.getString("PLATFORM"), rs.getString("HOSTIP"), rs.getString("HOSTNAME"), null, rs.getTimestamp("CONTIME"), rs.getTimestamp("DISTIME"), rs.getInt("MSGS"), 0.0, 0.0);
                    map.put(rs.getString("HOSTIP"), pi);
                    ret.add(pi);
                }
                rs.close();
            }
            catch (Exception e) {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                e.printStackTrace();
                RelayHandler.getLogger().warning("Warning: Could not read from relay stats DB: " + e);
            }
        }
        System.out.println("took b: " + (System.nanoTime() - start) / 1000000L + " ms");
        return ret.toArray(new PlatformInfo[ret.size()]);
    }

    public void writePlatformInfos(OutputStream out, int limit) {
        if (this.con != null) {
            ResultSet rs = null;
            try {
                rs = this.con.createStatement().executeQuery("select max(id) as ID, prefix as PLATFORM, hostip, max(HOSTNAME) as HOSTNAME, count(id) as MSGS, max(CONTIME) AS CONTIME, min(CONTIME) AS DISTIME from relay.platforminfo group by hostip, prefix order by CONTIME desc");
                out.write("{\"data\":[".getBytes("UTF-8"));
                for (int i = 0; rs.next() && (limit == -1 || i < limit); ++i) {
                    if (i == 0) {
                        out.write("[\"".getBytes("UTF-8"));
                    } else {
                        out.write(",[\"".getBytes("UTF-8"));
                    }
                    out.write(rs.getString("PLATFORM").getBytes("UTF-8"));
                    out.write("\",\"".getBytes("UTF-8"));
                    out.write(rs.getString("HOSTIP").getBytes("UTF-8"));
                    out.write("\",\"".getBytes("UTF-8"));
                    out.write(PlatformInfo.TIME_FORMAT_LONG.get().format(rs.getTimestamp("CONTIME")).getBytes("UTF-8"));
                    out.write("\",\"".getBytes("UTF-8"));
                    out.write(PlatformInfo.TIME_FORMAT_LONG.get().format(rs.getTimestamp("DISTIME")).getBytes("UTF-8"));
                    out.write("\",\"".getBytes("UTF-8"));
                    out.write(Integer.toString(rs.getInt("MSGS")).getBytes("UTF-8"));
                    out.write("\"]".getBytes("UTF-8"));
                }
                rs.close();
                out.write("]}".getBytes("UTF-8"));
            }
            catch (Exception e) {
                if (rs != null) {
                    try {
                        rs.close();
                    }
                    catch (SQLException sQLException) {
                        // empty catch block
                    }
                }
                e.printStackTrace();
                RelayHandler.getLogger().warning("Warning: Could not read from relay stats DB: " + e);
            }
        }
    }

    public synchronized int getLatestEntry(String peerid) {
        int ret;
        if (this.latest.containsKey(peerid)) {
            ret = this.latest.get(peerid);
        } else {
            try {
                if (this.getlatest == null) {
                    this.getlatest = this.con.prepareStatement("SELECT MAX(ID) FROM relay.platforminfo WHERE PEER=? and DISTIME IS NOT NULL");
                }
                this.getlatest.setString(1, peerid);
                ResultSet rs = this.getlatest.executeQuery();
                ret = rs.next() ? rs.getInt(1) : 0;
                rs.close();
                this.latest.put(peerid, new Integer(ret));
            }
            catch (Exception e) {
                RelayHandler.getLogger().warning("Warning: Could not read from relay stats DB: " + e);
                ret = -1;
            }
        }
        return ret;
    }

    public void shutdown() {
        try {
            if (this.con != null) {
                this.con.close();
            }
            DriverManager.getConnection("jdbc:derby:;shutdown=true").close();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    protected void migrateFrom(StatsDB old) {
        Iterator<PlatformInfo> infos = old.getAllPlatformInfos(true);
        while (infos.hasNext()) {
            PlatformInfo info = infos.next();
            info.setDBId(null);
            this.save(info);
        }
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("relay.standalone", "true");
        if (args.length > 0) {
            String sql = null;
            for (String s : args) {
                sql = sql == null ? s : sql + " " + s;
            }
            System.out.println("Executing: " + sql);
            StatsDB db = StatsDB.createDB("test");
            Statement stmt = db.con.createStatement();
            boolean query = stmt.execute(sql);
            if (query) {
                StatsDB.printResultSet(stmt.getResultSet());
            } else {
                System.out.println("Update count: " + stmt.getUpdateCount());
            }
            stmt.close();
        } else {
            StatsDB db = StatsDB.createDB("test");
            System.out.println("Latest: " + db.getLatestEntry("test"));
            System.out.println("---");
            StatsDB.printPlatformInfos(db.getPlatformInfos(-1));
            System.out.println("---");
            StatsDB.printPlatformInfos(db.getAllPlatformInfos(false));
            Statement stmt = db.con.createStatement();
            StatsDB.printResultSet(stmt.executeQuery("select * from relay.platforminfo"));
            DatabaseMetaData meta = db.con.getMetaData();
            StatsDB.printResultSet(meta.getColumns(null, "RELAY", "PLATFORMINFO", null));
            StatsDB.printResultSet(meta.getColumns(null, "RELAY", "PROPERTIES", null));
            StatsDB.printResultSet(stmt.executeQuery("select * from relay.properties"));
            stmt.close();
        }
    }

    protected static void printPlatformInfos(PlatformInfo[] infos) {
        System.out.println("Platform infos:");
        for (int i = 0; i < infos.length; ++i) {
            System.out.println(infos[i]);
        }
    }

    protected static void printPlatformInfos(Iterator<PlatformInfo> infos) {
        System.out.println("Platform infos:");
        while (infos.hasNext()) {
            System.out.println(infos.next());
        }
    }

    protected static void printResultSet(ResultSet rs) throws Exception {
        while (rs.next()) {
            int cnt = rs.getMetaData().getColumnCount();
            for (int i = 1; i <= cnt; ++i) {
                System.out.print(rs.getMetaData().getColumnName(i) + ": " + rs.getString(i) + ", ");
            }
            System.out.println();
        }
    }

    protected static void logResultSet(ResultSet rs) throws Exception {
        while (rs.next()) {
            int cnt = rs.getMetaData().getColumnCount();
            String col = "";
            for (int i = 1; i <= cnt; ++i) {
                col = col + rs.getMetaData().getColumnName(i) + ": " + rs.getString(i) + ", ";
            }
            RelayHandler.getLogger().info(col);
        }
    }
}

