/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.relay;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import java.util.UUID;

public class RelayServerSettings {
    public static final String PROPERTY_ID = "id";
    public static final String PROPERTY_URL = "url";
    public static final String PROPERTY_PEERS = "initial_peers";
    public static final String PROPERTY_DEBUG = "debug";
    public static final String PROPERTY_DBSYNC = "dbsync";
    public static final String PROPERTY_NOCONNECTIONS = "no_connections";
    protected Properties props = new Properties();

    public String getId() {
        return this.props.getProperty(PROPERTY_ID);
    }

    public boolean isUrlSpecified() {
        return this.props.containsKey(PROPERTY_URL) && !"".equals(this.props.getProperty(PROPERTY_URL));
    }

    public String getUrl() {
        return this.props.getProperty(PROPERTY_URL);
    }

    public String getInitialPeers() {
        return this.props.getProperty(PROPERTY_PEERS);
    }

    public int getDebugLevel() {
        int debug;
        try {
            debug = "true".equals(this.props.getProperty(PROPERTY_DEBUG)) ? 3 : Integer.parseInt(this.props.getProperty(PROPERTY_DEBUG));
        }
        catch (Exception e) {
            debug = 0;
        }
        return debug;
    }

    public boolean isDBSync() {
        return "true".equals(this.props.getProperty(PROPERTY_DBSYNC));
    }

    public boolean isNoConnections() {
        return "true".equals(this.props.getProperty(PROPERTY_NOCONNECTIONS));
    }

    public void loadSettings(File file, boolean create) throws Exception {
        if (file.exists()) {
            FileInputStream fis = new FileInputStream(file);
            this.props.load(fis);
            ((InputStream)fis).close();
        }
        if (this.getId() == null && create) {
            this.props.setProperty(PROPERTY_ID, UUID.randomUUID().toString());
            this.save(file);
        }
    }

    public void save(File file) throws Exception {
        FileOutputStream fos = new FileOutputStream(file);
        this.props.store(fos, " Relay peer properties.\n Specify settings below to enable load balancing and exchanging awareness information with other relay servers.\n 'id' is this relay's own generated ID to differentiate entries from different peers in shared history information.\n Set 'url' to this relay's own publically accessible URL, e.g., http://www.mydomain.com:8080/relay (required for enabling peer-to-peer behavior).\n Set 'initial_peers' to a comma separated list of peer server urls to connect to at startup (optional, if this relay should only respond to connections from other peers).\n Set 'dbsync' to true, if synchronization with other relay history DBs is desired (optional).\n Set 'no_connections' to true, if you want to prevent platforms from connecting to this relay, e.g. use this relay only to find other peers or for db sync of old history entries (optional).\n Set 'debug=true' or 'debug=0..3' for enabling debugging output in html tooltips of peer relay table (optional, 0 means off, 3 is fine grained debug about single platforms).");
        ((OutputStream)fos).close();
    }
}

