/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.relay;

import jadex.base.relay.Message;
import jadex.base.relay.PeerHandler;
import jadex.base.relay.PeerList;
import jadex.base.relay.PlatformInfo;
import jadex.base.relay.RelayServerSettings;
import jadex.base.relay.StatsDB;
import jadex.bridge.BasicComponentIdentifier;
import jadex.bridge.IComponentIdentifier;
import jadex.bridge.service.types.awareness.AwarenessInfo;
import jadex.bridge.service.types.message.ICodec;
import jadex.commons.SReflect;
import jadex.commons.SUtil;
import jadex.commons.collection.ArrayBlockingQueue;
import jadex.commons.collection.IBlockingQueue;
import jadex.commons.concurrent.TimeoutException;
import jadex.commons.transformation.STransformation;
import jadex.commons.transformation.binaryserializer.BinarySerializer;
import jadex.commons.transformation.binaryserializer.IErrorReporter;
import jadex.platform.service.message.MapSendTask;
import jadex.platform.service.message.transport.MessageEnvelope;
import jadex.platform.service.message.transport.codecs.CodecFactory;
import jadex.platform.service.message.transport.httprelaymtp.RelayConnectionManager;
import jadex.xml.bean.JavaReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;

public class RelayHandler {
    public static final File SYSTEMDIR;
    protected RelayServerSettings settings;
    protected Map<String, IBlockingQueue<Message>> map = Collections.synchronizedMap(new HashMap());
    protected Map<Object, PlatformInfo> platforms = Collections.synchronizedMap(new LinkedHashMap());
    protected Map<Byte, ICodec> codecs;
    protected ICodec[] defcodecs;
    protected PeerList peers;
    protected StatsDB statsdb;
    protected RelayConnectionManager conman;

    public RelayHandler() {
        CodecFactory cfac = new CodecFactory();
        this.codecs = cfac.getAllCodecs();
        this.defcodecs = cfac.getDefaultCodecs();
        this.settings = new RelayServerSettings();
        try {
            this.settings.loadSettings(new File(SYSTEMDIR, "peer.properties"), true);
        }
        catch (Exception e) {
            RelayHandler.getLogger().warning("Could not load relay settings: " + e);
        }
        this.peers = new PeerList(this);
        this.statsdb = StatsDB.createDB(this.settings.getId());
        this.conman = new RelayConnectionManager();
        STransformation.registerClass(MessageEnvelope.class);
        this.peers.addPeers(this.settings.getInitialPeers(), true);
    }

    public void dispose() {
        if (this.map != null && !this.map.isEmpty()) {
            Iterator<Object> it = this.map.values().iterator();
            while (it.hasNext()) {
                IBlockingQueue queue = (IBlockingQueue)it.next();
                it.remove();
                List items = queue.setClosed(true);
                for (int i = 0; i < items.size(); ++i) {
                    ((Message)items.get(i)).getFuture().setException((Exception)new RuntimeException("Target disconnected."));
                }
            }
        }
        if (this.platforms != null && !this.platforms.isEmpty()) {
            for (PlatformInfo pi : this.platforms.values()) {
                pi.disconnect();
                if (this.statsdb == null) continue;
                this.statsdb.save(pi);
            }
        }
        if (this.statsdb != null) {
            this.statsdb.shutdown();
        }
        this.peers.dispose();
        this.conman.dispose();
    }

    public RelayServerSettings getSettings() {
        return this.settings;
    }

    public RelayConnectionManager getConnectionManager() {
        return this.conman;
    }

    public PeerList getPeerList() {
        return this.peers;
    }

    public void initConnection(String id, String hostip, String hostname, String protocol) {
        ArrayBlockingQueue queue;
        PlatformInfo info = this.platforms.get(id);
        if (info == null) {
            info = new PlatformInfo(id, this.settings.getId(), hostip, hostname, protocol);
            this.platforms.put(id, info);
        } else {
            info.reconnect(hostip, hostname);
        }
        if (this.statsdb != null) {
            this.statsdb.save(info);
        }
        if ((queue = this.map.get(id)) != null) {
            List items = queue.setClosed(true);
            queue = new ArrayBlockingQueue();
            for (int i = 0; i < items.size(); ++i) {
                queue.enqueue(items.get(i));
            }
        } else {
            queue = new ArrayBlockingQueue();
        }
        this.map.put(id, (IBlockingQueue<Message>)queue);
        this.sendPlatformInfo(info);
        RelayHandler.getLogger().info("Client connected: '" + id + "'");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void handleConnection(String id, OutputStream out) {
        PlatformInfo info = this.platforms.get(id);
        IBlockingQueue<Message> queue = this.map.get(id);
        try {
            out.write(2);
            out.flush();
            while (true) {
                try {}
                catch (TimeoutException te) {
                    out.write(2);
                    out.flush();
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            RelayHandler.getLogger().info("Client disconnected: " + id + ", " + e);
            if (!queue.isClosed()) {
                AwarenessInfo awainfo;
                List items = queue.setClosed(true);
                this.map.remove(id);
                PlatformInfo platform = this.platforms.remove(id);
                if (platform != null) {
                    platform.disconnect();
                    if (this.statsdb != null) {
                        this.statsdb.save(platform);
                    }
                }
                AwarenessInfo awarenessInfo = awainfo = platform != null ? platform.getAwarenessInfo() : null;
                if (awainfo != null) {
                    awainfo.setState("offline");
                    this.sendAwarenessInfos(awainfo, platform.getPreferredCodecs(), true, false);
                } else if (platform != null) {
                    this.sendPlatformInfo(platform);
                }
                for (int i = 0; i < items.size(); ++i) {
                    ((Message)items.get(i)).getFuture().setException((Exception)new RuntimeException("Target disconnected."));
                }
            }
            return;
        }
        while (true) {
            Message msg = (Message)queue.dequeue(30000L);
            try {
                int len;
                out.write(msg.getMessageType());
                long start = System.nanoTime();
                byte[] buf = new byte[8192];
                int cnt = 0;
                while ((len = msg.getContent().read(buf)) != -1) {
                    out.write(buf, 0, len);
                    cnt += len;
                }
                out.flush();
                info.addMessage(cnt, System.nanoTime() - start);
                msg.getFuture().setResult(null);
            }
            catch (Exception e) {
                msg.getFuture().setException(e);
                throw e;
            }
        }
    }

    public void handleMessage(InputStream in, String protocol) throws Exception {
        String targetid = RelayHandler.readString(in);
        PlatformInfo targetpi = this.platforms.get(targetid);
        IBlockingQueue<Message> queue = this.map.get(targetid);
        if (queue == null || targetpi == null || protocol.equals("https") && !targetpi.getScheme().equals("https")) {
            throw new RuntimeException("message not sent: " + targetid + ", " + targetpi + ", " + queue);
        }
        Message msg = new Message(1, in);
        queue.enqueue((Object)msg);
        msg.getFuture().get(30000L);
    }

    public void handleAwareness(InputStream in) throws Exception {
        boolean initial;
        RelayHandler.readString(in);
        byte[] len = RelayHandler.readData(in, 4);
        int length = SUtil.bytesToInt((byte[])len);
        byte[] buffer = RelayHandler.readData(in, length - 1);
        MessageEnvelope msg = (MessageEnvelope)MapSendTask.decodeMessage((byte[])buffer, this.codecs, (ClassLoader)this.getClass().getClassLoader(), null);
        ICodec[] pcodecs = MapSendTask.getCodecs((byte[])buffer, this.codecs);
        AwarenessInfo info = "jadex-raw".equals(msg.getMessage().get("language")) ? (AwarenessInfo)msg.getMessage().get("content") : ("jadex-xml".equals(msg.getMessage().get("language")) ? (AwarenessInfo)JavaReader.objectFromByteArray((byte[])((byte[])msg.getMessage().get("content")), (ClassLoader)this.getClass().getClassLoader(), (IErrorReporter)IErrorReporter.IGNORE) : (AwarenessInfo)BinarySerializer.objectFromByteArray((byte[])((byte[])msg.getMessage().get("content")), null, null, (ClassLoader)this.getClass().getClassLoader(), null));
        String id = info.getSender().getPlatformName();
        PlatformInfo platform = this.platforms.get(id);
        boolean bl = initial = platform != null && platform.getAwarenessInfo() == null && "online".equals(info.getState());
        if (platform != null) {
            platform.setAwarenessInfo(info);
            platform.setPreferredCodecs(pcodecs);
            if (this.statsdb != null) {
                this.statsdb.save(platform);
            }
        }
        this.sendAwarenessInfos(info, pcodecs, true, initial);
    }

    public void handleOffline(String hostip, InputStream in) throws Exception {
        AwarenessInfo awainfo;
        String id = RelayHandler.readString(in);
        RelayHandler.readData(in, 4);
        PlatformInfo pi = this.platforms.get(id);
        if (pi == null) {
            throw new RuntimeException("No such platform: " + id);
        }
        if (!hostip.equals(pi.getHostIP())) {
            throw new RuntimeException("Offline request from wrong IP: " + id + ", " + hostip + ", " + pi.getHostIP());
        }
        PlatformInfo platform = this.platforms.remove(id);
        if (platform != null) {
            platform.disconnect();
            if (this.statsdb != null) {
                this.statsdb.save(platform);
            }
        }
        AwarenessInfo awarenessInfo = awainfo = platform != null ? platform.getAwarenessInfo() : null;
        if (awainfo != null) {
            awainfo.setState("offline");
            this.sendAwarenessInfos(awainfo, platform.getPreferredCodecs(), true, false);
        } else if (platform != null) {
            this.sendPlatformInfo(platform);
        }
        IBlockingQueue<Message> queue = this.map.get(id);
        if (queue != null) {
            List items = queue.setClosed(true);
            this.map.remove(id);
            for (int i = 0; i < items.size(); ++i) {
                ((Message)items.get(i)).getFuture().setException((Exception)new RuntimeException("Target disconnected."));
            }
        }
    }

    public void handlePlatform(InputStream in) throws Exception {
        String peerurl = RelayHandler.readString(in);
        byte[] len = RelayHandler.readData(in, 4);
        int length = SUtil.bytesToInt((byte[])len);
        byte[] buffer = RelayHandler.readData(in, length - 1);
        PlatformInfo info = (PlatformInfo)MapSendTask.decodeMessage((byte[])buffer, this.codecs, (ClassLoader)this.getClass().getClassLoader(), (IErrorReporter)IErrorReporter.IGNORE);
        ICodec[] pcodecs = MapSendTask.getCodecs((byte[])buffer, this.codecs);
        PeerHandler peer = this.peers.addPeer(peerurl);
        peer.updatePlatformInfo(info);
        if (info.getAwarenessInfo() != null) {
            this.sendAwarenessInfos(info.getAwarenessInfo(), pcodecs, false, false);
        }
    }

    public void handlePlatforms(InputStream in) throws Exception {
        String peerurl = RelayHandler.readString(in);
        byte[] len = RelayHandler.readData(in, 4);
        int length = SUtil.bytesToInt((byte[])len);
        byte[] buffer = RelayHandler.readData(in, length - 1);
        PlatformInfo[] infos = (PlatformInfo[])MapSendTask.decodeMessage((byte[])buffer, this.codecs, (ClassLoader)this.getClass().getClassLoader(), (IErrorReporter)IErrorReporter.IGNORE);
        ICodec[] pcodecs = MapSendTask.getCodecs((byte[])buffer, this.codecs);
        PeerHandler peer = this.peers.addPeer(peerurl);
        LinkedHashMap<String, PlatformInfo> old = new LinkedHashMap<String, PlatformInfo>();
        for (PlatformInfo info : peer.getPlatformInfos()) {
            if (info.getAwarenessInfo() == null) continue;
            old.put(info.getId(), info);
        }
        peer.clearPlatformInfos();
        for (PlatformInfo info : infos) {
            peer.updatePlatformInfo(info);
            if (info.getAwarenessInfo() == null) continue;
            this.sendAwarenessInfos(info.getAwarenessInfo(), pcodecs, false, false);
            old.remove(info.getId());
        }
        for (PlatformInfo info : old.values()) {
            AwarenessInfo awainfo = info.getAwarenessInfo();
            awainfo.setState("offline");
            this.sendAwarenessInfos(awainfo, pcodecs, false, false);
        }
    }

    public void handleSyncRequest(String peerid, int startid, int cnt, OutputStream out) throws Exception {
        PlatformInfo[] pi = this.getStatisticsDB().getPlatformInfosForSync(peerid, startid, cnt);
        byte[] entries = MapSendTask.encodeMessage((Object)pi, (ICodec[])this.defcodecs, (ClassLoader)this.getClass().getClassLoader(), null);
        out.write(entries);
    }

    public PlatformInfo[] getCurrentPlatforms() {
        return this.platforms.values().toArray(new PlatformInfo[0]);
    }

    public StatsDB getStatisticsDB() {
        return this.statsdb;
    }

    public PeerHandler[] getCurrentPeers() {
        return this.peers.getPeers();
    }

    public String handleServersRequest(String requesturl, String peerurl, String peerid, int peerstate, boolean initial) {
        if (peerurl != null) {
            PeerHandler peer = this.peers.addPeer(peerurl, peerid, peerstate);
            if (initial) {
                peer.setSent(true);
                this.sendPlatformInfos(peer, this.getCurrentPlatforms());
            }
        }
        return this.peers.getURLs(requesturl);
    }

    public void sendPlatformInfo(PlatformInfo info) {
        try {
            byte[] peerinfo = null;
            for (PeerHandler peer : this.peers.getPeers()) {
                if (peerinfo == null) {
                    peerinfo = MapSendTask.encodeMessage((Object)info, (ICodec[])this.defcodecs, (ClassLoader)this.getClass().getClassLoader(), null);
                }
                peer.addDebugText(3, "Sending platform info to peer " + info.getId());
                this.conman.postMessage(peer.getUrl() + "platforminfo", (IComponentIdentifier)new BasicComponentIdentifier(this.settings.getUrl()), (byte[][])new byte[][]{peerinfo});
                peer.addDebugText(3, "Sent platform info to peer " + info.getId());
            }
        }
        catch (IOException e) {
            for (PeerHandler peer : this.peers.getPeers()) {
                if (!peer.isConnected()) continue;
                peer.addDebugText(3, "Error sending platform info to peer: " + peer.getUrl() + "platforminfo, " + e);
            }
            RelayHandler.getLogger().warning("Error sending platform info to peer: " + e);
        }
    }

    public void sendPlatformInfos(PeerHandler peer, PlatformInfo[] infos) {
        try {
            peer.addDebugText(3, "Sending platform infos to peer: " + infos.length);
            byte[] peerinfo = MapSendTask.encodeMessage((Object)infos, (ICodec[])this.defcodecs, (ClassLoader)this.getClass().getClassLoader(), null);
            this.conman.postMessage(RelayConnectionManager.httpAddress((String)peer.getUrl()) + "platforminfos", (IComponentIdentifier)new BasicComponentIdentifier(this.settings.getUrl()), (byte[][])new byte[][]{peerinfo});
            peer.addDebugText(3, "Sent platform infos.");
        }
        catch (IOException e) {
            peer.addDebugText(3, "Error sending platform infos to peer: " + peer.getUrl() + "platforminfos, " + e);
            RelayHandler.getLogger().warning("Error sending platform infos to peer: " + peer.getUrl() + "platforminfos, " + e);
        }
    }

    protected void sendAwarenessInfos(AwarenessInfo awainfo, ICodec[] pcodecs, boolean local, boolean initial) {
        pcodecs = pcodecs != null ? pcodecs : this.defcodecs;
        String id = awainfo.getSender().getPlatformName();
        PlatformInfo platform = this.platforms.get(id);
        if (platform == null || local) {
            byte[] propinfo = null;
            byte[] nopropinfo = null;
            Map.Entry[] platformentries = this.map.entrySet().toArray(new Map.Entry[0]);
            for (int i = 0; i < platformentries.length; ++i) {
                AwarenessInfo awainfo2;
                PlatformInfo p2 = this.platforms.get(platformentries[i].getKey());
                AwarenessInfo awarenessInfo = awainfo2 = p2 != null ? p2.getAwarenessInfo() : null;
                if (awainfo2 == null || id.equals(platformentries[i].getKey())) continue;
                try {
                    if (awainfo2.getProperties() == null && nopropinfo == null) {
                        AwarenessInfo awanoprop = awainfo;
                        if (awainfo.getProperties() != null) {
                            awanoprop = new AwarenessInfo(awainfo.getSender(), awainfo.getState(), awainfo.getDelay(), awainfo.getIncludes(), awainfo.getExcludes(), awainfo.getMasterId(), SReflect.getInnerClassName(this.getClass()));
                            awanoprop.setProperties(null);
                        }
                        byte[] data = MapSendTask.encodeMessage((Object)awanoprop, (ICodec[])pcodecs, (ClassLoader)this.getClass().getClassLoader(), null);
                        nopropinfo = new byte[data.length + 4];
                        System.arraycopy(SUtil.intToBytes((int)data.length), 0, nopropinfo, 0, 4);
                        System.arraycopy(data, 0, nopropinfo, 4, data.length);
                        if (awainfo.getProperties() == null) {
                            propinfo = nopropinfo;
                        }
                    } else if (awainfo2.getProperties() != null && propinfo == null) {
                        byte[] data = MapSendTask.encodeMessage((Object)awainfo, (ICodec[])pcodecs, (ClassLoader)this.getClass().getClassLoader(), null);
                        propinfo = new byte[data.length + 4];
                        System.arraycopy(SUtil.intToBytes((int)data.length), 0, propinfo, 0, 4);
                        System.arraycopy(data, 0, propinfo, 4, data.length);
                        if (awainfo.getProperties() == null) {
                            nopropinfo = propinfo;
                        }
                    }
                    ((IBlockingQueue)platformentries[i].getValue()).enqueue((Object)new Message(3, new ByteArrayInputStream(awainfo2.getProperties() == null ? nopropinfo : propinfo)));
                }
                catch (Exception data) {
                    // empty catch block
                }
                if (!initial) continue;
                if (awainfo.getProperties() == null && awainfo2.getProperties() != null) {
                    awainfo2 = new AwarenessInfo(awainfo2.getSender(), awainfo2.getState(), awainfo2.getDelay(), awainfo2.getIncludes(), awainfo2.getExcludes(), awainfo2.getMasterId(), SReflect.getInnerClassName(this.getClass()));
                    awainfo2.setProperties(null);
                }
                byte[] data2 = MapSendTask.encodeMessage((Object)awainfo2, (ICodec[])pcodecs, (ClassLoader)this.getClass().getClassLoader(), null);
                byte[] info2 = new byte[data2.length + 4];
                System.arraycopy(SUtil.intToBytes((int)data2.length), 0, info2, 0, 4);
                System.arraycopy(data2, 0, info2, 4, data2.length);
                try {
                    this.map.get(id).enqueue((Object)new Message(3, new ByteArrayInputStream(info2)));
                    continue;
                }
                catch (IBlockingQueue.ClosedException closedException) {
                    // empty catch block
                }
            }
            if (initial) {
                PeerHandler[] apeers;
                for (PeerHandler peer : apeers = this.peers.getPeers()) {
                    PlatformInfo[] infos;
                    if (!peer.isConnected()) continue;
                    for (PlatformInfo pi : infos = peer.getPlatformInfos()) {
                        if (pi.getAwarenessInfo() == null) continue;
                        AwarenessInfo awainfo2 = pi.getAwarenessInfo();
                        if (awainfo.getProperties() == null && awainfo2.getProperties() != null) {
                            awainfo2 = new AwarenessInfo(awainfo2.getSender(), awainfo2.getState(), awainfo2.getDelay(), awainfo2.getIncludes(), awainfo2.getExcludes(), awainfo2.getMasterId(), SReflect.getInnerClassName(this.getClass()));
                            awainfo2.setProperties(null);
                        }
                        byte[] data2 = MapSendTask.encodeMessage((Object)awainfo2, (ICodec[])platform.getPreferredCodecs(), (ClassLoader)this.getClass().getClassLoader(), null);
                        byte[] info2 = new byte[data2.length + 4];
                        System.arraycopy(SUtil.intToBytes((int)data2.length), 0, info2, 0, 4);
                        System.arraycopy(data2, 0, info2, 4, data2.length);
                        try {
                            this.map.get(id).enqueue((Object)new Message(3, new ByteArrayInputStream(info2)));
                        }
                        catch (IBlockingQueue.ClosedException closedException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (local) {
                if (platform == null) {
                    platform = new PlatformInfo();
                    platform.setId(awainfo.getSender().getName());
                    platform.setDisconnectDate(new Date());
                    awainfo.setState("offline");
                    platform.setAwarenessInfo(awainfo);
                }
                this.sendPlatformInfo(platform);
            }
        }
    }

    public static String readString(InputStream in) throws IOException {
        byte[] len = RelayHandler.readData(in, 4);
        int length = SUtil.bytesToInt((byte[])len);
        byte[] buffer = RelayHandler.readData(in, length);
        return new String(buffer, "UTF-8");
    }

    protected static byte[] readData(InputStream is, int length) throws IOException {
        int read;
        byte[] buffer = new byte[length];
        for (int num = 0; num < length; num += read) {
            read = is.read(buffer, num, length - num);
            if (read != -1) continue;
            throw new IOException("Stream closed.");
        }
        return buffer;
    }

    public static Logger getLogger() {
        return Logger.getLogger("jadex.relay");
    }

    static {
        String home = System.getenv("RELAY_HOME");
        File dir = home != null ? new File(home) : ("true".equals(System.getProperty("relay.standalone")) ? new File(".", ".relaystats") : new File(System.getProperty("user.home"), ".relaystats"));
        if (!dir.exists()) {
            if (!dir.mkdirs()) {
                RelayHandler.getLogger().info("Cannot mkdirs: " + dir);
            }
        } else if (!dir.isDirectory()) {
            throw new RuntimeException("Settings path '" + dir + "' is not a directory.");
        }
        SYSTEMDIR = dir;
        RelayHandler.getLogger().info("Relay settings directory (change with $RELAY_HOME): " + SYSTEMDIR.getAbsolutePath());
    }
}

