/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.relay;

import jadex.base.relay.GeoIPService;
import jadex.bridge.service.types.awareness.AwarenessInfo;
import jadex.bridge.service.types.message.ICodec;
import jadex.commons.SUtil;
import jadex.commons.future.Future;
import jadex.commons.future.IFuture;
import jadex.commons.transformation.annotations.Exclude;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Map;

public final class PlatformInfo {
    public static final ThreadLocal<DateFormat> TIME_FORMAT_SHORT = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("k:mm:ss z");
        }
    };
    public static final ThreadLocal<DateFormat> TIME_FORMAT_LONG = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            return new SimpleDateFormat("k:mm:ss z, EEE, MMM d, yyyy");
        }
    };
    protected Integer dbid;
    protected String id;
    protected String peerid;
    protected String hostip;
    protected String hostname;
    protected IFuture<String> hostnamefut;
    protected String scheme;
    protected Date connect_time;
    protected Date disconnect_time;
    protected double bytes_received;
    protected double total_transmission_time;
    protected int msg_cnt;
    protected AwarenessInfo awainfo;
    protected ICodec[] pcodecs;
    protected Map<String, String> properties;

    public PlatformInfo() {
    }

    public PlatformInfo(String id, String peerid, String hostip, String hostname, String protocol) {
        this(null, peerid, id, hostip, hostname, protocol, new Date(), null, 0, 0.0, 0.0);
    }

    public PlatformInfo(Integer dbid, String peerid, String id, String hostip, String hostname, String protocol, Date connect_time, Date disconnect_time, int msg_cnt, double bytes_received, double total_transmission_time) {
        this.dbid = dbid;
        this.peerid = peerid;
        this.id = id != null ? SUtil.makeConform((String)id) : null;
        this.hostip = hostip != null ? SUtil.makeConform((String)hostip) : null;
        this.hostname = hostname != null ? SUtil.makeConform((String)hostname) : null;
        this.scheme = protocol != null ? SUtil.makeConform((String)protocol) : null;
        this.connect_time = connect_time;
        this.disconnect_time = disconnect_time;
        this.msg_cnt = msg_cnt;
        this.bytes_received = bytes_received;
        this.total_transmission_time = total_transmission_time;
        if (hostname == null || hostname.equals(hostip)) {
            final Future fut = new Future();
            new Thread(new Runnable(){

                @Override
                public void run() {
                    try {
                        String tmp = InetAddress.getByName(PlatformInfo.this.hostip).getCanonicalHostName();
                        if (tmp.equals(PlatformInfo.this.hostip)) {
                            tmp = "IP " + tmp;
                        }
                        fut.setResult((Object)tmp);
                    }
                    catch (UnknownHostException e) {
                        fut.setResult((Object)"unknown");
                    }
                }
            }).start();
            this.hostnamefut = fut;
        }
    }

    public String getId() {
        return this.id;
    }

    public String getHostIP() {
        return this.hostip;
    }

    public String getHostName() {
        if (this.hostnamefut != null) {
            this.hostname = (String)this.hostnamefut.get();
            this.hostnamefut = null;
        }
        return this.hostname;
    }

    public String getScheme() {
        return this.scheme;
    }

    public String getConnectTime() {
        if (this.connect_time != null) {
            GregorianCalendar cal = new GregorianCalendar();
            GregorianCalendar con = new GregorianCalendar();
            con.setTime(this.connect_time);
            DateFormat df = con.get(1) != cal.get(1) || con.get(2) != cal.get(2) || con.get(5) != cal.get(5) ? TIME_FORMAT_LONG.get() : TIME_FORMAT_SHORT.get();
            return df.format(this.connect_time);
        }
        return "false";
    }

    public String getDisconnectTime() {
        if (this.disconnect_time != null) {
            GregorianCalendar cal = new GregorianCalendar();
            GregorianCalendar con = new GregorianCalendar();
            con.setTime(this.disconnect_time);
            DateFormat df = con.get(1) != cal.get(1) || con.get(2) != cal.get(2) || con.get(5) != cal.get(5) ? TIME_FORMAT_LONG.get() : TIME_FORMAT_SHORT.get();
            return df.format(this.disconnect_time);
        }
        return "false";
    }

    public Date getConnectDate() {
        return this.connect_time;
    }

    public Date getDisconnectDate() {
        return this.disconnect_time;
    }

    public int getMessageCount() {
        return this.msg_cnt;
    }

    public String getByteCount() {
        return SUtil.bytesToString((long)((long)this.bytes_received));
    }

    public double getBytes() {
        return this.bytes_received;
    }

    public String getTransferRate() {
        double val = this.bytes_received / this.total_transmission_time;
        return SUtil.bytesToString((long)((long)val)) + " / sec.";
    }

    public double getTransferTime() {
        return this.total_transmission_time;
    }

    public AwarenessInfo getAwarenessInfo() {
        return this.awainfo;
    }

    public Integer getDBId() {
        return this.dbid;
    }

    public String getPeerId() {
        return this.peerid;
    }

    public String getLocation() {
        return GeoIPService.getGeoIPService().getLocation(this.hostip);
    }

    public String getCountryCode() {
        return GeoIPService.getGeoIPService().getCountryCode(this.hostip);
    }

    public String getPosition() {
        return GeoIPService.getGeoIPService().getPosition(this.hostip);
    }

    public void addMessage(int bytes, long time) {
        ++this.msg_cnt;
        this.bytes_received += (double)bytes;
        this.total_transmission_time += (double)time / 1000000.0;
    }

    public void reconnect(String hostip, String hostname) {
        if (!hostip.equals(this.hostip)) {
            throw new RuntimeException("Platform " + this.id + " already connected from different ip: " + this.hostip);
        }
        this.hostname = hostname;
        this.setAwarenessInfo(null);
    }

    public void disconnect() {
        this.disconnect_time = new Date();
    }

    public void setAwarenessInfo(AwarenessInfo awainfo) {
        this.awainfo = awainfo;
        if (awainfo != null) {
            this.setProperties(awainfo.getProperties());
        }
    }

    public void setDBId(Integer dbid) {
        this.dbid = dbid;
    }

    public void setPeerId(String peerid) {
        this.peerid = peerid;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String toString() {
        return "PlatformInfo(id=" + this.getDBId() + ", peer=" + this.getPeerId() + ", platform=" + this.getId() + ", host=" + this.getHostName() + "(" + this.getHostIP() + "), scheme=" + this.getScheme() + ", connected=" + this.getConnectTime() + ", disconnected=" + this.getDisconnectTime() + ", messages=" + this.getMessageCount() + "(" + this.getByteCount() + "), rate=" + this.getTransferRate() + ", properties=" + this.properties + ")";
    }

    public void setDisconnectDate(Date distime) {
        this.disconnect_time = distime;
    }

    public void setConnectDate(Date contime) {
        this.connect_time = contime;
    }

    public void setHostIP(String hostip) {
        this.hostip = hostip;
    }

    public void setHostName(String hostname) {
        this.hostname = hostname;
    }

    @Exclude
    public ICodec[] getPreferredCodecs() {
        return this.pcodecs;
    }

    @Exclude
    public void setPreferredCodecs(ICodec[] pcodecs) {
        this.pcodecs = pcodecs;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, String> props) {
        this.properties = props;
    }
}

