/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.relay;

import jadex.base.relay.PeerHandler;
import jadex.base.relay.RelayHandler;
import jadex.platform.service.message.transport.httprelaymtp.RelayConnectionManager;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;

public class PeerList {
    protected RelayHandler handler;
    protected Map<String, PeerHandler> peers;

    public PeerList(RelayHandler handler) {
        this.handler = handler;
        this.peers = Collections.synchronizedMap(new HashMap());
    }

    public void dispose() {
        for (PeerHandler handler : this.peers.values().toArray(new PeerHandler[0])) {
            handler.shutdown();
        }
    }

    public String getURLs(String request) {
        String ret;
        if (!this.handler.getSettings().isUrlSpecified()) {
            ret = request;
            if (ret.endsWith("/servers")) {
                ret = ret.substring(0, ret.length() - 7);
            }
            ret = RelayConnectionManager.relayAddress((String)ret);
        } else {
            PeerHandler[] apeers;
            StringBuffer sret = new StringBuffer();
            sret.append(this.handler.getSettings().getUrl());
            for (PeerHandler peer : apeers = this.getPeers()) {
                if (!peer.isConnected()) continue;
                sret.append(", ");
                sret.append(peer.getUrl());
            }
            ret = sret.toString();
        }
        return ret;
    }

    public PeerHandler[] getPeers() {
        return this.peers.values().toArray(new PeerHandler[0]);
    }

    public boolean checkPlatform(String id) {
        boolean found = false;
        for (PeerHandler peer : this.peers.values().toArray(new PeerHandler[0])) {
            if (!peer.checkPlatform(id)) continue;
            found = true;
            break;
        }
        return found;
    }

    public void addPeers(String peerurls, boolean initial) {
        if (peerurls != null) {
            StringTokenizer stok = new StringTokenizer(peerurls, ",");
            while (stok.hasMoreTokens()) {
                this.addPeer(stok.nextToken().trim(), null, -1, true);
            }
        }
    }

    public PeerHandler addPeer(String peerurl) {
        return this.addPeer(peerurl, null, -1);
    }

    public PeerHandler addPeer(String peerurl, String peerid, int peerstate) {
        return this.addPeer(peerurl, peerid, peerstate, false);
    }

    public void removePeer(PeerHandler peer) {
        this.peers.remove(peer.getUrl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected PeerHandler addPeer(String peerurl, String peerid, int peerstate, boolean initial) {
        PeerHandler peer = null;
        peerurl = RelayConnectionManager.httpAddress((String)peerurl);
        if (!this.handler.getSettings().isUrlSpecified()) {
            throw new RuntimeException("No peer connections allowed, if public URL not set.");
        }
        if (!RelayConnectionManager.isSameServer((String)this.handler.getSettings().getUrl(), (String)peerurl)) {
            PeerHandler handler;
            Map<String, PeerHandler> map = this.peers;
            synchronized (map) {
                peer = this.peers.get(peerurl);
                if (peer == null) {
                    peer = new PeerHandler(this.handler, peerurl, initial);
                    this.peers.put(peerurl, peer);
                }
            }
            if (peerid != null && peerstate != -1 && (handler = this.peers.get(peerurl)) != null) {
                handler.setPeerState(peerid, peerstate);
            }
        }
        return peer;
    }
}

