/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.relay;

import jadex.base.relay.GeoIPService;
import jadex.base.relay.PlatformInfo;
import jadex.base.relay.RelayHandler;
import jadex.bridge.service.types.awareness.AwarenessInfo;
import jadex.platform.service.message.MapSendTask;
import jadex.platform.service.message.transport.codecs.CodecFactory;
import jadex.platform.service.message.transport.httprelaymtp.RelayConnectionManager;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;

public class PeerHandler
implements Runnable {
    public static final long DELAY_ONLINE = 30000L;
    public static final long DELAY_OFFLINE = 30000L;
    protected RelayHandler handler;
    protected String url;
    protected boolean initial;
    protected boolean connected;
    protected Map<String, PlatformInfo> infos;
    protected boolean sent;
    protected String debugtext;
    protected String peerid;
    protected int peerstate;
    protected boolean shutdown;

    public PeerHandler(RelayHandler handler, String url, boolean initial) {
        this.handler = handler;
        this.url = url;
        this.initial = initial;
        this.infos = Collections.synchronizedMap(new LinkedHashMap());
        this.debugtext = "";
        this.peerid = null;
        this.peerstate = -1;
        new Thread(this).start();
    }

    public String getUrl() {
        return this.url;
    }

    public void setSent(boolean sent) {
        this.sent = sent;
        this.addDebugText(2, "set sent to " + sent);
    }

    public void setConnected(boolean connected) {
        if (this.connected != connected) {
            this.addDebugText(1, "Peer " + (connected ? "online" : "offline"));
        }
        this.connected = connected;
        if (!connected) {
            this.sent = false;
        }
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isSent() {
        return this.sent;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public void updatePlatformInfo(PlatformInfo info) {
        if (info.getDisconnectDate() != null || info.getAwarenessInfo() != null && "offline".equals(info.getAwarenessInfo().getState())) {
            this.addDebugText(3, "Remove platform " + info.getId());
            this.infos.remove(info.getId());
        } else {
            this.addDebugText(3, "Add/update platform " + info.getId());
            this.infos.put(info.getId(), info);
        }
    }

    public PlatformInfo[] getPlatformInfos() {
        return this.infos.values().toArray(new PlatformInfo[0]);
    }

    public void clearPlatformInfos() {
        this.addDebugText(2, "Clear platforms");
        this.infos.clear();
    }

    public String getHost() {
        String ret = null;
        try {
            ret = new URL(RelayConnectionManager.httpAddress((String)this.url)).getHost();
        }
        catch (MalformedURLException e) {
            RelayHandler.getLogger().warning("" + e);
        }
        return ret;
    }

    public String getLocation() {
        return GeoIPService.getGeoIPService().getLocation(this.getHost());
    }

    public String getCountryCode() {
        return GeoIPService.getGeoIPService().getCountryCode(this.getHost());
    }

    public String getPosition() {
        return GeoIPService.getGeoIPService().getPosition(this.getHost());
    }

    public String getDebugText() {
        return this.debugtext;
    }

    public synchronized void addDebugText(int level, String msg) {
        if (this.handler.getSettings().getDebugLevel() >= level) {
            this.debugtext = this.debugtext + new Date().toString() + ": " + msg + "&#xD;";
        }
    }

    public boolean checkPlatform(String id) {
        return this.infos.containsKey(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.shutdown) {
            StringWriter sw;
            if (this.handler.getSettings().isDBSync() && this.peerstate != -1 && this.handler.getStatisticsDB() != null) {
                int localstate = this.handler.getStatisticsDB().getLatestEntry(this.peerid);
                if (localstate < this.peerstate) {
                    try {
                        PlatformInfo[] pinfos;
                        this.addDebugText(2, "DB synchronization with: " + this.getUrl() + ", local=" + localstate + ", remote=" + this.peerstate);
                        RelayHandler.getLogger().info("Start DB synchronization with: " + this.getUrl() + ", local=" + localstate + ", remote=" + this.peerstate);
                        byte[] infos = this.handler.getConnectionManager().getDBEntries(this.getUrl(), this.peerid, localstate + 1, 1000);
                        for (PlatformInfo info : pinfos = (PlatformInfo[])MapSendTask.decodeMessage((byte[])infos, (Map)new CodecFactory().getAllCodecs(), (ClassLoader)this.getClass().getClassLoader(), null)) {
                            this.handler.getStatisticsDB().save(info);
                        }
                        RelayHandler.getLogger().info("Finished DB synchronization with: " + this.getUrl() + ", local=" + localstate + ", remote=" + this.peerstate);
                    }
                    catch (Exception e) {
                        sw = new StringWriter();
                        e.printStackTrace(new PrintWriter(sw));
                        this.addDebugText(2, "Exception fetching DB update: " + sw);
                        RelayHandler.getLogger().warning("Exception fetching DB update: " + sw);
                    }
                }
                this.peerstate = -1;
                continue;
            }
            boolean connected = this.isConnected();
            try {
                this.addDebugText(3, "Pinging peer");
                int dbstate = this.handler.getStatisticsDB() != null ? this.handler.getStatisticsDB().getLatestEntry(this.handler.getSettings().getId()) : -1;
                String servers = this.handler.getConnectionManager().getPeerServers(this.getUrl(), this.handler.getSettings().getUrl(), this.handler.getSettings().getId(), dbstate, !this.isConnected());
                this.setConnected(true);
                this.handler.getPeerList().addPeers(servers, false);
            }
            catch (Exception e) {
                sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                this.addDebugText(connected ? 2 : 3, "Exception pinging peer: " + sw);
                this.setConnected(false);
            }
            if (this.isConnected()) {
                if (connected != this.isConnected()) {
                    this.peerOnline();
                }
                PeerHandler peerHandler = this;
                synchronized (peerHandler) {
                    try {
                        this.wait(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            if (this.isInitial()) {
                if (connected != this.isConnected()) {
                    this.peerOffline();
                }
                PeerHandler peerHandler = this;
                synchronized (peerHandler) {
                    try {
                        this.wait(30000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            this.shutdown = true;
            this.handler.getPeerList().removePeer(this);
            this.peerOffline();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPeerState(String peerid, int peerstate) {
        this.peerid = peerid;
        this.peerstate = peerstate;
        PeerHandler peerHandler = this;
        synchronized (peerHandler) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.shutdown = true;
        PeerHandler peerHandler = this;
        synchronized (peerHandler) {
            this.notify();
        }
    }

    protected void peerOnline() {
        RelayHandler.getLogger().info("Peer added: " + this.getUrl());
        if (!this.isSent()) {
            this.setSent(true);
            this.handler.sendPlatformInfos(this, this.handler.getCurrentPlatforms());
        }
    }

    protected void peerOffline() {
        RelayHandler.getLogger().info("Peer removed: " + this.getUrl());
        PlatformInfo[] infos = this.getPlatformInfos();
        this.clearPlatformInfos();
        this.setSent(false);
        for (PlatformInfo info : infos) {
            if (info.getAwarenessInfo() == null || this.handler.getPeerList().checkPlatform(info.getId())) continue;
            AwarenessInfo awainfo = info.getAwarenessInfo();
            awainfo.setState("offline");
            this.handler.sendAwarenessInfos(awainfo, null, false, false);
        }
    }
}

