/*
 * Decompiled with CFR 0.152.
 */
package jadex.base.relay;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Random;

public class JadexRelayExample {
    public static final String ADDRESS = "http://www.activecomponents.org/relay/";
    public static final byte MSGTYPE_DEFAULT = 1;
    public static final byte MSGTYPE_PING = 2;
    protected static final byte[] RESPONSE_BUF = new byte[8192];

    public static void main(String[] args) throws Exception {
        String id = "RelayExample_" + new Random().nextInt(1000);
        JadexRelayExample.connect(id);
        JadexRelayExample.send(id, "Hello Relay World!".getBytes("UTF-8"));
        JadexRelayExample.send(id, "some more testing...".getBytes("UTF-8"));
        Thread.sleep(1000L);
        System.exit(0);
    }

    public static void deliverMessage(byte[] rawmsg) {
        try {
            System.out.println("Message received: " + new String(rawmsg, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void connect(String id) throws Exception {
        int read;
        URL url = new URL("http://www.activecomponents.org/relay/?id=" + URLEncoder.encode(id, "UTF-8"));
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setUseCaches(false);
        final InputStream in = con.getInputStream();
        while ((read = in.read()) != -1 && read != 2) {
            System.out.println(read);
        }
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    while (true) {
                        int bytes_read;
                        int b;
                        if ((b = in.read()) == -1) {
                            throw new IOException("Stream closed");
                        }
                        if (b == 2) {
                            System.out.println("Received server ping");
                            continue;
                        }
                        if (b != 1) continue;
                        byte[] rawmsg = null;
                        byte[] asize = new byte[4];
                        for (int i = 0; i < asize.length; ++i) {
                            b = in.read();
                            if (b == -1) {
                                throw new IOException("Stream closed");
                            }
                            asize[i] = (byte)b;
                        }
                        int msg_size = JadexRelayExample.bytesToInt(asize);
                        if (msg_size <= 0) continue;
                        rawmsg = new byte[msg_size];
                        for (int count = 0; count < msg_size; count += bytes_read) {
                            bytes_read = in.read(rawmsg, count, msg_size - count);
                            if (bytes_read != -1) continue;
                            throw new IOException("Stream closed");
                        }
                        JadexRelayExample.deliverMessage(rawmsg);
                    }
                }
                catch (Exception e) {
                    System.out.println("Disconnected: " + e);
                    return;
                }
            }
        }).start();
    }

    public static void send(String id, byte[] data) throws IOException {
        byte[] iddata = id.getBytes("UTF-8");
        URL url = new URL(ADDRESS);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        con.setUseCaches(false);
        con.setRequestProperty("Content-Type", "application/octet-stream");
        con.setRequestProperty("Content-Length", "" + (4 + iddata.length + 4 + data.length));
        con.connect();
        OutputStream out = con.getOutputStream();
        out.write(JadexRelayExample.intToBytes(iddata.length));
        out.write(iddata);
        out.write(JadexRelayExample.intToBytes(data.length));
        out.write(data);
        out.flush();
        int code = con.getResponseCode();
        if (code != 200) {
            throw new IOException("Message not sent. HTTP code " + code + ": " + con.getResponseMessage() + " target=" + id);
        }
        while (con.getInputStream().read(RESPONSE_BUF) != -1) {
        }
    }

    public static int bytesToInt(byte[] buffer) {
        if (buffer.length != 4) {
            throw new IllegalArgumentException("buffer length must be 4 bytes!");
        }
        int value = (0xFF & buffer[0]) << 24;
        value |= (0xFF & buffer[1]) << 16;
        value |= (0xFF & buffer[2]) << 8;
        return value |= 0xFF & buffer[3];
    }

    public static byte[] intToBytes(int val) {
        byte[] buffer = new byte[]{(byte)(val >>> 24 & 0xFF), (byte)(val >>> 16 & 0xFF), (byte)(val >>> 8 & 0xFF), (byte)(val & 0xFF)};
        return buffer;
    }
}

